/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.authz.RequestAuthorizer;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.http.Resolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessTokenRequestAuthorizer
implements RequestAuthorizer {
    public static final String FORM_MEDIA_TYPE = "application/x-www-form-urlencoded";
    public static final String GRANT_TYPE_PARAM_NAME = "grant_type";
    private final Resolver<Boolean> secureConnectionRequired;
    private final RequestAuthorizer originAuthorizer;
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessTokenRequestAuthorizer.class);
    private boolean secureWarned;

    public DefaultAccessTokenRequestAuthorizer(Resolver<Boolean> secureConnectionRequired, RequestAuthorizer originAuthorizer) {
        Assert.notNull(secureConnectionRequired, (String)"secure resolver cannot be null.");
        Assert.notNull((Object)originAuthorizer, (String)"origin RequestAuthorizer cannot be null.");
        this.secureConnectionRequired = secureConnectionRequired;
        this.originAuthorizer = originAuthorizer;
    }

    public Resolver<Boolean> getSecureConnectionRequired() {
        return this.secureConnectionRequired;
    }

    public RequestAuthorizer getOriginAuthorizer() {
        return this.originAuthorizer;
    }

    @Override
    public void assertAuthorized(HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        if (!HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            String msg = "HTTP POST is required.";
            throw new OAuthException(OAuthErrorCode.INVALID_REQUEST, msg, null);
        }
        String contentType = Strings.clean((String)request.getContentType());
        if (contentType == null || !contentType.startsWith(FORM_MEDIA_TYPE)) {
            String msg = "Content-Type must be application/x-www-form-urlencoded";
            throw new OAuthException(OAuthErrorCode.INVALID_REQUEST, msg, null);
        }
        String grantType = Strings.clean((String)request.getParameter(GRANT_TYPE_PARAM_NAME));
        if (grantType == null) {
            String msg = "Missing grant_type value.";
            throw new OAuthException(OAuthErrorCode.INVALID_REQUEST, msg, null);
        }
        this.assertSecure(request, response);
        this.assertOriginAuthorized(request, response);
    }

    protected void assertSecure(HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        boolean secure = request.isSecure();
        boolean secureRequired = this.isSecureConnectionRequired(request, response);
        if (!secure) {
            if (secureRequired) {
                String msg = "A secure HTTPS connection is required for token requests - this is a requirement of the OAuth 2 specification.";
                throw new OAuthException(OAuthErrorCode.INVALID_REQUEST, msg, null);
            }
            if (!this.secureWarned) {
                this.secureWarned = true;
                String msg = "The OAuth 2 specification requires secure HTTPS connections during token requests, but the current configuration allows insecure requests.  The Stormpath SDK default configuration allows insecure requests for convenience during localhost development, but CAUTION: it will automatically throw an OAuthException in production instead of logging this warning (where production is defined as !localhost by default). When you deploy your application to staging and production environments, ensure that HTTPS is always enabled otherwise token requests are not likely to function correctly.";
                log.warn(msg);
            }
        }
    }

    protected boolean isSecureConnectionRequired(HttpServletRequest request, HttpServletResponse response) {
        return this.getSecureConnectionRequired().get(request, response);
    }

    protected void assertOriginAuthorized(HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        this.getOriginAuthorizer().assertAuthorized(request, response);
    }
}

