/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAuthException
extends RuntimeException {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final OAuthErrorCode errorCode;
    private Map<String, Object> errorMap;

    public OAuthException(OAuthErrorCode code) {
        this(code, null, (Exception)null);
    }

    public OAuthException(OAuthErrorCode code, String message) {
        super(message != null ? message : (code != null ? code.getValue() : ""));
        Assert.notNull((Object)code, (String)"OAuthErrorCode cannot be null.");
        this.errorCode = code;
        this.initializeErrorMap();
    }

    public OAuthException(OAuthErrorCode code, String message, Exception cause) {
        super(message != null ? message : (code != null ? code.getValue() : ""), cause);
        Assert.notNull((Object)code, (String)"OAuthErrorCode cannot be null.");
        this.errorCode = code;
        this.initializeErrorMap();
    }

    public OAuthException(OAuthErrorCode code, Map<String, Object> error, String message) {
        this(code, message, null);
        this.errorMap.putAll(error);
    }

    private void initializeErrorMap() {
        this.errorMap = new LinkedHashMap<String, Object>();
        this.errorMap.put("error", this.errorCode.getValue());
        String val = this.getMessage();
        if (Strings.hasText((String)val)) {
            this.errorMap.put("message", val);
        }
    }

    public OAuthErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String toJson() {
        try {
            return objectMapper.writeValueAsString(this.errorMap);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to serialize OAuthException to json.", e);
        }
    }
}

