/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth.config;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.authz.RequestAuthorizer;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.filter.oauth.OriginAccessTokenRequestAuthorizer;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;

public class OriginAccessTokenRequestAuthorizerFactory
extends ConfigSingletonFactory<RequestAuthorizer> {
    public static final String LOCALHOST_RESOLVER = "stormpath.web.localhost.resolver";
    public static final String SERVER_URI_RESOLVER = "stormpath.web.oauth2.origin.authorizer.serverUriResolver";
    public static final String ORIGIN_URIS = "stormpath.web.oauth2.origin.authorizer.originUris";
    public static final String PRODUCES_MIME_TYPES = "stormpath.web.produces";

    @Override
    protected RequestAuthorizer createInstance(ServletContext servletContext) throws Exception {
        ServerUriResolver resolver = (ServerUriResolver)this.getConfig().getInstance(SERVER_URI_RESOLVER);
        Resolver localhost = (Resolver)this.getConfig().getInstance(LOCALHOST_RESOLVER);
        String uris = (String)this.getConfig().get(ORIGIN_URIS);
        String produces = (String)this.getConfig().get(PRODUCES_MIME_TYPES);
        List<String> additionalOriginUris = Collections.emptyList();
        if (Strings.hasText((String)uris)) {
            String[] values = Strings.split((String)uris);
            additionalOriginUris = Arrays.asList(values);
        }
        List<MediaType> producesMimeTypes = MediaType.parseMediaTypes(produces);
        return new OriginAccessTokenRequestAuthorizer(resolver, localhost, additionalOriginUris, producesMimeTypes);
    }
}

