/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import java.security.Principal;

public class AccountPrincipal
implements Principal {
    private final Account account;

    public AccountPrincipal(Account account) {
        Assert.notNull((Object)account, (String)"Account cannot be null.");
        this.account = account;
    }

    @Override
    public String getName() {
        boolean quoted = false;
        String name = null;
        String value = this.account.getGivenName();
        if (Strings.hasText((String)value)) {
            name = "\"" + value;
            quoted = true;
        }
        if (Strings.hasText((String)(value = this.account.getSurname()))) {
            name = quoted ? name + " " + value + "\"" : "\"" + value + "\"";
            quoted = true;
        } else if (quoted) {
            name = name + "\"";
        }
        value = this.account.getEmail();
        name = quoted ? name + " <" + value + ">" : value;
        return name;
    }

    public Account getAccount() {
        return this.account;
    }
}

