/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.http.Saver;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieSaver
implements Saver<String> {
    private final CookieConfig config;

    public CookieSaver(CookieConfig config) {
        Assert.notNull((Object)config, (String)"config cannot be null.");
        this.config = config;
    }

    @Override
    public void set(HttpServletRequest request, HttpServletResponse response, String value) {
        boolean delete;
        boolean bl = delete = !Strings.hasText((String)value);
        if (delete) {
            value = "";
        }
        CookieConfig cfg = this.config;
        Cookie cookie = new Cookie(cfg.getName(), value);
        String val = cfg.getComment();
        if (val != null) {
            cookie.setComment(val);
        }
        if ((val = cfg.getDomain()) != null) {
            cookie.setDomain(val);
        }
        if (!Strings.hasText((String)(val = Strings.clean((String)cfg.getPath())))) {
            val = Strings.clean((String)request.getContextPath());
        }
        if (!Strings.hasText((String)val)) {
            val = "/";
        }
        cookie.setPath(val);
        cookie.setSecure(cfg.isSecure());
        cookie.setHttpOnly(cfg.isHttpOnly());
        int maxAge = delete ? 0 : Math.max(-1, cfg.getMaxAge());
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }
}

