/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.authc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyStatus;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.error.authc.DisabledAccountException;
import com.stormpath.sdk.error.authc.DisabledApiKeyException;
import com.stormpath.sdk.error.authc.InvalidApiKeyException;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationScheme;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractAuthenticationScheme
implements HttpAuthenticationScheme {
    protected Application getApplication(HttpServletRequest request) {
        return (Application)request.getAttribute(Application.class.getName());
    }

    protected ApiKey getEnabledApiKey(HttpServletRequest request, String apiKeyId) throws InvalidApiKeyException, DisabledApiKeyException, DisabledAccountException {
        Application app = this.getApplication(request);
        ApiKey apiKey = app.getApiKey(apiKeyId);
        if (apiKey == null) {
            throw new InvalidApiKeyException(this.newError("apiKey is invalid."));
        }
        if (apiKey.getStatus() != ApiKeyStatus.ENABLED) {
            throw new DisabledApiKeyException(this.newError("apiKey is disabled."));
        }
        Account account = apiKey.getAccount();
        AccountStatus status = account.getStatus();
        if (status != AccountStatus.ENABLED) {
            throw new DisabledAccountException(this.newError("account is disabled."), status);
        }
        return apiKey;
    }

    protected Error newError(final String message) {
        return new Error(){

            public int getStatus() {
                return 0;
            }

            public int getCode() {
                return 0;
            }

            public String getMessage() {
                return message;
            }

            public String getDeveloperMessage() {
                return message;
            }

            public String getMoreInfo() {
                return null;
            }

            public String getRequestId() {
                return null;
            }
        };
    }
}

