/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.authc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationOptions;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.authc.SuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultFailedAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultSuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.http.authc.AuthorizationHeaderParser;
import com.stormpath.sdk.servlet.http.authc.DefaultAuthorizationHeaderParser;
import com.stormpath.sdk.servlet.http.authc.DefaultHttpAuthenticationAttempt;
import com.stormpath.sdk.servlet.http.authc.HeaderAuthenticator;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationAttempt;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationException;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationResult;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.HttpCredentials;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderAuthenticator
implements HeaderAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationHeaderAuthenticator.class);
    private static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final String AUTHORIZATION = "Authorization";
    private final AuthorizationHeaderParser parser = new DefaultAuthorizationHeaderParser();
    private final Map<String, HttpAuthenticationScheme> schemes;
    private final boolean sendChallengeOnFailure;
    private final Publisher<RequestEvent> eventPublisher;

    public AuthorizationHeaderAuthenticator(List<HttpAuthenticationScheme> schemes, boolean sendChallengeOnFailure, Publisher<RequestEvent> eventPublisher) {
        Assert.notEmpty(schemes, (String)"AuthenticationScheme list cannot be null or empty.");
        Assert.notNull(eventPublisher, (String)"Event Publisher cannot be null.");
        this.sendChallengeOnFailure = sendChallengeOnFailure;
        this.eventPublisher = eventPublisher;
        this.schemes = new LinkedHashMap<String, HttpAuthenticationScheme>(schemes.size());
        for (HttpAuthenticationScheme scheme : schemes) {
            this.schemes.put(scheme.getName().toLowerCase(), scheme);
        }
    }

    protected Publisher<RequestEvent> getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public HttpAuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response) {
        String headerValue = request.getHeader(AUTHORIZATION);
        HttpCredentials creds = this.parser.parse(headerValue);
        String schemeName = Strings.clean((String)creds.getSchemeName());
        AuthenticationRequest authcRequest = null;
        if (schemeName != null) {
            HttpAuthenticationScheme scheme = this.schemes.get(creds.getSchemeName().toLowerCase());
            String schemeValue = creds.getSchemeValue();
            if (schemeValue != null) {
                DefaultHttpAuthenticationAttempt attempt = new DefaultHttpAuthenticationAttempt(request, response, creds);
                HttpAuthenticationResult result = null;
                try {
                    authcRequest = this.toAuthenticationRequest(attempt);
                    result = scheme.authenticate(attempt);
                }
                catch (Throwable t) {
                    String msg = "Unable to authenticate request with authentication scheme '" + schemeName + "': " + t.getMessage() + "  Sending HTTP challenge response.";
                    log.debug(msg, t);
                }
                if (result != null) {
                    SuccessfulAuthenticationRequestEvent e = this.createSuccessEvent(attempt, authcRequest, result.getAuthenticationResult());
                    this.publish(e);
                    return result;
                }
            }
        }
        if (this.sendChallengeOnFailure) {
            this.sendChallenge(request, response);
        }
        HttpAuthenticationException ex = new HttpAuthenticationException("Unable to successfully authenticate request with Authorization header.");
        try {
            DefaultFailedAuthenticationRequestEvent evt = new DefaultFailedAuthenticationRequestEvent(request, response, authcRequest, ex);
            this.publish(evt);
        }
        catch (Throwable t) {
            log.warn("Unable to publish failed authentication request event due to exception: {}. Ignoring and propagating original authentication exception {}.", new Object[]{t, ex, t});
        }
        throw ex;
    }

    protected Application getApplication(HttpServletRequest req) {
        return (Application)req.getAttribute(Application.class.getName());
    }

    @Override
    public void sendChallenge(HttpServletRequest request, HttpServletResponse response) {
        String realmName = this.getRealmName(request);
        response.setStatus(401);
        for (HttpAuthenticationScheme scheme : this.schemes.values()) {
            String authcHeader = this.createWwwAuthenticateHeaderValue(scheme, realmName);
            response.addHeader(AUTHENTICATE_HEADER, authcHeader);
        }
    }

    protected String getRealmName(HttpServletRequest request) {
        Application application = this.getApplication(request);
        return application.getName();
    }

    protected String createWwwAuthenticateHeaderValue(HttpAuthenticationScheme scheme, String realmName) {
        return scheme.getName() + " realm=\"" + realmName + "\"";
    }

    protected AuthenticationRequest toAuthenticationRequest(final HttpAuthenticationAttempt attempt) {
        return new AuthenticationRequest(){

            public Object getPrincipals() {
                return attempt.getCredentials();
            }

            public Object getCredentials() {
                return attempt.getCredentials();
            }

            public String getHost() {
                return attempt.getRequest().getRemoteHost();
            }

            public void clear() {
            }

            public AccountStore getAccountStore() {
                return null;
            }

            public AuthenticationOptions getResponseOptions() {
                return null;
            }

            public String getOrganizationNameKey() {
                return null;
            }
        };
    }

    protected SuccessfulAuthenticationRequestEvent createSuccessEvent(HttpAuthenticationAttempt attempt, AuthenticationRequest authcRequest, AuthenticationResult result) {
        return new DefaultSuccessfulAuthenticationRequestEvent(attempt.getRequest(), attempt.getResponse(), authcRequest, result);
    }

    protected void publish(RequestEvent e) {
        this.getEventPublisher().publish(e);
    }
}

