/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.authc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.api.ApiAuthenticationResult;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.authc.AuthenticationResultVisitor;
import com.stormpath.sdk.impl.util.Base64;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.filter.UsernamePasswordRequestFactory;
import com.stormpath.sdk.servlet.http.authc.AbstractAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.DefaultHttpAuthenticationResult;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationAttempt;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationException;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationResult;
import com.stormpath.sdk.servlet.http.impl.StormpathHttpServletRequest;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthenticationScheme
extends AbstractAuthenticationScheme {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String NAME = "Basic";
    private UsernamePasswordRequestFactory usernamePasswordRequestFactory;

    public BasicAuthenticationScheme(UsernamePasswordRequestFactory factory) {
        Assert.notNull((Object)factory, (String)"UsernamePasswordRequestFactory cannot be null.");
        this.usernamePasswordRequestFactory = factory;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public UsernamePasswordRequestFactory getUsernamePasswordRequestFactory() {
        return this.usernamePasswordRequestFactory;
    }

    @Override
    public HttpAuthenticationResult authenticate(HttpAuthenticationAttempt attempt) {
        Assert.notNull((Object)attempt, (String)"attempt cannot be null.");
        Assert.notNull((Object)attempt.getCredentials(), (String)"credentials cannot be null.");
        Assert.isTrue((boolean)NAME.equalsIgnoreCase(attempt.getCredentials().getSchemeName()), (String)"Unsupported scheme.");
        Assert.hasText((String)attempt.getCredentials().getSchemeValue(), (String)"Cannot authenticate empty Basic value.");
        String schemeValue = attempt.getCredentials().getSchemeValue();
        byte[] bytes = Base64.decodeBase64((String)schemeValue);
        String decoded = new String(bytes, UTF8);
        String submittedPrincipal = null;
        StringBuilder sb = new StringBuilder();
        int len = decoded.length();
        for (int i = 0; i < len; ++i) {
            char c = decoded.charAt(i);
            if (submittedPrincipal == null && c == ':') {
                submittedPrincipal = sb.toString();
                sb = new StringBuilder(len - i + 1);
                continue;
            }
            sb.append(c);
        }
        String submittedCredentials = sb.length() > 0 ? sb.toString() : null;
        boolean isApiKey = this.isApiKeyAuthenticatedRequest(attempt, submittedPrincipal, submittedCredentials);
        if (isApiKey) {
            return this.authenticateApiKey(attempt, submittedPrincipal, submittedCredentials);
        }
        return this.authenticateUsernamePassword(attempt, submittedPrincipal, submittedCredentials);
    }

    protected boolean isApiKeyAuthenticatedRequest(HttpAuthenticationAttempt attempt, String submittedPrincipal, String submittedCredentials) {
        String grantType = attempt.getRequest().getParameter("grant_type");
        return Strings.hasText((String)grantType) && grantType.equals("client_credentials") || submittedPrincipal != null && submittedPrincipal.length() == 25 && submittedCredentials != null && submittedCredentials.length() == 43 && submittedPrincipal.indexOf(64) < 0;
    }

    protected AuthenticationRequest createAuthenticationRequest(HttpAuthenticationAttempt attempt, String usernameOrEmail, String password) {
        HttpServletRequest request = attempt.getRequest();
        HttpServletResponse response = attempt.getResponse();
        return this.getUsernamePasswordRequestFactory().createUsernamePasswordRequest(request, response, usernameOrEmail, password);
    }

    protected HttpAuthenticationResult authenticateUsernamePassword(HttpAuthenticationAttempt attempt, String usernameOrEmail, String password) {
        AuthenticationResult result;
        HttpServletRequest request = attempt.getRequest();
        HttpServletResponse response = attempt.getResponse();
        try {
            AuthenticationRequest authcRequest = this.createAuthenticationRequest(attempt, usernameOrEmail, password);
            Application app = this.getApplication(attempt.getRequest());
            result = app.authenticateAccount(authcRequest);
        }
        catch (Exception e) {
            String msg = "Unable to authenticate usernameOrEmail and password-based request for usernameOrEmail [" + usernameOrEmail + "]: " + e.getMessage();
            throw new HttpAuthenticationException(msg, e);
        }
        attempt.getRequest().setAttribute(StormpathHttpServletRequest.AUTH_TYPE_REQUEST_ATTRIBUTE_NAME, (Object)"BASIC");
        return new DefaultHttpAuthenticationResult(request, response, result);
    }

    protected HttpAuthenticationResult authenticateApiKey(HttpAuthenticationAttempt attempt, String submittedApiKeyId, String submittedApiKeySecret) throws HttpAuthenticationException {
        ApiAuthenticationResult authcResult;
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = attempt.getRequest();
            response = attempt.getResponse();
            final ApiKey apiKey = this.getEnabledApiKey(request, submittedApiKeyId);
            if (!submittedApiKeySecret.equals(apiKey.getSecret())) {
                throw new HttpAuthenticationException("Submitted API Key secret does not match stored API Key secret.");
            }
            final Account account = apiKey.getAccount();
            authcResult = new ApiAuthenticationResult(){

                public ApiKey getApiKey() {
                    return apiKey;
                }

                public Account getAccount() {
                    return account;
                }

                public void accept(AuthenticationResultVisitor visitor) {
                    visitor.visit((ApiAuthenticationResult)this);
                }

                public String getHref() {
                    return null;
                }
            };
            request.setAttribute(ApiKey.class.getName(), (Object)apiKey);
        }
        catch (Exception e) {
            String msg = "Unable to authenticate request: " + e.getMessage();
            throw new HttpAuthenticationException(msg, e);
        }
        request.setAttribute(StormpathHttpServletRequest.AUTH_TYPE_REQUEST_ATTRIBUTE_NAME, (Object)"BASIC");
        return new DefaultHttpAuthenticationResult(request, response, (AuthenticationResult)authcResult);
    }
}

