/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.authc.config;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.http.authc.AuthorizationHeaderAuthenticator;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class HttpAuthenticatorFactory
extends ConfigSingletonFactory<HttpAuthenticator> {
    public static final String EVENT_PUBLISHER = "stormpath.web.request.event.publisher";
    public static final String CHALLENGE_PROPERTY_NAME = "stormpath.web.http.authc.challenge";
    public static final String SCHEMES_PROP = "stormpath.web.http.authc.schemes";
    public static final String SCHEME_PROPERTY_NAME_PREFIX = "stormpath.web.http.authc.schemes.";

    @Override
    protected HttpAuthenticator createInstance(ServletContext servletContext) throws Exception {
        Config config = ConfigResolver.INSTANCE.getConfig(servletContext);
        List<String> schemeNames = null;
        String val = (String)config.get(SCHEMES_PROP);
        if (Strings.hasText((String)val)) {
            String[] locs = Strings.split((String)val);
            schemeNames = Arrays.asList(locs);
        }
        Assert.notEmpty(schemeNames, (String)"At least one stormpath.web.http.authc.schemes value must be specified.");
        assert (schemeNames != null);
        Map<String, HttpAuthenticationScheme> schemeMap = config.getInstances(SCHEME_PROPERTY_NAME_PREFIX, HttpAuthenticationScheme.class);
        ArrayList<HttpAuthenticationScheme> schemes = new ArrayList<HttpAuthenticationScheme>(schemeMap.size());
        for (String schemeName : schemeNames) {
            HttpAuthenticationScheme scheme = schemeMap.get(schemeName);
            Assert.notNull((Object)scheme, (String)("There is no configured HttpAuthenticationScheme named " + schemeName));
            schemes.add(scheme);
        }
        boolean challenge = Boolean.parseBoolean((String)config.get(CHALLENGE_PROPERTY_NAME));
        Publisher publisher = (Publisher)config.getInstance(EVENT_PUBLISHER);
        return new AuthorizationHeaderAuthenticator(schemes, challenge, publisher);
    }
}

