/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.impl;

import com.stormpath.sdk.lang.Assert;
import java.io.Serializable;

public class ResourceReference
implements Serializable {
    private final String resourceClassName;
    private final String href;

    public ResourceReference(String resourceClassName, String href) {
        Assert.hasText((String)resourceClassName, (String)"resourceClassName cannot be null or empty.");
        Assert.hasText((String)href, (String)"href cannot be null or empty.");
        this.resourceClassName = resourceClassName;
        this.href = href;
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public String getHref() {
        return this.href;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceReference)) {
            return false;
        }
        ResourceReference that = (ResourceReference)o;
        return this.href.equals(that.href) && this.resourceClassName.equals(that.resourceClassName);
    }

    public int hashCode() {
        int result = this.href.hashCode();
        result = 31 * result + this.resourceClassName.hashCode();
        return result;
    }

    public String toString() {
        return "ResourceReference{resourceClassName='" + this.resourceClassName + '\'' + ", href='" + this.href + '\'' + '}';
    }
}

