/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.impl;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.impl.oauth.authz.DefaultTokenResponse;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.AccessTokenResult;
import com.stormpath.sdk.oauth.Authenticators;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticationBuilder;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.oauth.TokenResponse;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.account.DefaultAccountResolver;
import com.stormpath.sdk.servlet.authc.FailedAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.LogoutRequestEvent;
import com.stormpath.sdk.servlet.authc.SuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultFailedAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultLogoutRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.DefaultSuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.filter.UsernamePasswordRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.PasswordGrantAccessTokenResult;
import com.stormpath.sdk.servlet.http.AccountPrincipal;
import com.stormpath.sdk.servlet.http.EmailPrincipal;
import com.stormpath.sdk.servlet.http.GivenNamePrincipal;
import com.stormpath.sdk.servlet.http.HrefPrincipal;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.UsernamePrincipal;
import com.stormpath.sdk.servlet.http.impl.StormpathHttpSession;
import com.stormpath.sdk.servlet.oauth.OAuthTokenResolver;
import com.stormpath.sdk.servlet.oauth.impl.AccessTokenResolver;
import com.stormpath.sdk.servlet.oauth.impl.RefreshTokenResolver;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.oltu.oauth2.common.message.types.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormpathHttpServletRequest
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger((String)StormpathHttpServletRequest.class.getName());
    public static final String AUTH_TYPE_REQUEST_ATTRIBUTE_NAME = StormpathHttpServletRequest.class.getName() + ".authType";
    public static final String AUTH_TYPE_BEARER = "Bearer";
    public static final String ACCOUNT = "account";
    public static final String EMAIL = "email";
    public static final String USERNAME = "username";
    public static final String GIVEN_NAME = "givenName";
    public static final String HREF = "href";
    public static final String BYPASS = "bypass";
    private static boolean remoteUserWarned = false;
    private static boolean userPrincipalWarned = false;
    private final HttpServletResponse response;
    private final UsernamePasswordRequestFactory usernamePasswordRequestFactory;
    private final Saver<AuthenticationResult> authenticationResultSaver;
    private final Publisher<RequestEvent> eventPublisher;
    private final String userPrincipalStrategyName;
    private final String remoteUserStrategyName;

    public StormpathHttpServletRequest(HttpServletRequest request, HttpServletResponse response, UsernamePasswordRequestFactory usernamePasswordRequestFactory, Publisher<RequestEvent> eventPublisher, Saver<AuthenticationResult> authenticationResultSaver, String userPrincipalStrategyName, String remoteUserStrategyName) {
        super(request);
        Assert.notNull((Object)response, (String)"HttpServletResponse cannot be null.");
        this.response = response;
        Assert.notNull((Object)usernamePasswordRequestFactory, (String)"UsernamePasswordRequestFactory cannot be null.");
        this.usernamePasswordRequestFactory = usernamePasswordRequestFactory;
        Assert.notNull(authenticationResultSaver, (String)"AuthenticationResultSaver cannot be null.");
        this.authenticationResultSaver = authenticationResultSaver;
        Assert.notNull(eventPublisher, (String)"EventPublisher cannot be null.");
        this.eventPublisher = eventPublisher;
        Assert.hasText((String)userPrincipalStrategyName, (String)"userPrincipalStrategyName argument cannot be null or empty.");
        this.userPrincipalStrategyName = userPrincipalStrategyName;
        Assert.hasText((String)remoteUserStrategyName, (String)"remoteUserStrategyName argument cannot be null or empty.");
        this.remoteUserStrategyName = remoteUserStrategyName;
    }

    public UsernamePasswordRequestFactory getUsernamePasswordRequestFactory() {
        return this.usernamePasswordRequestFactory;
    }

    public Saver<AuthenticationResult> getAuthenticationResultSaver() {
        return this.authenticationResultSaver;
    }

    public String getUserPrincipalStrategyName() {
        return this.userPrincipalStrategyName;
    }

    public String getRemoteUserStrategyName() {
        return this.remoteUserStrategyName;
    }

    public Object getAttribute(String name) {
        Config config;
        Object o = super.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (name.startsWith("stormpath.") && (config = this.getConfig()) != null) {
            return config.get(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        final Enumeration enumeration = super.getAttributeNames();
        Map<String, String> config = this.getConfig();
        if (config == null) {
            config = new HashMap();
        }
        Set keys = config.keySet();
        final Iterator configIterator = keys.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements() || configIterator.hasNext();
            }

            @Override
            public String nextElement() {
                if (enumeration.hasMoreElements()) {
                    return (String)enumeration.nextElement();
                }
                return (String)configIterator.next();
            }
        };
    }

    protected Config getConfig() {
        ServletContext servletContext = this.getServletContext();
        return (Config)servletContext.getAttribute(Config.class.getName());
    }

    protected boolean hasAccount() {
        return AccountResolver.INSTANCE.hasAccount((ServletRequest)this);
    }

    protected Account getRequiredAccount() {
        return AccountResolver.INSTANCE.getRequiredAccount((ServletRequest)this);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session != null) {
            session = new StormpathHttpSession(session);
        }
        return session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String getRemoteUser() {
        String strategy = this.getRemoteUserStrategyName();
        if (BYPASS.equals(strategy)) {
            return super.getRemoteUser();
        }
        if (!this.hasAccount()) {
            return null;
        }
        Account account = this.getRequiredAccount();
        if (!Strings.hasText((String)strategy) || USERNAME.equals(strategy)) {
            return account.getUsername();
        }
        if (EMAIL.equals(strategy)) {
            return account.getEmail();
        }
        if (GIVEN_NAME.equals(strategy)) {
            return account.getGivenName();
        }
        if (HREF.equals(strategy)) {
            return account.getHref();
        }
        if (!remoteUserWarned) {
            String msg = "Unrecognized remote user strategy name [" + strategy + "].  Ignoring and defaulting to [" + USERNAME + "].  Please check your configuration.";
            log.warn(msg);
            remoteUserWarned = true;
        }
        return account.getUsername();
    }

    public Principal getUserPrincipal() {
        String strategy = this.getUserPrincipalStrategyName();
        if (BYPASS.equals(strategy)) {
            return super.getUserPrincipal();
        }
        if (!this.hasAccount()) {
            return null;
        }
        Account account = this.getRequiredAccount();
        if (!Strings.hasText((String)strategy) || USERNAME.equals(strategy)) {
            return new UsernamePrincipal(account.getUsername());
        }
        if (ACCOUNT.equals(strategy)) {
            return new AccountPrincipal(account);
        }
        if (EMAIL.equals(strategy)) {
            return new EmailPrincipal(account.getEmail());
        }
        if (GIVEN_NAME.equals(strategy)) {
            return new GivenNamePrincipal(account.getGivenName());
        }
        if (HREF.equals(strategy)) {
            return new HrefPrincipal(account.getHref());
        }
        if (!userPrincipalWarned) {
            String msg = "Unrecognized user principal strategy name [" + strategy + "].  Ignoring and defaulting to [" + USERNAME + "].  Please check your configuration.";
            log.warn(msg);
            userPrincipalWarned = true;
        }
        return new UsernamePrincipal(account.getUsername());
    }

    public boolean isUserInRole(String role) {
        if (!this.hasAccount()) {
            return false;
        }
        Assert.hasText((String)role, (String)"Role name cannot be null or empty.");
        Account account = this.getRequiredAccount();
        GroupList groups = account.getGroups();
        for (Group group : groups) {
            if (!role.equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    public String getAuthType() {
        if (this.hasAccount()) {
            Object value = this.getAttribute(AUTH_TYPE_REQUEST_ATTRIBUTE_NAME);
            String sval = null;
            if (value != null) {
                sval = String.valueOf(value);
            }
            Assert.hasText((String)sval, (String)"An authenticated account must be represented with a specific request authType.  This must be set by a Resolver<Account> on account discovery or immediately after login.  This is an implementation bug and should be reported.");
            return sval;
        }
        return null;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException("The HttpServletRequest.authenticate(response) method is not supported.  Various HTTP-based authentication mechanisms (Basic, OAuth Bearer, Form-based authentication, etc) are supported via other url (path)-based mechanisms by the StormpathFilter automatically.  Ensure you use those instead of calling HttpServletRequest.authenticate(response) directly.");
    }

    public void login(String username, String password) throws ServletException {
        AccessTokenResult result;
        AuthenticationRequest authcRequest = this.createAuthenticationRequest(username, password);
        if (this.hasAccount()) {
            Account account = this.getRequiredAccount();
            String msg = "The current request is already associated with an authenticated user [" + account.getEmail() + "].  Login attempt for submitted username [" + username + "] is denied.";
            ServletException ex = new ServletException(msg);
            FailedAuthenticationRequestEvent e = this.createEvent(authcRequest, (Exception)((Object)ex));
            this.publish(e);
            throw ex;
        }
        try {
            OAuthPasswordGrantRequestAuthenticationBuilder requestBuilder = ((OAuthPasswordGrantRequestAuthenticationBuilder)OAuthRequests.OAUTH_PASSWORD_GRANT_REQUEST.builder()).setPassword(password).setLogin(username);
            AccountStore accountStore = authcRequest.getAccountStore();
            if (accountStore != null) {
                requestBuilder.setAccountStore(accountStore);
            }
            OAuthGrantRequestAuthenticationResult authenticationResult = (OAuthGrantRequestAuthenticationResult)((OAuthPasswordGrantRequestAuthenticator)Authenticators.OAUTH_PASSWORD_GRANT_REQUEST_AUTHENTICATOR.forApplication(this.getApplication())).authenticate(requestBuilder.build());
            result = this.createAccessTokenResult(authenticationResult);
        }
        catch (ResourceException e) {
            FailedAuthenticationRequestEvent evt = this.createEvent(authcRequest, (Exception)((Object)e));
            this.publish(evt);
            String msg = "Unable to authenticate account for submitted username [" + username + "].";
            throw new ServletException(msg, (Throwable)e);
        }
        this.setAttribute(AUTH_TYPE_REQUEST_ATTRIBUTE_NAME, "LOGIN_METHOD");
        Account account = result.getAccount();
        this.setAttribute(DefaultAccountResolver.REQUEST_ATTR_NAME, account);
        this.setAttribute(AccessTokenResolver.REQUEST_ATTR_NAME, result.getTokenResponse().getAccessToken());
        this.setAttribute(RefreshTokenResolver.REQUEST_ATTR_NAME, result.getTokenResponse().getRefreshToken());
        this.setAttribute(OAuthTokenResolver.REQUEST_ATTR_NAME, result);
        SuccessfulAuthenticationRequestEvent e = this.createEvent(authcRequest, (AuthenticationResult)result);
        this.publish(e);
    }

    protected AccessTokenResult createAccessTokenResult(OAuthGrantRequestAuthenticationResult result) {
        TokenResponse tokenResponse = DefaultTokenResponse.tokenType((TokenType)TokenType.BEARER).accessToken(result.getAccessTokenString()).refreshToken(result.getRefreshTokenString()).applicationHref(this.getApplication().getHref()).expiresIn(String.valueOf(result.getExpiresIn())).build();
        return new PasswordGrantAccessTokenResult(result.getAccessToken().getAccount(), tokenResponse);
    }

    protected FailedAuthenticationRequestEvent createEvent(AuthenticationRequest authcRequest, Exception ex) {
        return new DefaultFailedAuthenticationRequestEvent((HttpServletRequest)this, this.response, authcRequest, ex);
    }

    protected SuccessfulAuthenticationRequestEvent createEvent(AuthenticationRequest authcRequest, AuthenticationResult result) {
        return new DefaultSuccessfulAuthenticationRequestEvent((HttpServletRequest)this, this.response, authcRequest, result);
    }

    protected LogoutRequestEvent createLogoutEvent() {
        Account account = this.hasAccount() ? this.getRequiredAccount() : null;
        return new DefaultLogoutRequestEvent((HttpServletRequest)this, this.response, account);
    }

    protected void publish(RequestEvent e) throws ServletException {
        try {
            this.eventPublisher.publish(e);
        }
        catch (Exception ex) {
            String msg = "Unable to publish request event: " + ex.getMessage();
            throw new ServletException(msg, (Throwable)ex);
        }
    }

    protected AuthenticationRequest createAuthenticationRequest(String username, String password) {
        return this.getUsernamePasswordRequestFactory().createUsernamePasswordRequest((HttpServletRequest)this, this.response, username, password);
    }

    protected Application getApplication() {
        return (Application)this.getAttribute(Application.class.getName());
    }

    public void logout() throws ServletException {
        LogoutRequestEvent e = this.createLogoutEvent();
        this.publish(e);
        Saver<AuthenticationResult> saver = this.getAuthenticationResultSaver();
        saver.set((HttpServletRequest)this, this.response, null);
        this.removeAttribute(AUTH_TYPE_REQUEST_ATTRIBUTE_NAME);
        this.removeAttribute(Account.class.getName());
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(Account.class.getName());
        }
    }
}

