/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.http.impl;

import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.impl.ds.DefaultResourceFactory;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.servlet.http.impl.ResourceReference;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class StormpathHttpSession
implements HttpSession {
    private final HttpSession session;

    public StormpathHttpSession(HttpSession session) {
        Assert.notNull((Object)session, (String)"Session argument cannot be null.");
        this.session = session;
    }

    protected Client getClient() {
        return (Client)this.getServletContext().getAttribute(Client.class.getName());
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.session.getServletContext();
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public Object getAttribute(String name) {
        Object o = this.session.getAttribute(name);
        if (o instanceof ResourceReference) {
            ResourceReference ref = (ResourceReference)o;
            String href = ref.getHref();
            Class clazz = Classes.forName((String)ref.getResourceClassName());
            Client client = this.getClient();
            o = client.getResource(href, clazz);
        }
        return o;
    }

    public Object getValue(String name) {
        Object o = this.session.getValue(name);
        if (o instanceof ResourceReference) {
            ResourceReference ref = (ResourceReference)o;
            String href = ref.getHref();
            Class clazz = Classes.forName((String)ref.getResourceClassName());
            Client client = this.getClient();
            o = client.getResource(href, clazz);
        }
        return o;
    }

    public Enumeration<String> getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public void setAttribute(String name, Object value) {
        if (value instanceof Resource) {
            Resource resource = (Resource)value;
            Class ifaceClass = DefaultResourceFactory.getInterfaceClass(resource.getClass());
            value = new ResourceReference(ifaceClass.getName(), resource.getHref());
        }
        this.session.setAttribute(name, value);
    }

    public void putValue(String name, Object value) {
        if (value instanceof Resource) {
            Resource resource = (Resource)value;
            Class ifaceClass = DefaultResourceFactory.getInterfaceClass(resource.getClass());
            value = new ResourceReference(ifaceClass.getName(), resource.getHref());
        }
        this.session.putValue(name, value);
    }

    public void removeAttribute(String name) {
        this.session.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.session.removeValue(name);
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isNew() {
        return this.session.isNew();
    }
}

