/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.i18n;

import com.stormpath.sdk.servlet.i18n.MessageSource;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageSource
implements MessageSource {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageSource.class);
    public static final String BUNDLE_BASE_NAME = "com.stormpath.sdk.servlet.i18n";

    @Override
    public String getMessage(String key, Locale locale) {
        return this.getMessage(key, locale, new Object[0]);
    }

    @Override
    public String getMessage(String key, String defaultMessage, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        try {
            String msg = new String(bundle.getString(key).getBytes("ISO-8859-1"), "UTF-8");
            return MessageFormat.format(msg, new Object[0]);
        }
        catch (MissingResourceException e) {
            log.debug("Couldn't load the property: {} ", (Object)key);
            return defaultMessage;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Couldn't load property from resource bundle", e);
        }
    }

    @Override
    public String getMessage(String key, String defaultMessage, Locale locale, Object ... args) {
        ResourceBundle bundle = this.getBundle(locale);
        try {
            String msg = new String(bundle.getString(key).getBytes("ISO-8859-1"), "UTF-8");
            return MessageFormat.format(msg, args);
        }
        catch (MissingResourceException e) {
            log.debug("Couldn't load the property: {}", (Object)key);
            return defaultMessage;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Couldn't load property from resource bundle", e);
        }
    }

    @Override
    public String getMessage(String key, Locale locale, Object ... args) {
        ResourceBundle bundle = this.getBundle(locale);
        try {
            String msg = new String(bundle.getString(key).getBytes("ISO-8859-1"), "UTF-8");
            return MessageFormat.format(msg, args);
        }
        catch (MissingResourceException e) {
            log.debug("Couldn't load the property: {}", (Object)key);
            return '!' + key + '!';
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Couldn't load property from resource bundle", e);
        }
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(BUNDLE_BASE_NAME, locale);
    }
}

