/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.filter.ControllerConfig;
import com.stormpath.sdk.servlet.form.DefaultField;
import com.stormpath.sdk.servlet.form.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractControllerConfig
implements ControllerConfig {
    private final String controllerKey;
    private PropertyResolver propertyResolver;
    private List<Field> formFields;
    private List<String> defaultFieldNames = java.util.Collections.emptyList();
    private List<String> disabledFieldNames = java.util.Collections.emptyList();
    private List<String> optionalFieldNames = java.util.Collections.emptyList();

    public AbstractControllerConfig(String controllerKey) {
        Assert.hasText((String)controllerKey, (String)"controllerKey cannot be null or empty.");
        this.controllerKey = controllerKey;
    }

    public void init() {
        Assert.notNull((Object)this.propertyResolver, (String)"propertyResolver cannot be null.");
        this.formFields = this.createFormFields();
        Assert.notNull(this.formFields, (String)"formFields cannot be null.  Use an empty list instead.");
        Assert.notNull(this.defaultFieldNames, (String)"defaultFieldNames cannot be null.  Use an empty list instead.");
        Assert.notNull(this.disabledFieldNames, (String)"disabledFieldNames cannot be null.  Use an empty list instead.");
        Assert.notNull(this.disabledFieldNames, (String)"optionalFieldNames cannot be null.  Use an empty list instead.");
    }

    @Override
    public String getControllerKey() {
        return this.controllerKey;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setDefaultFieldNames(String ... defaultFieldNames) {
        this.defaultFieldNames = Collections.toList((Object[])defaultFieldNames);
    }

    public void setDisabledFieldNames(String ... disabledFieldNames) {
        this.disabledFieldNames = Collections.toList((Object[])disabledFieldNames);
    }

    public void setOptionalFieldNames(String ... optionalFieldNames) {
        this.optionalFieldNames = Collections.toList((Object[])optionalFieldNames);
    }

    public List<String> getOptionalFieldNames() {
        return this.optionalFieldNames;
    }

    @Override
    public List<Field> getFormFields() {
        return this.formFields;
    }

    protected List<String> getDefaultFieldNames() {
        return this.defaultFieldNames;
    }

    protected List getDisabledFieldNames() {
        return this.disabledFieldNames;
    }

    private List<Field> createFormFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<String> fieldNames = new ArrayList<String>(this.getFormFieldNames());
        for (String fieldName : fieldNames) {
            String name = Strings.trimAllWhitespace((String)fieldName);
            DefaultField field = DefaultField.builder().setName(name).setType(this.getPropValue(name, "type", this.getFieldType(name))).setLabel(this.getPropValue(name, "label", this.getFieldPropertyKey(name, "label"))).setPlaceholder(this.getPropValue(name, "placeholder", this.getFieldPropertyKey(name, "placeholder"))).setRequired(this.getPropBooleanValue(name, "required", !this.getOptionalFieldNames().contains(name))).setEnabled(this.getPropBooleanValue(name, "enabled", !this.getDisabledFieldNames().contains(name))).setVisible(this.getPropBooleanValue(name, "visible", !"sptoken".equals(name))).build();
            fields.add(field);
        }
        return fields;
    }

    private String getPropValue(String fieldName, String propName, String defaultValue) {
        String key = this.getFieldPropertyKey(fieldName, propName);
        return this.propertyResolver.getValue(key, defaultValue);
    }

    private boolean getPropBooleanValue(String fieldName, String propName, boolean defaultValue) {
        return Boolean.valueOf(this.getPropValue(fieldName, propName, String.valueOf(defaultValue)));
    }

    private List<String> getFormFieldNames() {
        List<String> fieldNames = this.propertyResolver.getValues(this.getFormKey("fieldOrder"), this.getDefaultFieldNames());
        fieldNames = new ArrayList<String>(fieldNames);
        String fieldConfigPrefix = this.getFieldConfigPrefix();
        Set<String> keys = this.propertyResolver.getKeys(this.getFieldConfigPrefix());
        for (String key : keys) {
            String fieldName = key.substring(fieldConfigPrefix.length() + 1);
            int i = fieldName.indexOf(46);
            if (i > 0) {
                fieldName = fieldName.substring(0, i);
            }
            if ("fieldOrder".equals(fieldName) || fieldNames.contains(fieldName)) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    protected String getConfigPrefix() {
        return "stormpath.web." + this.getControllerKey();
    }

    protected String getFormConfigPrefix() {
        return this.getConfigPrefix() + ".form";
    }

    protected String getFieldConfigPrefix() {
        return this.getFormConfigPrefix() + ".fields";
    }

    protected String getFormKey(String fieldName) {
        return this.getFormConfigPrefix() + "." + fieldName;
    }

    protected String getFieldKey(String fieldName) {
        return this.getFieldConfigPrefix() + "." + fieldName;
    }

    protected String getFieldPropertyKey(String fieldName, String propertyName) {
        return this.getFieldKey(fieldName) + "." + propertyName;
    }

    private String getFieldType(String fieldName) {
        Assert.hasText((String)fieldName, (String)"fieldName argument cannot be null or empty.");
        String name = fieldName.toLowerCase(Locale.ENGLISH);
        if (name.equals("sptoken")) {
            return "hidden";
        }
        if (name.contains("password")) {
            return "password";
        }
        if (name.contains("email")) {
            return "email";
        }
        return "text";
    }

    public abstract class AbstractPropertyResolver
    implements PropertyResolver {
        @Override
        public String getValue(String key, Object defaultValue) {
            String value = this.getValue(key);
            if (value == null && defaultValue != null) {
                value = String.valueOf(defaultValue);
            }
            return value;
        }

        @Override
        public List<String> getValues(String key, List<String> defaultValues) {
            String value = this.getValue(key);
            if (Strings.hasText((String)value)) {
                return new ArrayList<String>(Strings.commaDelimitedListToSet((String)value));
            }
            return defaultValues;
        }
    }

    public static interface PropertyResolver {
        public String getValue(String var1);

        public String getValue(String var1, Object var2);

        public List<String> getValues(String var1, List<String> var2);

        public Set<String> getKeys(String var1);
    }
}

