/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.filter.account.InsecureCookieException;
import com.stormpath.sdk.servlet.i18n.MessageSource;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.ErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.ValidationException;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractErrorModelFactory
implements ErrorModelFactory {
    protected MessageSource messageSource;

    protected abstract String getDefaultMessageKey();

    protected abstract Object[] getMessageParams();

    protected abstract boolean hasError(HttpServletRequest var1, Exception var2);

    @Override
    public ErrorModel toError(HttpServletRequest request, Exception e) {
        if (!this.hasError(request, e)) {
            return null;
        }
        String errorMsg = this.getErrorMessage(request, this.getDefaultMessageKey(), "");
        int status = 400;
        if (e.getCause() instanceof ResourceException) {
            return this.translateResourceException(request, (ResourceException)e.getCause());
        }
        if (e instanceof ResourceException) {
            return this.translateResourceException(request, (ResourceException)((Object)e));
        }
        if (e instanceof ValidationException) {
            errorMsg = e.getMessage();
        } else if (e instanceof InsecureCookieException) {
            errorMsg = this.getErrorMessage(request, e.getLocalizedMessage(), e.getMessage());
        }
        return ErrorModel.builder().setStatus(status).setMessage(errorMsg).build();
    }

    private ErrorModel translateResourceException(HttpServletRequest request, ResourceException e) {
        return new ErrorModel.Builder().setStatus(e.getStormpathError().getStatus()).setMessage(this.getErrorMessage(request, "stormpath.web.errors." + e.getStormpathError().getCode(), e.getStormpathError().getMessage())).build();
    }

    protected String getErrorMessage(HttpServletRequest request, String key, String defaultMessage) {
        if (key.isEmpty()) {
            return defaultMessage;
        }
        return this.messageSource.getMessage(key, defaultMessage, request.getLocale(), this.getMessageParams());
    }
}

