/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.provider.ProviderAccountRequest;
import com.stormpath.sdk.provider.ProviderAccountResult;
import com.stormpath.sdk.servlet.authc.impl.DefaultSuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.util.ServletUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractSocialCallbackController
extends AbstractController {
    protected Saver<AuthenticationResult> authenticationResultSaver;

    public void setAuthenticationResultSaver(Saver<AuthenticationResult> authenticationResultSaver) {
        this.authenticationResultSaver = authenticationResultSaver;
    }

    @Override
    public void init() throws Exception {
        Assert.hasText((String)this.nextUri, (String)"nextUri cannot be null or empty.");
        Assert.notNull((Object)this.applicationResolver, (String)"applicationResolver cannot be null.");
        Assert.notNull(this.authenticationResultSaver, (String)"authenticationResultSaver cannot be null.");
        Assert.notNull((Object)this.eventPublisher, (String)"eventPublisher cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    public abstract ProviderAccountRequest getAccountProviderRequest(HttpServletRequest var1);

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProviderAccountRequest providerRequest = this.getAccountProviderRequest(request);
        ProviderAccountResult result = this.getApplication(request).getAccount(providerRequest);
        Account account = result.getAccount();
        if (account.getStatus().equals((Object)AccountStatus.UNVERIFIED)) {
            Config config = (Config)request.getServletContext().getAttribute(Config.class.getName());
            String loginUri = config.getLoginConfig().getUri();
            return new DefaultViewModel(loginUri + "?status=unverified").setRedirect(true);
        }
        TransientAuthenticationResult authcResult = new TransientAuthenticationResult(result.getAccount());
        this.authenticationResultSaver.set(request, response, authcResult);
        this.eventPublisher.publish(new DefaultSuccessfulAuthenticationRequestEvent(request, response, null, authcResult));
        String redirectUri = this.getRedirectUri(request);
        return new DefaultViewModel(redirectUri).setRedirect(true);
    }

    private String getRedirectUri(HttpServletRequest request) {
        String redirectUri = this.nextUri;
        String next = ServletUtils.getCleanParam((ServletRequest)request, "state");
        if (this.shouldGetRedirectUriFromState(next)) {
            redirectUri = next;
        }
        return redirectUri;
    }

    protected boolean shouldGetRedirectUriFromState(String state) {
        return Strings.hasText((String)state);
    }
}

