/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.idsite.AuthenticationResult;
import com.stormpath.sdk.idsite.LogoutResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.saml.SamlResultListener;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.authc.impl.DefaultSuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.Controller;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.WebHandler;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CallbackController
extends AbstractController {
    protected String loginNextUri;
    protected Controller logoutController;
    protected Saver<com.stormpath.sdk.authc.AuthenticationResult> authenticationResultSaver;
    protected Publisher<RequestEvent> eventPublisher;
    protected List<SamlResultListener> samlResultListeners = new ArrayList<SamlResultListener>();
    protected WebHandler postLoginHandler;
    protected WebHandler postRegisterHandler;

    public void setLoginNextUri(String loginNextUri) {
        this.loginNextUri = loginNextUri;
    }

    public void setLogoutController(Controller logoutController) {
        this.logoutController = logoutController;
    }

    @Override
    public Publisher<RequestEvent> getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public void setEventPublisher(Publisher<RequestEvent> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Saver<com.stormpath.sdk.authc.AuthenticationResult> getAuthenticationResultSaver() {
        return this.authenticationResultSaver;
    }

    public void setAuthenticationResultSaver(Saver<com.stormpath.sdk.authc.AuthenticationResult> authenticationResultSaver) {
        this.authenticationResultSaver = authenticationResultSaver;
    }

    public void addSamlResultListener(SamlResultListener resultListener) {
        Assert.notNull((Object)resultListener, (String)"resultListener cannot be null");
        this.samlResultListeners.add(resultListener);
    }

    @Override
    public void init() {
        Assert.hasText((String)this.loginNextUri, (String)"loginNextUri must be configured.");
        Assert.notNull((Object)this.logoutController, (String)"logoutController must be configured.");
        Assert.notNull(this.authenticationResultSaver, (String)"authenticationResultSaver must be configured.");
        Assert.notNull(this.eventPublisher, (String)"request event publisher must be configured.");
        this.doInit();
    }

    public abstract void doInit();

    public String getAuthenticationSuccessNextUri(HttpServletRequest request) {
        return this.loginNextUri;
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected Application getApplication(HttpServletRequest request) {
        return ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
    }

    protected ViewModel onAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationResult result) {
        TransientAuthenticationResult authcResult = new TransientAuthenticationResult(result.getAccount());
        this.saveResult(request, response, authcResult);
        this.publish(new DefaultSuccessfulAuthenticationRequestEvent(request, response, null, authcResult));
        if (this.postLoginHandler != null && !this.postLoginHandler.handle(request, response, result.getAccount())) {
            return null;
        }
        return new DefaultViewModel(this.loginNextUri).setRedirect(true);
    }

    protected ViewModel onLogout(HttpServletRequest request, HttpServletResponse response, LogoutResult result) {
        request.setAttribute(LogoutResult.class.getName(), (Object)result);
        try {
            return this.logoutController.handleRequest(request, response);
        }
        catch (Exception e) {
            String msg = "Unable to successfully handle logout: " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    protected void publish(RequestEvent e) {
        try {
            this.getEventPublisher().publish(e);
        }
        catch (Exception ex) {
            String msg = "Unable to publish registered account request event: " + ex.getMessage();
            throw new RuntimeException(msg, ex);
        }
    }

    protected void saveResult(HttpServletRequest request, HttpServletResponse response, com.stormpath.sdk.authc.AuthenticationResult result) {
        this.getAuthenticationResultSaver().set(request, response, result);
    }
}

