/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.servlet.filter.ContentNegotiationResolver;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.UnresolvedMediaTypeException;
import com.stormpath.sdk.servlet.mvc.JacksonFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.RequestFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.RequestParameterFieldValueResolver;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentNegotiatingFieldValueResolver
implements RequestFieldValueResolver {
    private static final Logger log = LoggerFactory.getLogger(ContentNegotiatingFieldValueResolver.class);
    private final RequestFieldValueResolver JSON_BODY_RESOLVER = new JacksonFieldValueResolver();
    private final RequestFieldValueResolver REQ_PARAM_RESOLVER = new RequestParameterFieldValueResolver();
    protected List<MediaType> produces;
    private ContentNegotiationResolver contentNegotiationResolver = ContentNegotiationResolver.INSTANCE;

    public void setProduces(List<MediaType> produces) {
        this.produces = produces;
    }

    @Override
    public String getValue(HttpServletRequest request, String fieldName) {
        if (this.isJsonPreferred(request)) {
            return this.JSON_BODY_RESOLVER.getValue(request, fieldName);
        }
        return this.REQ_PARAM_RESOLVER.getValue(request, fieldName);
    }

    @Override
    public Map<String, Object> getAllFields(HttpServletRequest request) {
        if (this.isJsonPreferred(request)) {
            return this.JSON_BODY_RESOLVER.getAllFields(request);
        }
        return this.REQ_PARAM_RESOLVER.getAllFields(request);
    }

    protected boolean isJsonPreferred(HttpServletRequest request) {
        try {
            return MediaType.APPLICATION_JSON.equals(this.contentNegotiationResolver.getContentType(request, null, this.produces));
        }
        catch (UnresolvedMediaTypeException e) {
            log.debug("isJsonPreferred: Couldn't resolve content type: {}", (Object)e.getMessage());
            return false;
        }
    }
}

