/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.i18n.MessageSource;
import com.stormpath.sdk.servlet.mvc.LoginFormStatusResolver;
import com.stormpath.sdk.servlet.mvc.LoginStatus;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;

public class DefaultLoginFormStatusResolver
implements LoginFormStatusResolver {
    private MessageSource messageSource;
    private String verifyEmailUri;

    public DefaultLoginFormStatusResolver(MessageSource messageSource, String verifyEmailUri) {
        Assert.notNull((Object)messageSource, (String)"MessageSource cannot be null.");
        Assert.hasText((String)verifyEmailUri, (String)"verifyEmailUri cannot be null or empty.");
        this.messageSource = messageSource;
        this.verifyEmailUri = verifyEmailUri;
    }

    @Override
    public String getStatusMessage(HttpServletRequest request, String status) {
        EnumSet<LoginStatus> validStatus = EnumSet.allOf(LoginStatus.class);
        try {
            if (validStatus.contains((Object)LoginStatus.valueOf(status.toUpperCase()))) {
                return this.messageSource.getMessage("stormpath.web.login.form.status." + status, request.getLocale(), this.verifyEmailUri);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }
}

