/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.provider.FacebookAccountRequestBuilder;
import com.stormpath.sdk.provider.GithubAccountRequestBuilder;
import com.stormpath.sdk.provider.GoogleAccountRequestBuilder;
import com.stormpath.sdk.provider.LinkedInAccountRequestBuilder;
import com.stormpath.sdk.provider.ProviderAccountRequest;
import com.stormpath.sdk.provider.Providers;
import com.stormpath.sdk.provider.TwitterAccountRequestBuilder;
import com.stormpath.sdk.servlet.mvc.GithubAccessTokenResolver;
import com.stormpath.sdk.servlet.mvc.JacksonFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.ProviderAccountRequestFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProviderAccountRequestFactory
implements ProviderAccountRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultProviderAccountRequestFactory.class);
    private final GithubAccessTokenResolver githubAccessTokenResolver = new GithubAccessTokenResolver();

    @Override
    public ProviderAccountRequest getProviderAccountRequest(HttpServletRequest request) {
        Map providerData;
        String providerId;
        Map map = (Map)request.getAttribute(JacksonFieldValueResolver.MARSHALLED_OBJECT);
        if (map != null && map.get("providerData") != null && Strings.hasText((String)(providerId = (String)(providerData = (Map)map.get("providerData")).get("providerId")))) {
            switch (providerId) {
                case "facebook": {
                    String accessToken = (String)providerData.get("accessToken");
                    return ((FacebookAccountRequestBuilder)((FacebookAccountRequestBuilder)Providers.FACEBOOK.account()).setAccessToken(accessToken)).build();
                }
                case "github": {
                    String accessToken = this.githubAccessTokenResolver.get(request, null);
                    return ((GithubAccountRequestBuilder)((GithubAccountRequestBuilder)Providers.GITHUB.account()).setAccessToken(accessToken)).build();
                }
                case "google": {
                    String code = (String)providerData.get("code");
                    return ((GoogleAccountRequestBuilder)((GoogleAccountRequestBuilder)Providers.GOOGLE.account()).setCode(code)).build();
                }
                case "linkedin": {
                    String code = (String)providerData.get("code");
                    return ((LinkedInAccountRequestBuilder)Providers.LINKEDIN.account()).setCode(code).build();
                }
                case "twitter": {
                    String code = (String)providerData.get("accessToken");
                    return ((TwitterAccountRequestBuilder)((TwitterAccountRequestBuilder)Providers.TWITTER.account()).setAccessToken(code)).build();
                }
            }
            log.error("No provider configured for " + providerId);
            return null;
        }
        log.debug("Provider data not found in request.");
        return null;
    }
}

