/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.ContentNegotiationResolver;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.UnresolvedMediaTypeException;
import com.stormpath.sdk.servlet.mvc.View;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.ViewResolver;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DefaultViewResolver
implements ViewResolver {
    private final ViewResolver delegateViewResolver;
    protected final List<MediaType> producesMediaTypes;
    private final View jsonView;

    public DefaultViewResolver(ViewResolver delegate, View jsonView, List<MediaType> producesMediaTypes) {
        Assert.notNull((Object)delegate, (String)"Delegate ViewResolver cannot be null.");
        Assert.notNull((Object)jsonView, (String)"JSON View cannot be null.");
        this.delegateViewResolver = delegate;
        this.jsonView = jsonView;
        this.producesMediaTypes = producesMediaTypes;
    }

    @Override
    public View getView(ViewModel model, HttpServletRequest request) {
        try {
            MediaType mediaType = ContentNegotiationResolver.INSTANCE.getContentType(request, null, this.producesMediaTypes);
            if (mediaType.equals(MediaType.APPLICATION_JSON) || "stormpathJsonView".equals(model.getViewName())) {
                return this.jsonView;
            }
            if (mediaType.equals(MediaType.TEXT_HTML)) {
                return this.delegateViewResolver.getView(model, request);
            }
        }
        catch (UnresolvedMediaTypeException unresolvedMediaTypeException) {
            // empty catch block
        }
        return null;
    }
}

