/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.form.Form;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.FormController;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgotPasswordController
extends FormController {
    private static final Logger log = LoggerFactory.getLogger(ForgotPasswordController.class);
    private String loginUri;
    private AccountStoreResolver accountStoreResolver;

    public void setLoginUri(String loginUri) {
        this.loginUri = loginUri;
    }

    public void setAccountStoreResolver(AccountStoreResolver accountStoreResolver) {
        this.accountStoreResolver = accountStoreResolver;
    }

    @Override
    public void init() throws Exception {
        super.init();
        Assert.hasText((String)this.loginUri, (String)"loginUri cannot be null.");
        Assert.notNull((Object)this.accountStoreResolver, (String)"accountStoreResolver cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected String i18n(HttpServletRequest request, String key) {
        Locale locale = this.getLocaleResolver().get(request, null);
        return this.messageSource.getMessage(key, locale);
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isJsonPreferred(request, response)) {
            response.setStatus(405);
            return new DefaultViewModel("stormpathJsonView", Collections.EMPTY_MAP);
        }
        return super.doGet(request, response);
    }

    @Override
    protected void appendModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors, Map<String, Object> model) {
        model.put("loginUri", this.loginUri);
        String status = request.getParameter("status");
        if ("invalid_sptoken".equals(status)) {
            String key = "stormpath.web.forgotPassword.form.status";
            model.put("status", this.i18n(request, key.concat(".").concat(status)));
        }
    }

    @Override
    protected List<ErrorModel> toErrors(HttpServletRequest request, Form form, Exception e) {
        log.debug("Unable to send reset password email.", (Throwable)e);
        ArrayList<ErrorModel> errors = new ArrayList<ErrorModel>(1);
        errors.add(ErrorModel.builder().setMessage("Invalid email address.").build());
        return errors;
    }

    @Override
    protected void validate(HttpServletRequest request, HttpServletResponse response, Form form) {
        if (!this.isJsonPreferred(request, response)) {
            super.validate(request, response, form);
        }
    }

    @Override
    protected ViewModel onValidSubmit(HttpServletRequest request, HttpServletResponse response, Form form) {
        block5: {
            Application application = (Application)request.getAttribute(Application.class.getName());
            String email = form.getFieldValue("email");
            try {
                request.setAttribute("form", (Object)form);
                AccountStore accountStore = this.accountStoreResolver.getAccountStore(request, response);
                if (accountStore != null) {
                    application.sendPasswordResetEmail(email, accountStore);
                } else {
                    application.sendPasswordResetEmail(email);
                }
            }
            catch (ResourceException e) {
                if (!this.isJsonPreferred(request, response)) break block5;
                return new DefaultViewModel("stormpathJsonView");
            }
        }
        if (this.isJsonPreferred(request, response)) {
            return new DefaultViewModel("stormpathJsonView");
        }
        return new DefaultViewModel(this.nextUri).setRedirect(true);
    }
}

