/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationAccountStoreMapping;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.AccountStoreVisitorAdapter;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.impl.provider.DefaultGithubProvider;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubAccessTokenResolver
implements Resolver<String> {
    private static final Logger log = LoggerFactory.getLogger(GithubAccessTokenResolver.class);
    private static final String GITHUB_ACCESS_TOKEN_URL = "https://github.com/login/oauth/access_token";
    private static final String GITHUB_ACCESS_TOKEN_FIELD = "access_token";

    @Override
    public String get(HttpServletRequest request, HttpServletResponse response) {
        final DefaultGithubProvider[] githubProvider = new DefaultGithubProvider[1];
        Application application = ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
        for (ApplicationAccountStoreMapping mapping : application.getAccountStoreMappings()) {
            AccountStore accountStore = mapping.getAccountStore();
            AccountStoreVisitorAdapter accountStoreVisitor = new AccountStoreVisitorAdapter(){

                public void visit(Directory directory) {
                    if ("github".equals(directory.getProvider().getProviderId())) {
                        githubProvider[0] = (DefaultGithubProvider)directory.getProvider();
                    }
                }
            };
            accountStore.accept((AccountStoreVisitor)accountStoreVisitor);
        }
        Assert.notNull((Object)githubProvider[0], (String)"githubProvider cannot be null.");
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            HttpPost httpPost = new HttpPost(GITHUB_ACCESS_TOKEN_URL);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("code", this.getCode(request)));
            nvps.add(new BasicNameValuePair("client_id", githubProvider[0].getClientId()));
            nvps.add(new BasicNameValuePair("client_secret", githubProvider[0].getClientSecret()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8.displayName()));
            httpPost.addHeader("Accept", "application/json");
            HttpResponse gitHubResponse = client.execute((HttpUriRequest)httpPost);
            ObjectMapper objectMapper = new ObjectMapper();
            Map result = (Map)objectMapper.readValue(gitHubResponse.getEntity().getContent(), Map.class);
            return (String)result.get(GITHUB_ACCESS_TOKEN_FIELD);
        }
        catch (Exception e) {
            log.error("Couldn't exchange GitHub oAuth code for an access token", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getCode(HttpServletRequest request) throws IllegalArgumentException {
        return request.getParameter("code");
    }
}

