/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.servlet.mvc.InternalResourceView;
import com.stormpath.sdk.servlet.mvc.View;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.ViewResolver;
import javax.servlet.http.HttpServletRequest;

public class InternalResourceViewResolver
implements ViewResolver {
    private String prefix;
    private String suffix;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public View getView(ViewModel model, HttpServletRequest request) {
        String url = this.toResourcePath(model.getViewName());
        return new InternalResourceView(url);
    }

    protected String toResourcePath(String viewName) {
        String prefix = this.getPrefix();
        String suffix = this.getSuffix();
        if (prefix == null && suffix == null) {
            return viewName;
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(viewName);
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

