/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessTokenResult;
import com.stormpath.sdk.servlet.authc.impl.DefaultSuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.form.Form;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.mvc.AccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultAccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultLoginFormStatusResolver;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.ErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.FormController;
import com.stormpath.sdk.servlet.mvc.LoginErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.LoginFormStatusResolver;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.WebHandler;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModel;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModelFactory;
import com.stormpath.sdk.servlet.mvc.provider.ExternalAccountStoreModelFactory;
import com.stormpath.sdk.servlet.oauth.OAuthTokenResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginController
extends FormController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private String forgotPasswordUri;
    private String verifyUri;
    private String registerUri;
    private String logoutUri;
    private String samlUri;
    private boolean verifyEnabled = true;
    private boolean forgotPasswordEnabled = true;
    private boolean idSiteEnabled;
    private boolean callbackEnabled;
    private Saver<AuthenticationResult> authenticationResultSaver;
    private ErrorModelFactory errorModelFactory;
    private LoginFormStatusResolver loginFormStatusResolver;
    private AccountStoreModelFactory accountStoreModelFactory = new ExternalAccountStoreModelFactory();
    private AccountModelFactory accountModelFactory = new DefaultAccountModelFactory();
    private WebHandler preLoginHandler;
    private WebHandler postLoginHandler;
    private Resolver<Boolean> registerEnabledResolver;

    public void setForgotPasswordUri(String forgotPasswordUri) {
        this.forgotPasswordUri = forgotPasswordUri;
    }

    public void setVerifyUri(String verifyUri) {
        this.verifyUri = verifyUri;
    }

    public void setRegisterUri(String registerUri) {
        this.registerUri = registerUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    public void setSamlUri(String samlUri) {
        this.samlUri = samlUri;
    }

    public void setVerifyEnabled(boolean verifyEnabled) {
        this.verifyEnabled = verifyEnabled;
    }

    public void setForgotPasswordEnabled(boolean forgotPasswordEnabled) {
        this.forgotPasswordEnabled = forgotPasswordEnabled;
    }

    public void setAuthenticationResultSaver(Saver<AuthenticationResult> authenticationResultSaver) {
        this.authenticationResultSaver = authenticationResultSaver;
    }

    public void setErrorModelFactory(ErrorModelFactory errorModelFactory) {
        this.errorModelFactory = errorModelFactory;
    }

    public void setLoginFormStatusResolver(LoginFormStatusResolver loginFormStatusResolver) {
        this.loginFormStatusResolver = loginFormStatusResolver;
    }

    public void setAccountStoreModelFactory(AccountStoreModelFactory accountStoreModelFactory) {
        this.accountStoreModelFactory = accountStoreModelFactory;
    }

    public void setAccountModelFactory(AccountModelFactory accountModelFactory) {
        this.accountModelFactory = accountModelFactory;
    }

    public void setPreLoginHandler(WebHandler preLoginHandler) {
        this.preLoginHandler = preLoginHandler;
    }

    public void setPostLoginHandler(WebHandler postLoginHandler) {
        this.postLoginHandler = postLoginHandler;
    }

    public void setIdSiteEnabled(boolean idSiteEnabled) {
        this.idSiteEnabled = idSiteEnabled;
    }

    public void setCallbackEnabled(boolean callbackEnabled) {
        this.callbackEnabled = callbackEnabled;
    }

    public void setRegisterEnabledResolver(Resolver<Boolean> registerEnabledResolver) {
        this.registerEnabledResolver = registerEnabledResolver;
    }

    @Override
    public void init() throws Exception {
        super.init();
        Assert.hasText((String)this.verifyUri, (String)"verifyUri property cannot be null or empty.");
        if (this.loginFormStatusResolver == null) {
            this.loginFormStatusResolver = new DefaultLoginFormStatusResolver(this.messageSource, this.verifyUri);
        }
        if (this.errorModelFactory == null) {
            this.errorModelFactory = new LoginErrorModelFactory(this.messageSource);
        }
        if (this.accountStoreModelFactory == null) {
            this.accountStoreModelFactory = new ExternalAccountStoreModelFactory();
        }
        if (this.accountModelFactory == null) {
            this.accountModelFactory = new DefaultAccountModelFactory();
        }
        Assert.hasText((String)this.forgotPasswordUri, (String)"forgotPasswordUri property cannot be null or empty.");
        Assert.hasText((String)this.registerUri, (String)"registerUri property cannot be null or empty.");
        Assert.notNull(this.registerEnabledResolver, (String)"registerEnabledResolver cannot be null.");
        Assert.hasText((String)this.logoutUri, (String)"logoutUri property cannot be null or empty.");
        Assert.hasText((String)this.samlUri, (String)"samlUri property cannot be null or empty.");
        Assert.notNull(this.authenticationResultSaver, (String)"authenticationResultSaver property cannot be null.");
        Assert.notNull((Object)this.errorModelFactory, (String)"errorModelFactory cannot be null.");
        Assert.notNull((Object)this.preLoginHandler, (String)"preLoginHandler cannot be null.");
        Assert.notNull((Object)this.postLoginHandler, (String)"postLoginHandler cannot be null.");
        Assert.notNull((Object)this.loginFormStatusResolver, (String)"loginFormStatusResolver cannot be null.");
        Assert.notNull((Object)this.accountStoreModelFactory, (String)"accountStoreModelFactory cannot be null.");
        Assert.notNull((Object)this.accountModelFactory, (String)"accountModelFactory cannot be null.");
        Assert.notNull((Object)this.applicationResolver, (String)"applicationResolver cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected void appendModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors, Map<String, Object> model) {
        List<AccountStoreModel> accountStores = this.accountStoreModelFactory.getAccountStores(request);
        if (!this.idSiteEnabled && !this.callbackEnabled && this.containsSaml(accountStores)) {
            String errorMsg = "ID Site is disabled and callbacks are disabled, yet this application has SAML directories. Please enable callbacks or remove SAML directories.";
            log.warn(errorMsg);
            if (errors == null) {
                errors = new ArrayList<ErrorModel>();
            }
            if (request.getMethod().equals(HttpMethod.GET.name())) {
                errors.add(ErrorModel.builder().setStatus(200).setMessage(errorMsg).build());
            }
        }
        model.put("accountStores", accountStores);
        if (this.isHtmlPreferred(request, response)) {
            model.put("forgotPasswordEnabled", this.forgotPasswordEnabled);
            model.put("forgotPasswordUri", this.forgotPasswordUri);
            model.put("verifyEnabled", this.verifyEnabled);
            model.put("verifyUri", this.verifyUri);
            model.put("registerEnabled", this.registerEnabledResolver.get(request, response));
            model.put("registerUri", this.registerUri);
            model.put("samlUri", this.samlUri);
            model.put("oauthStateToken", UUID.randomUUID().toString());
            String status = request.getParameter("status");
            if (status != null) {
                model.put("status", this.loginFormStatusResolver.getStatusMessage(request, status));
            }
        }
    }

    private boolean containsSaml(List<AccountStoreModel> accountStores) {
        for (AccountStoreModel accountStore : accountStores) {
            if (!"saml".equalsIgnoreCase(accountStore.getProvider().getProviderId())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<ErrorModel> toErrors(HttpServletRequest request, Form form, Exception e) {
        return com.stormpath.sdk.lang.Collections.toList((Object[])new ErrorModel[]{this.errorModelFactory.toError(request, e)});
    }

    @Override
    protected ViewModel onValidSubmit(HttpServletRequest req, HttpServletResponse resp, Form form) throws Exception {
        if (this.preLoginHandler != null && !this.preLoginHandler.handle(req, resp, null)) {
            return null;
        }
        Account account = (Account)req.getAttribute(Account.class.getName());
        if (account != null) {
            TransientAuthenticationResult authcResult = new TransientAuthenticationResult(account);
            this.authenticationResultSaver.set(req, resp, authcResult);
            this.eventPublisher.publish(new DefaultSuccessfulAuthenticationRequestEvent(req, resp, null, authcResult));
        } else {
            String usernameOrEmail = form.getFieldValue("login");
            String password = form.getFieldValue("password");
            req.login(usernameOrEmail, password);
            AccessTokenResult result = (AccessTokenResult)req.getAttribute(OAuthTokenResolver.REQUEST_ATTR_NAME);
            account = result.getAccount();
            this.saveResult(req, resp, (AuthenticationResult)result);
        }
        if (this.postLoginHandler != null && !this.postLoginHandler.handle(req, resp, account)) {
            return null;
        }
        if (this.isJsonPreferred(req, resp)) {
            return new DefaultViewModel(this.view, Collections.singletonMap("account", this.accountModelFactory.toMap(account, Collections.emptyList())));
        }
        return new DefaultViewModel(this.getNextUri(req)).setRedirect(true);
    }

    protected void saveResult(HttpServletRequest request, HttpServletResponse response, AuthenticationResult result) {
        this.authenticationResultSaver.set(request, response, result);
    }
}

