/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LogoutController
extends AbstractController {
    private boolean invalidateHttpSession = true;

    public boolean isInvalidateHttpSession() {
        return this.invalidateHttpSession;
    }

    public void setInvalidateHttpSession(boolean invalidateHttpSession) {
        this.invalidateHttpSession = invalidateHttpSession;
    }

    @Override
    public void init() {
        Assert.hasText((String)this.nextUri, (String)"nextUri must be configured.");
        Assert.notNull((Object)this.produces, (String)"produces cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return false;
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getAttribute("idSiteResult.FILTERED") != null) {
            return this.processRequest(request, response);
        }
        response.setStatus(405);
        return null;
    }

    @Override
    protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.processRequest(request, response);
    }

    protected ViewModel processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.logout();
        HttpSession session = request.getSession(false);
        if (session != null && this.isInvalidateHttpSession()) {
            session.invalidate();
        }
        if (this.isHtmlPreferred(request, response)) {
            return new DefaultViewModel(this.nextUri).setRedirect(true);
        }
        response.setStatus(200);
        return null;
    }
}

