/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.impl.error.DefaultError;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.oauth.OAuthRevocationRequest;
import com.stormpath.sdk.oauth.OAuthRevocationRequestBuilder;
import com.stormpath.sdk.oauth.OAuthTokenRevocators;
import com.stormpath.sdk.oauth.TokenTypeHint;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeTokenController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(RevokeTokenController.class);
    private static final String TOKEN = "token";
    private static final String TOKEN_TYPE_HINT = "token_type_hint";

    @Override
    public void init() {
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return false;
    }

    @Override
    public ViewModel handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method = request.getMethod();
        if (HttpMethod.POST.name().equalsIgnoreCase(method)) {
            return this.doPost(request, response);
        }
        return super.handleRequest(request, response);
    }

    @Override
    protected ViewModel doPost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OAuthRevocationRequestBuilder builder = OAuthRequests.OAUTH_TOKEN_REVOCATION_REQUEST.builder();
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        try {
            String token;
            String contentType = Strings.clean((String)request.getContentType());
            if (contentType == null || !contentType.startsWith("application/x-www-form-urlencoded")) {
                String msg = "Content-Type must be application/x-www-form-urlencoded";
                throw new OAuthException(OAuthErrorCode.INVALID_REQUEST, msg, null);
            }
            String tokenTypeHint = request.getParameter(TOKEN_TYPE_HINT);
            if (Strings.hasText((String)tokenTypeHint)) {
                builder.setTokenTypeHint(TokenTypeHint.fromValue((String)tokenTypeHint));
            }
            if (!Strings.hasText((String)(token = request.getParameter(TOKEN)))) {
                throw new OAuthException(OAuthErrorCode.INVALID_REQUEST);
            }
            this.revoke(this.getApplication(request), builder.setToken(token).build());
            response.setStatus(200);
            response.setHeader("Content-Length", "0");
        }
        catch (OAuthException e) {
            log.debug("Error occurred revoking token: {}", (Object)e.getMessage());
            response.setStatus(400);
            String json = e.toJson();
            response.setHeader("Content-Length", String.valueOf(json.length()));
            response.setContentType("application/json");
            response.getWriter().print(json);
            response.getWriter().flush();
        }
        return null;
    }

    private void revoke(Application application, OAuthRevocationRequest request) throws OAuthException {
        try {
            OAuthTokenRevocators.OAUTH_TOKEN_REVOCATOR.forApplication(application).revoke(request);
        }
        catch (ResourceException e) {
            Error error = e.getStormpathError();
            String message = error.getMessage();
            OAuthErrorCode oauthError = OAuthErrorCode.INVALID_REQUEST;
            if (error instanceof DefaultError) {
                Object errorObject = ((DefaultError)error).getProperty("error");
                oauthError = errorObject == null ? oauthError : new OAuthErrorCode(errorObject.toString());
            }
            throw new OAuthException(oauthError, message);
        }
    }
}

