/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.VerificationEmailRequest;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.Applications;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.account.event.VerifiedAccountRequestEvent;
import com.stormpath.sdk.servlet.account.event.impl.DefaultVerifiedAccountRequestEvent;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.form.Form;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import com.stormpath.sdk.servlet.mvc.AccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultAccountModelFactory;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ErrorModel;
import com.stormpath.sdk.servlet.mvc.ErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.FormController;
import com.stormpath.sdk.servlet.mvc.ValidationException;
import com.stormpath.sdk.servlet.mvc.VerifyErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class VerifyController
extends FormController {
    private static final Logger log = LoggerFactory.getLogger(VerifyController.class);
    private String loginUri;
    private String loginNextUri;
    private Client client;
    private boolean autoLogin;
    private AccountModelFactory accountModelFactory;
    private ErrorModelFactory errorModelFactory;
    private Saver<AuthenticationResult> authenticationResultSaver;
    private AccountStoreResolver accountStoreResolver;

    public void setLoginUri(String loginUri) {
        this.loginUri = loginUri;
    }

    public void setLoginNextUri(String loginNextUri) {
        this.loginNextUri = loginNextUri;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setAccountModelFactory(AccountModelFactory accountModelFactory) {
        this.accountModelFactory = accountModelFactory;
    }

    public void setErrorModelFactory(ErrorModelFactory errorModelFactory) {
        this.errorModelFactory = errorModelFactory;
    }

    public void setAuthenticationResultSaver(Saver<AuthenticationResult> authenticationResultSaver) {
        this.authenticationResultSaver = authenticationResultSaver;
    }

    public void setAccountStoreResolver(AccountStoreResolver accountStoreResolver) {
        this.accountStoreResolver = accountStoreResolver;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.accountModelFactory == null) {
            this.accountModelFactory = new DefaultAccountModelFactory();
        }
        if (this.errorModelFactory == null) {
            this.errorModelFactory = new VerifyErrorModelFactory(this.messageSource);
        }
        Assert.hasText((String)this.loginUri, (String)"loginUri cannot be null or empty.");
        Assert.hasText((String)this.loginNextUri, (String)"logoutUri cannot be null or empty.");
        Assert.notNull((Object)this.client, (String)"client cannot be null.");
        Assert.notNull((Object)this.accountModelFactory, (String)"accountModelFactory cannot be null.");
        Assert.notNull(this.authenticationResultSaver, (String)"authenticationResultSaver cannot be null.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String sptoken = Strings.clean((String)request.getParameter("sptoken"));
        if (sptoken == null) {
            if (this.isJsonPreferred(request, response)) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("status", 400);
                model.put("message", this.i18n(request, "stormpath.web.verifyEmail.form.errors.noToken"));
                response.setStatus(400);
                return new DefaultViewModel("stormpathJsonView", model);
            }
            Map<String, ?> model = this.createModel(request, response);
            return new DefaultViewModel(this.view, model).setRedirect(false);
        }
        try {
            return this.verify(request, response, sptoken);
        }
        catch (Exception e) {
            if (this.isJsonPreferred(request, response)) {
                ErrorModel error = this.errorModelFactory.toError(request, e);
                response.setStatus(error.getStatus());
                Map<String, Object> model = error.toMap();
                return new DefaultViewModel("stormpathJsonView", model);
            }
            ArrayList<ErrorModel> errors = new ArrayList<ErrorModel>();
            ErrorModel error = ErrorModel.builder().setStatus(400).setMessage(this.i18n(request, "stormpath.web.verifyEmail.form.errors.invalidLink")).build();
            errors.add(error);
            Map<String, ?> model = this.createModel(request, response, null, errors);
            return new DefaultViewModel(this.view, model);
        }
    }

    @Override
    protected List<ErrorModel> toErrors(HttpServletRequest request, Form form, Exception e) {
        return com.stormpath.sdk.lang.Collections.toList((Object[])new ErrorModel[]{this.errorModelFactory.toError(request, e)});
    }

    protected ViewModel verify(HttpServletRequest request, HttpServletResponse response, String sptoken) throws ServletException, IOException {
        Account account = this.client.verifyAccountEmail(sptoken);
        VerifiedAccountRequestEvent e = this.createVerifiedEvent(request, response, account);
        this.publish(e);
        if (this.isJsonPreferred(request, response)) {
            if (this.autoLogin) {
                TransientAuthenticationResult result = new TransientAuthenticationResult(account);
                this.authenticationResultSaver.set(request, response, result);
                HashMap<String, Map<String, Object>> model = new HashMap<String, Map<String, Object>>();
                model.put("account", this.accountModelFactory.toMap(account, Collections.EMPTY_LIST));
                return new DefaultViewModel("stormpathJsonView", model);
            }
            return null;
        }
        if (this.autoLogin) {
            TransientAuthenticationResult result = new TransientAuthenticationResult(account);
            this.authenticationResultSaver.set(request, response, result);
            return new DefaultViewModel(this.loginNextUri).setRedirect(true);
        }
        return new DefaultViewModel(this.nextUri).setRedirect(true);
    }

    protected VerifiedAccountRequestEvent createVerifiedEvent(HttpServletRequest request, HttpServletResponse response, Account account) {
        return new DefaultVerifiedAccountRequestEvent(request, response, account);
    }

    protected void publish(RequestEvent e) throws ServletException {
        try {
            this.eventPublisher.publish(e);
        }
        catch (Exception ex) {
            String msg = "Unable to publish verified account request event: " + ex.getMessage();
            throw new ServletException(msg, (Throwable)ex);
        }
    }

    @Override
    protected void appendModel(HttpServletRequest request, HttpServletResponse response, Form form, List<ErrorModel> errors, Map<String, Object> model) {
        model.put("loginUri", this.loginUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ViewModel onValidSubmit(HttpServletRequest request, HttpServletResponse response, Form form) {
        Application application = (Application)request.getAttribute(Application.class.getName());
        String login = this.getFieldValueResolver().getValue(request, "login");
        if (!StringUtils.hasText((String)login)) {
            login = this.getFieldValueResolver().getValue(request, "email");
        }
        try {
            request.setAttribute("form", (Object)form);
            AccountStore accountStore = this.accountStoreResolver.getAccountStore(request, response);
            VerificationEmailRequest verificationEmailRequest = Applications.verificationEmailBuilder().setLogin(login).setAccountStore(accountStore).build();
            application.sendVerificationEmail(verificationEmailRequest);
        }
        finally {
            if (this.isJsonPreferred(request, response)) {
                return null;
            }
            return new DefaultViewModel(this.nextUri.replace("status=verified", "status=unverified")).setRedirect(true);
        }
    }

    @Override
    protected void validate(HttpServletRequest request, HttpServletResponse response, Form form) {
        super.validate(request, response, form);
        String loginValue = form.getFieldValue("login");
        String emailValue = form.getFieldValue("email");
        if (StringUtils.hasText((String)loginValue) && StringUtils.hasText((String)emailValue)) {
            String key = "stormpath.web." + this.getControllerKey() + ".form.errors.fieldConflict";
            String msg = this.i18n(request, key);
            throw new ValidationException(msg);
        }
        if (!StringUtils.hasText((String)loginValue) && !StringUtils.hasText((String)emailValue)) {
            String key = "stormpath.web." + this.getControllerKey() + ".form.fields.login.required";
            String msg = this.i18n(request, key);
            throw new ValidationException(msg);
        }
    }
}

