/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc.provider;

import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModel;
import com.stormpath.sdk.servlet.mvc.provider.OAuthProviderModel;
import com.stormpath.sdk.servlet.mvc.provider.ProviderModel;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public class DefaultAccountStoreModel
implements AccountStoreModel {
    private final Directory directory;
    private final ProviderModel providerModel;
    private final String authorizeUri;

    public DefaultAccountStoreModel(Directory directory, ProviderModel provider, String authorizeBaseUri) {
        this.directory = directory;
        this.providerModel = provider;
        if (this.providerModel instanceof OAuthProviderModel && authorizeBaseUri != null) {
            try {
                URIBuilder builder = new URIBuilder(authorizeBaseUri);
                builder.setPath("/authorize");
                builder.addParameter("response_type", "stormpath_token");
                builder.addParameter("account_store_href", directory.getHref());
                this.authorizeUri = builder.build().toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("authorizeBaseUri must be value URI", e);
            }
        } else {
            this.authorizeUri = null;
        }
    }

    @Override
    public String getHref() {
        return this.directory.getHref();
    }

    @Override
    public String getName() {
        return this.directory.getName();
    }

    @Override
    public String getAuthorizeUri() {
        return this.authorizeUri;
    }

    @Override
    public ProviderModel getProvider() {
        return this.providerModel;
    }
}

