/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc.provider;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.provider.OAuthProvider;
import com.stormpath.sdk.provider.Provider;
import com.stormpath.sdk.servlet.mvc.provider.DefaultProviderModel;
import com.stormpath.sdk.servlet.mvc.provider.OAuthProviderModel;
import java.util.List;

public class DefaultOAuthProviderModel
extends DefaultProviderModel
implements OAuthProviderModel {
    private final String clientId;
    private final String scope;

    public DefaultOAuthProviderModel(OAuthProvider provider) {
        super((Provider)provider);
        this.clientId = provider.getClientId();
        Assert.hasText((String)this.clientId, (String)"provider clientId cannot be null or empty.");
        this.scope = DefaultOAuthProviderModel.toScopeString(provider.getScope());
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    private static String toScopeString(List<String> scopeList) {
        if (scopeList == null) {
            return null;
        }
        String scope = scopeList.toString();
        scope = scope.replaceAll("[\\s\\[\\]]", "");
        scope = scope.replaceAll(",", " ");
        return scope;
    }
}

