/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc.provider;

import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.AccountStoreVisitorAdapter;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.PasswordStrength;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.organization.OrganizationList;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.mvc.provider.PasswordStrengthModelFactory;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class DefaultPasswordStrengthModelFactory
implements PasswordStrengthModelFactory {
    @Override
    public Map<String, Object> getPasswordPolicy(HttpServletRequest request) {
        String onk = request.getParameter("organizationNameKey");
        PasswordStrength passwordStrength = Strings.hasText((String)onk) ? this.findPasswordStrengthByOrganization(request, onk) : this.getApplicationPasswordStrength(request);
        if (passwordStrength == null) {
            return null;
        }
        return this.convertPasswordStrengthToMap(passwordStrength);
    }

    private PasswordStrength getApplicationPasswordStrength(HttpServletRequest request) {
        AccountStore defaultAccountStore = ApplicationResolver.INSTANCE.getApplication((ServletRequest)request).getDefaultAccountStore();
        if (defaultAccountStore == null) {
            return null;
        }
        final PasswordStrength[] passwordStrength = new PasswordStrength[1];
        defaultAccountStore.accept(new AccountStoreVisitor(){

            public void visit(Group group) {
                passwordStrength[0] = group.getDirectory().getPasswordPolicy().getStrength();
            }

            public void visit(Directory directory) {
                passwordStrength[0] = directory.getPasswordPolicy().getStrength();
            }

            public void visit(Organization organization) {
                passwordStrength[0] = DefaultPasswordStrengthModelFactory.this.getOrganizationPasswordStrength(organization);
            }
        });
        return passwordStrength[0];
    }

    private PasswordStrength findPasswordStrengthByOrganization(HttpServletRequest request, String onk) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("nameKey", onk);
        OrganizationList organizations = ClientResolver.INSTANCE.getClient((ServletRequest)request).getOrganizations(query);
        if (organizations.getSize() != 1) {
            return null;
        }
        return this.getOrganizationPasswordStrength((Organization)organizations.single());
    }

    private PasswordStrength getOrganizationPasswordStrength(Organization organization) {
        AccountStore organizationDefaultAccountStore = organization.getDefaultAccountStore();
        if (organizationDefaultAccountStore == null) {
            return null;
        }
        final PasswordStrength[] passwordStrength = new PasswordStrength[1];
        organizationDefaultAccountStore.accept((AccountStoreVisitor)new AccountStoreVisitorAdapter(){

            public void visit(Group group) {
                passwordStrength[0] = group.getDirectory().getPasswordPolicy().getStrength();
            }

            public void visit(Directory directory) {
                passwordStrength[0] = directory.getPasswordPolicy().getStrength();
            }
        });
        return passwordStrength[0];
    }

    private Map<String, Object> convertPasswordStrengthToMap(PasswordStrength passwordStrength) {
        AbstractResource abstractResource = (AbstractResource)passwordStrength;
        HashMap<String, Object> strength = new HashMap<String, Object>();
        for (String propertyName : abstractResource.getPropertyDescriptors().keySet()) {
            strength.put(propertyName, abstractResource.getProperty(propertyName));
        }
        return strength;
    }
}

