/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.oauth.impl;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.Applications;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.impl.http.ServletHttpRequest;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.AccessTokenRequestAuthenticator;
import com.stormpath.sdk.oauth.OAuthAuthenticationResult;
import com.stormpath.sdk.oauth.RequestLocation;
import com.stormpath.sdk.oauth.ResourceRequestAuthenticator;
import com.stormpath.sdk.oauth.ScopeFactory;
import com.stormpath.sdk.servlet.oauth.ServletOAuthRequestAuthenticator;
import javax.servlet.http.HttpServletRequest;

public class DefaultServletOAuthRequestAuthenticator
implements ServletOAuthRequestAuthenticator {
    private final Application application;
    private static final String HTTP_SERVLET_REQUEST_FQCN = "javax.servlet.http.HttpServletRequest";

    public DefaultServletOAuthRequestAuthenticator(Application application) {
        this.application = application;
    }

    @Override
    public OAuthAuthenticationResult authenticate(HttpServletRequest httpRequest) {
        Assert.notNull((Object)httpRequest, (String)"httpRequest argument cannot be null.");
        Assert.isInstanceOf(HttpServletRequest.class, (Object)httpRequest, (String)"The specified httpRequest argument must be an instance of javax.servlet.http.HttpServletRequest");
        ServletHttpRequest stmpHttpRequest = new ServletHttpRequest(httpRequest);
        return Applications.oauthRequestAuthenticator((Application)this.application).authenticate((HttpRequest)stmpHttpRequest);
    }

    @Override
    public AccessTokenRequestAuthenticator using(ScopeFactory scopeFactory) {
        return Applications.oauthRequestAuthenticator((Application)this.application).using(scopeFactory);
    }

    @Override
    public AccessTokenRequestAuthenticator withTtl(long ttl) {
        return Applications.oauthRequestAuthenticator((Application)this.application).withTtl(ttl);
    }

    @Override
    public ResourceRequestAuthenticator inLocation(RequestLocation ... locations) {
        return Applications.oauthRequestAuthenticator((Application)this.application).inLocation(locations);
    }
}

