/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.oauth.impl;

import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.filter.account.JwtSigningKeyResolver;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JwtTokenSigningKeyResolver
implements JwtSigningKeyResolver {
    private static final String RSA_ERR_MSG = "RSA signatures are not currently supported by the " + JwtTokenSigningKeyResolver.class.getName() + " implementation.  You may want to implement your own JwtSigningKeyResolver implementation to support RSA keys.";
    private static final String EC_ERR_MSG = "Elliptic Curve signatures are not currently supported by the " + JwtTokenSigningKeyResolver.class.getName() + " implementation.  You may want to implement your own JwtSigningKeyResolver implementation to support Elliptic Curve keys.";

    @Override
    public Key getSigningKey(HttpServletRequest request, HttpServletResponse response, AuthenticationResult result, SignatureAlgorithm alg) {
        Assert.isTrue((!alg.isRsa() ? 1 : 0) != 0, (String)RSA_ERR_MSG);
        Assert.isTrue((!alg.isEllipticCurve() ? 1 : 0) != 0, (String)EC_ERR_MSG);
        return this.getSigningKey(request, alg);
    }

    @Override
    public Key getSigningKey(HttpServletRequest request, HttpServletResponse response, JwsHeader jwsHeader, Claims claims) {
        return this.getSigningKey(request, SignatureAlgorithm.forName((String)jwsHeader.getAlgorithm()));
    }

    protected Key getSigningKey(HttpServletRequest request, SignatureAlgorithm alg) {
        Client client = ClientResolver.INSTANCE.getClient((ServletRequest)request);
        Assert.notNull((Object)client, (String)"Client must be accessible as a request attribute.");
        String apiKeySecret = client.getApiKey().getSecret();
        return new SecretKeySpec(apiKeySecret.getBytes(Charset.forName("UTF-8")), alg.getJcaName());
    }
}

