/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.util;

import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.util.GrantTypeValidator;

public class DefaultGrantTypeValidator
implements GrantTypeValidator {
    private boolean clientCredentialsGrantTypeEnabled;
    private boolean passwordGrantTypeEnabled;

    public void setClientCredentialsGrantTypeEnabled(boolean clientCredentialsGrantTypeEnabled) {
        this.clientCredentialsGrantTypeEnabled = clientCredentialsGrantTypeEnabled;
    }

    public void setPasswordGrantTypeEnabled(boolean passwordGrantTypeEnabled) {
        this.passwordGrantTypeEnabled = passwordGrantTypeEnabled;
    }

    @Override
    public void validate(String grantType) throws OAuthException {
        switch (grantType) {
            case "password": {
                if (this.passwordGrantTypeEnabled) break;
                throw new OAuthException(OAuthErrorCode.UNSUPPORTED_GRANT_TYPE, "'password' is an unsupported grant type.");
            }
            case "client_credentials": {
                if (this.clientCredentialsGrantTypeEnabled) break;
                throw new OAuthException(OAuthErrorCode.UNSUPPORTED_GRANT_TYPE, "'client_credentials' is an unsupported grant type.");
            }
        }
    }
}

