/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.util;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.util.RemoteAddrResolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IsLocalhostResolver
implements Resolver<Boolean> {
    private final Resolver<String> remoteAddrResolver;

    public IsLocalhostResolver() {
        this(new RemoteAddrResolver());
    }

    public IsLocalhostResolver(Resolver<String> remoteAddrResolver) {
        Assert.notNull(remoteAddrResolver, (String)"remoteAddrResolver cannot be null.");
        this.remoteAddrResolver = remoteAddrResolver;
    }

    @Override
    public Boolean get(HttpServletRequest request, HttpServletResponse response) {
        String host = this.getRemoteAddr(request, response);
        return host != null && (host.equalsIgnoreCase("localhost") || host.equals("127.0.0.1") || host.startsWith("::1") || host.startsWith("0:0:0:0:0:0:0:1"));
    }

    protected String getRemoteAddr(HttpServletRequest request, HttpServletResponse response) {
        return this.remoteAddrResolver.get(request, response);
    }
}

