/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.documentation.Decision;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Image;
import com.structurizr.documentation.Section;
import com.structurizr.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Documentation {
    private List<Section> sections = new ArrayList<Section>();
    private Set<Decision> decisions = new TreeSet<Decision>();
    private Set<Image> images = new TreeSet<Image>();

    public void addSection(Section section) {
        this.checkFormatIsSpecified(section.getFormat());
        section.setOrder(this.calculateOrder());
        this.sections.add(section);
    }

    private void checkTitleIsSpecified(String title) {
        if (StringUtils.isNullOrEmpty(title)) {
            throw new IllegalArgumentException("A title must be specified.");
        }
    }

    private void checkContentIsSpecified(String content) {
        if (StringUtils.isNullOrEmpty(content)) {
            throw new IllegalArgumentException("Content must be specified.");
        }
    }

    private void checkFormatIsSpecified(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("A format must be specified.");
        }
    }

    private int calculateOrder() {
        return this.sections.size() + 1;
    }

    public Collection<Section> getSections() {
        return new ArrayList<Section>(this.sections);
    }

    void setSections(Collection<Section> sections) {
        if (sections != null) {
            this.sections = new ArrayList<Section>(sections);
        }
    }

    public Set<Decision> getDecisions() {
        return new TreeSet<Decision>(this.decisions);
    }

    void setDecisions(Set<Decision> decisions) {
        if (decisions != null) {
            this.decisions = new TreeSet<Decision>(decisions);
        }
    }

    public void addDecision(Decision decision) {
        this.checkIdIsSpecified(decision.getId());
        this.checkTitleIsSpecified(decision.getTitle());
        this.checkContentIsSpecified(decision.getContent());
        this.checkDecisionStatusIsSpecified(decision.getStatus());
        this.checkFormatIsSpecified(decision.getFormat());
        this.checkDecisionIsUnique(decision.getId());
        this.decisions.add(decision);
    }

    private void checkIdIsSpecified(String id) {
        if (StringUtils.isNullOrEmpty(id)) {
            throw new IllegalArgumentException("An ID must be specified.");
        }
    }

    private void checkDecisionStatusIsSpecified(String status) {
        if (status == null) {
            throw new IllegalArgumentException("A status must be specified.");
        }
    }

    private void checkDecisionIsUnique(String id) {
        for (Decision decision : this.decisions) {
            if (!id.equals(decision.getId())) continue;
            throw new IllegalArgumentException("A decision with an ID of " + id + " already exists in this scope.");
        }
    }

    public void addImage(Image image) {
        this.images.add(image);
    }

    public Set<Image> getImages() {
        return new TreeSet<Image>(this.images);
    }

    void setImages(Set<Image> images) {
        if (images != null) {
            this.images = new TreeSet<Image>(images);
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.sections.isEmpty() && this.images.isEmpty() && this.decisions.isEmpty();
    }

    public void clear() {
        this.sections = new ArrayList<Section>();
        this.decisions = new TreeSet<Decision>();
        this.images = new TreeSet<Image>();
    }
}

