/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.View;

public final class ImageView
extends View {
    private Element element;
    private String elementId;
    private String content;
    private String contentLight;
    private String contentDark;
    private String contentType;

    ImageView() {
    }

    ImageView(String key) {
        this.setKey(key);
    }

    ImageView(Element element, String key) {
        this(key);
        this.setElement(element);
    }

    public String getElementId() {
        if (this.element != null) {
            return this.element.getId();
        }
        return this.elementId;
    }

    void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @JsonIgnore
    public Element getElement() {
        return this.element;
    }

    void setElement(Element element) {
        this.element = element;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentLight() {
        return this.contentLight;
    }

    public String getContentDark() {
        return this.contentDark;
    }

    public void setContent(String content) {
        this.setContent(content, null);
    }

    public void setContent(String content, ColorScheme colorScheme) {
        if (StringUtils.isNullOrEmpty(content)) {
            if (colorScheme == ColorScheme.Dark) {
                this.contentDark = null;
            } else if (colorScheme == ColorScheme.Light) {
                this.contentLight = null;
            } else {
                this.content = null;
            }
        } else {
            ImageUtils.validateImage(content);
            content = content.trim();
            if (colorScheme == ColorScheme.Dark) {
                this.contentDark = content;
            } else if (colorScheme == ColorScheme.Light) {
                this.contentLight = content;
            } else {
                this.content = content;
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    public boolean hasContent() {
        return !StringUtils.isNullOrEmpty(this.content) || !StringUtils.isNullOrEmpty(this.contentLight) || !StringUtils.isNullOrEmpty(this.contentDark);
    }
}

