/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.structurizr.WorkspaceValidationException;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.AutomaticLayout;
import com.structurizr.view.ComponentView;
import com.structurizr.view.Configuration;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.FilterMode;
import com.structurizr.view.FilteredView;
import com.structurizr.view.ImageView;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ViewSet {
    private static final Log log = LogFactory.getLog(ViewSet.class);
    public static final String SYSTEM_LANDSCAPE_VIEW_TYPE = "SystemLandscape";
    public static final String SYSTEM_CONTEXT_VIEW_TYPE = "SystemContext";
    public static final String CONTAINER_VIEW_TYPE = "Container";
    public static final String COMPONENT_VIEW_TYPE = "Component";
    public static final String DYNAMIC_VIEW_TYPE = "Dynamic";
    public static final String DEPLOYMENT_VIEW_TYPE = "Deployment";
    public static final String FILTERED_VIEW_TYPE = "Filtered";
    public static final String IMAGE_VIEW_TYPE = "Image";
    public static final String CUSTOM_VIEW_TYPE = "Custom";
    private Model model;
    private Collection<CustomView> customViews = new TreeSet<CustomView>();
    private Collection<SystemLandscapeView> systemLandscapeViews = new TreeSet<SystemLandscapeView>();
    private Collection<SystemContextView> systemContextViews = new TreeSet<SystemContextView>();
    private Collection<ContainerView> containerViews = new TreeSet<ContainerView>();
    private Collection<ComponentView> componentViews = new TreeSet<ComponentView>();
    private Collection<DynamicView> dynamicViews = new TreeSet<DynamicView>();
    private Collection<DeploymentView> deploymentViews = new TreeSet<DeploymentView>();
    private Collection<ImageView> imageViews = new TreeSet<ImageView>();
    private Collection<FilteredView> filteredViews = new TreeSet<FilteredView>();
    private Configuration configuration = new Configuration();

    ViewSet() {
    }

    ViewSet(Model model) {
        this.model = model;
    }

    public CustomView createCustomView(String key, String title) {
        return this.createCustomView(key, title, "");
    }

    public CustomView createCustomView(String key, String title, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(CUSTOM_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        CustomView view = new CustomView(this.model, key, title, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.customViews.add(view);
        return view;
    }

    public SystemLandscapeView createSystemLandscapeView(String key) {
        return this.createSystemLandscapeView(key, "");
    }

    public SystemLandscapeView createSystemLandscapeView(String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(SYSTEM_LANDSCAPE_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        SystemLandscapeView view = new SystemLandscapeView(this.model, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.systemLandscapeViews.add(view);
        return view;
    }

    public SystemContextView createSystemContextView(SoftwareSystem softwareSystem, String key) {
        return this.createSystemContextView(softwareSystem, key, "");
    }

    public SystemContextView createSystemContextView(SoftwareSystem softwareSystem, String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(SYSTEM_CONTEXT_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        SystemContextView view = new SystemContextView(softwareSystem, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.systemContextViews.add(view);
        return view;
    }

    public ContainerView createContainerView(SoftwareSystem softwareSystem, String key) {
        return this.createContainerView(softwareSystem, key, "");
    }

    public ContainerView createContainerView(SoftwareSystem softwareSystem, String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(CONTAINER_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        ContainerView view = new ContainerView(softwareSystem, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.containerViews.add(view);
        return view;
    }

    public ComponentView createComponentView(Container container, String key) {
        return this.createComponentView(container, key, "");
    }

    public ComponentView createComponentView(Container container, String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(COMPONENT_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheContainerIsNotNull(container);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        ComponentView view = new ComponentView(container, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.componentViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(String key) {
        return this.createDynamicView(key, "");
    }

    public DynamicView createDynamicView(String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(DYNAMIC_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DynamicView view = new DynamicView(this.model, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.dynamicViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(SoftwareSystem softwareSystem, String key) {
        return this.createDynamicView(softwareSystem, key, "");
    }

    public DynamicView createDynamicView(SoftwareSystem softwareSystem, String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(DYNAMIC_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DynamicView view = new DynamicView(softwareSystem, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.dynamicViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(Container container, String key) {
        return this.createDynamicView(container, key, "");
    }

    public DynamicView createDynamicView(Container container, String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(DYNAMIC_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheContainerIsNotNull(container);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DynamicView view = new DynamicView(container, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.dynamicViews.add(view);
        return view;
    }

    public DeploymentView createDeploymentView(String key) {
        return this.createDeploymentView(key, "");
    }

    public DeploymentView createDeploymentView(String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(DEPLOYMENT_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DeploymentView view = new DeploymentView(this.model, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.deploymentViews.add(view);
        return view;
    }

    public DeploymentView createDeploymentView(SoftwareSystem softwareSystem, String key) {
        return this.createDeploymentView(softwareSystem, key, "");
    }

    public DeploymentView createDeploymentView(SoftwareSystem softwareSystem, String key, String description) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(DEPLOYMENT_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DeploymentView view = new DeploymentView(softwareSystem, key, description);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.deploymentViews.add(view);
        return view;
    }

    public FilteredView createFilteredView(StaticView view, String key, FilterMode mode, String ... tags) {
        return this.createFilteredView(view, key, "", mode, tags);
    }

    public FilteredView createFilteredView(StaticView view, String key, String description, FilterMode mode, String ... tags) {
        return this.newFilteredView(view, key, description, mode, tags);
    }

    public FilteredView createFilteredView(DeploymentView view, String key, String description, FilterMode mode, String ... tags) {
        return this.newFilteredView(view, key, description, mode, tags);
    }

    private FilteredView newFilteredView(ModelView view, String key, String description, FilterMode mode, String ... tags) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(FILTERED_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheViewIsNotNull(view);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        FilteredView filteredView = new FilteredView(view, key, description, mode, tags);
        filteredView.setGeneratedKey(keyIsAutomaticallyGenerated);
        filteredView.setOrder(this.getNextOrder());
        filteredView.setViewSet(this);
        this.filteredViews.add(filteredView);
        return filteredView;
    }

    public ImageView createImageView(String key) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(IMAGE_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        ImageView view = new ImageView(key);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.imageViews.add(view);
        return view;
    }

    public ImageView createImageView(Element element, String key) {
        boolean keyIsAutomaticallyGenerated = false;
        if (StringUtils.isNullOrEmpty(key)) {
            key = this.generateViewKey(IMAGE_VIEW_TYPE);
            keyIsAutomaticallyGenerated = true;
        }
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        ImageView view = new ImageView(element, key);
        view.setGeneratedKey(keyIsAutomaticallyGenerated);
        view.setOrder(this.getNextOrder());
        view.setViewSet(this);
        this.imageViews.add(view);
        return view;
    }

    private void assertThatTheViewKeyIsSpecifiedAndUnique(String key) {
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        if (this.getViewWithKey(key) != null || this.getFilteredViewWithKey(key) != null || this.getImageViewWithKey(key) != null) {
            throw new IllegalArgumentException("A view with the key " + key + " already exists.");
        }
    }

    private void assertThatTheSoftwareSystemIsNotNull(SoftwareSystem softwareSystem) {
        if (softwareSystem == null) {
            throw new IllegalArgumentException("A software system must be specified.");
        }
    }

    private void assertThatTheContainerIsNotNull(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("A container must be specified.");
        }
    }

    private void assertThatTheViewIsNotNull(View view) {
        if (view == null) {
            throw new IllegalArgumentException("A view must be specified.");
        }
    }

    public View getViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        return this.getViews().stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    public void removeViewWithKey(String key) {
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("A view key must be specified.");
        }
        View view = this.getViewWithKey(key);
        if (view == null) {
            throw new IllegalArgumentException("A view with key \"" + key + "\" does not exist.");
        }
        for (FilteredView filteredView : this.filteredViews) {
            if (!filteredView.getBaseViewKey().equals(key)) continue;
            throw new IllegalArgumentException("A filtered view based upon \"" + key + "\" exists - please remove this first.");
        }
        if (view instanceof CustomView) {
            this.customViews.remove(view);
        } else if (view instanceof SystemLandscapeView) {
            this.systemLandscapeViews.remove(view);
        } else if (view instanceof SystemContextView) {
            this.systemContextViews.remove(view);
        } else if (view instanceof ContainerView) {
            this.containerViews.remove(view);
        } else if (view instanceof ComponentView) {
            this.componentViews.remove(view);
        } else if (view instanceof DynamicView) {
            this.dynamicViews.remove(view);
        } else if (view instanceof DeploymentView) {
            this.deploymentViews.remove(view);
        } else if (view instanceof ImageView) {
            this.imageViews.remove(view);
        } else if (view instanceof FilteredView) {
            this.filteredViews.remove(view);
        }
    }

    FilteredView getFilteredViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        return this.filteredViews.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    ImageView getImageViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        return this.imageViews.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    public Collection<CustomView> getCustomViews() {
        return new TreeSet<CustomView>(this.customViews);
    }

    void setCustomViews(Set<CustomView> customViews) {
        if (customViews != null) {
            this.customViews = new TreeSet<CustomView>(customViews);
        }
    }

    public Collection<SystemLandscapeView> getSystemLandscapeViews() {
        return new TreeSet<SystemLandscapeView>(this.systemLandscapeViews);
    }

    void setSystemLandscapeViews(Set<SystemLandscapeView> systemLandscapeViews) {
        if (systemLandscapeViews != null) {
            this.systemLandscapeViews = new TreeSet<SystemLandscapeView>(systemLandscapeViews);
        }
    }

    @JsonSetter(value="enterpriseContextViews")
    void setEnterpriseContextViews(Collection<SystemLandscapeView> enterpriseContextViews) {
        if (enterpriseContextViews != null) {
            this.systemLandscapeViews = new TreeSet<SystemLandscapeView>(enterpriseContextViews);
        }
    }

    public Collection<SystemContextView> getSystemContextViews() {
        return new TreeSet<SystemContextView>(this.systemContextViews);
    }

    void setSystemContextViews(Set<SystemContextView> systemContextViews) {
        if (systemContextViews != null) {
            this.systemContextViews = new TreeSet<SystemContextView>(systemContextViews);
        }
    }

    public Collection<ContainerView> getContainerViews() {
        return new TreeSet<ContainerView>(this.containerViews);
    }

    void setContainerViews(Set<ContainerView> containerViews) {
        if (containerViews != null) {
            this.containerViews = new TreeSet<ContainerView>(containerViews);
        }
    }

    public Collection<ComponentView> getComponentViews() {
        return new TreeSet<ComponentView>(this.componentViews);
    }

    void setComponentViews(Set<ComponentView> componentViews) {
        if (componentViews != null) {
            this.componentViews = new TreeSet<ComponentView>(componentViews);
        }
    }

    public Collection<DynamicView> getDynamicViews() {
        return new TreeSet<DynamicView>(this.dynamicViews);
    }

    void setDynamicViews(Set<DynamicView> dynamicViews) {
        if (dynamicViews != null) {
            this.dynamicViews = new TreeSet<DynamicView>(dynamicViews);
        }
    }

    public Collection<FilteredView> getFilteredViews() {
        return new TreeSet<FilteredView>(this.filteredViews);
    }

    void setFilteredViews(Set<FilteredView> filteredViews) {
        if (filteredViews != null) {
            this.filteredViews = new TreeSet<FilteredView>(filteredViews);
        }
    }

    public Collection<DeploymentView> getDeploymentViews() {
        return new TreeSet<DeploymentView>(this.deploymentViews);
    }

    void setDeploymentViews(Set<DeploymentView> deploymentViews) {
        if (deploymentViews != null) {
            this.deploymentViews = new TreeSet<DeploymentView>(deploymentViews);
        }
    }

    public Collection<ImageView> getImageViews() {
        return new TreeSet<ImageView>(this.imageViews);
    }

    void setImageViews(Set<ImageView> imageViews) {
        if (imageViews != null) {
            this.imageViews = new TreeSet<ImageView>(imageViews);
        }
    }

    @JsonIgnore
    public Collection<View> getViews() {
        TreeSet<View> views = new TreeSet<View>();
        views.addAll(this.getCustomViews());
        views.addAll(this.getSystemLandscapeViews());
        views.addAll(this.getSystemContextViews());
        views.addAll(this.getContainerViews());
        views.addAll(this.getComponentViews());
        views.addAll(this.getDynamicViews());
        views.addAll(this.getDeploymentViews());
        views.addAll(this.getFilteredViews());
        views.addAll(this.getImageViews());
        return views;
    }

    void hydrate(Model model) {
        Element element;
        SoftwareSystem softwareSystem;
        this.model = model;
        this.checkViewKeysAreUnique();
        for (CustomView customView : this.customViews) {
            customView.setModel(model);
            this.hydrateView(customView);
        }
        for (SystemLandscapeView systemLandscapeView : this.systemLandscapeViews) {
            systemLandscapeView.setModel(model);
            this.hydrateView(systemLandscapeView);
        }
        for (SystemContextView systemContextView : this.systemContextViews) {
            softwareSystem = model.getSoftwareSystemWithId(systemContextView.getSoftwareSystemId());
            if (softwareSystem == null) {
                throw new WorkspaceValidationException(String.format("The system context view with key \"%s\" is associated with a software system (id=%s), but that element does not exist in the model.", systemContextView.getKey(), systemContextView.getSoftwareSystemId()));
            }
            systemContextView.setSoftwareSystem(softwareSystem);
            this.hydrateView(systemContextView);
        }
        for (ContainerView containerView : this.containerViews) {
            softwareSystem = model.getSoftwareSystemWithId(containerView.getSoftwareSystemId());
            if (softwareSystem == null) {
                throw new WorkspaceValidationException(String.format("The container view with key \"%s\" is associated with a software system (id=%s), but that element does not exist in the model.", containerView.getKey(), containerView.getSoftwareSystemId()));
            }
            containerView.setSoftwareSystem(softwareSystem);
            this.hydrateView(containerView);
        }
        for (ComponentView componentView : this.componentViews) {
            Container container = (Container)model.getElement(componentView.getContainerId());
            if (container == null) {
                throw new WorkspaceValidationException(String.format("The component view with key \"%s\" is associated with a container (id=%s), but that element does not exist in the model.", componentView.getKey(), componentView.getContainerId()));
            }
            componentView.setContainer(container);
            componentView.setSoftwareSystem(container.getSoftwareSystem());
            this.hydrateView(componentView);
        }
        for (DynamicView dynamicView : this.dynamicViews) {
            if (!StringUtils.isNullOrEmpty(dynamicView.getElementId())) {
                element = model.getElement(dynamicView.getElementId());
                if (element == null) {
                    throw new WorkspaceValidationException(String.format("The dynamic view with key \"%s\" is associated with an element (id=%s), but that element does not exist in the model.", dynamicView.getKey(), dynamicView.getElementId()));
                }
                dynamicView.setElement(element);
            }
            dynamicView.setModel(model);
            this.hydrateView(dynamicView);
        }
        for (DeploymentView deploymentView : this.deploymentViews) {
            if (!StringUtils.isNullOrEmpty(deploymentView.getSoftwareSystemId())) {
                softwareSystem = model.getSoftwareSystemWithId(deploymentView.getSoftwareSystemId());
                if (softwareSystem == null) {
                    throw new WorkspaceValidationException(String.format("The deployment view with key \"%s\" is associated with a software system (id=%s), but that element does not exist in the model.", deploymentView.getKey(), deploymentView.getSoftwareSystemId()));
                }
                deploymentView.setSoftwareSystem(softwareSystem);
            }
            deploymentView.setModel(model);
            this.hydrateView(deploymentView);
        }
        for (FilteredView filteredView : this.filteredViews) {
            View view = this.getViewWithKey(filteredView.getBaseViewKey());
            if (view == null) {
                throw new WorkspaceValidationException(String.format("The filtered view with key \"%s\" is based upon a view (key=%s), but that view does not exist in the workspace.", filteredView.getKey(), filteredView.getBaseViewKey()));
            }
            if (view instanceof StaticView || view instanceof DeploymentView) {
                filteredView.setView((ModelView)view);
                continue;
            }
            throw new WorkspaceValidationException(String.format("The filtered view with key \"%s\" is based upon a view (key=%s), but that view is not a static or deployment view.", filteredView.getKey(), filteredView.getBaseViewKey()));
        }
        for (ImageView imageView : this.imageViews) {
            if (StringUtils.isNullOrEmpty(imageView.getElementId())) continue;
            element = model.getElement(imageView.getElementId());
            if (element == null) {
                throw new WorkspaceValidationException(String.format("The image view with key \"%s\" is associated with an element (id=%s), but that element does not exist in the model.", imageView.getKey(), imageView.getElementId()));
            }
            imageView.setElement(element);
        }
    }

    private void hydrateView(ModelView view) {
        view.setViewSet(this);
        for (ElementView elementView : view.getElements()) {
            Element element = this.model.getElement(elementView.getId());
            if (element == null) {
                throw new WorkspaceValidationException(String.format("The view with key \"%s\" references an element (id=%s), but that element does not exist in the model.", view.getKey(), elementView.getId()));
            }
            elementView.setElement(element);
        }
        for (RelationshipView relationshipView : view.getRelationships()) {
            Relationship relationship = this.model.getRelationship(relationshipView.getId());
            if (relationship == null) {
                throw new WorkspaceValidationException(String.format("The view with key \"%s\" references a relationship (id=%s), but that relationship does not exist in the model.", view.getKey(), relationshipView.getId()));
            }
            relationshipView.setRelationship(relationship);
        }
    }

    private void checkViewKeysAreUnique() {
        HashSet<String> keys = new HashSet<String>();
        for (View view : this.getViews()) {
            if (keys.contains(view.getKey())) {
                throw new WorkspaceValidationException("A view with the key " + view.getKey() + " already exists.");
            }
            keys.add(view.getKey());
        }
    }

    private synchronized int getNextOrder() {
        return this.getViews().stream().max(Comparator.comparingInt(View::getOrder)).map(View::getOrder).orElse(0) + 1;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void copyLayoutInformationFrom(ViewSet source) {
        ModelView sourceView;
        for (CustomView customView : this.customViews) {
            if (customView.getAutomaticLayout() != null || !customView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getCustomViews(), customView);
            if (sourceView != null) {
                customView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + customView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (SystemLandscapeView systemLandscapeView : this.systemLandscapeViews) {
            if (systemLandscapeView.getAutomaticLayout() != null || !systemLandscapeView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getSystemLandscapeViews(), systemLandscapeView);
            if (sourceView != null) {
                systemLandscapeView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + systemLandscapeView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (SystemContextView systemContextView : this.systemContextViews) {
            if (systemContextView.getAutomaticLayout() != null || !systemContextView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getSystemContextViews(), systemContextView);
            if (sourceView != null) {
                systemContextView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + systemContextView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (ContainerView containerView : this.containerViews) {
            if (containerView.getAutomaticLayout() != null || !containerView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getContainerViews(), containerView);
            if (sourceView != null) {
                containerView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + containerView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (ComponentView componentView : this.componentViews) {
            if (componentView.getAutomaticLayout() != null || !componentView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getComponentViews(), componentView);
            if (sourceView != null) {
                componentView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + componentView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (DynamicView dynamicView : this.dynamicViews) {
            if (dynamicView.getAutomaticLayout() != null || !dynamicView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getDynamicViews(), dynamicView);
            if (sourceView != null) {
                dynamicView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + dynamicView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (DeploymentView deploymentView : this.deploymentViews) {
            if (deploymentView.getAutomaticLayout() != null || !deploymentView.getMergeFromRemote()) continue;
            sourceView = this.findView(source.getDeploymentViews(), deploymentView);
            if (sourceView != null) {
                deploymentView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + deploymentView.getName() + "\" ... diagram layout information may be lost."));
        }
    }

    private <T extends View> T findView(Collection<T> views, T sourceView) {
        for (View view : views) {
            if (view.getKey() == null || !view.getKey().equals(sourceView.getKey())) continue;
            return (T)view;
        }
        for (View view : views) {
            if (!view.getName().equals(sourceView.getName())) continue;
            if (view.getDescription() != null) {
                if (!view.getDescription().equals(sourceView.getDescription())) continue;
                return (T)view;
            }
            return (T)view;
        }
        return null;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.customViews.isEmpty() && this.systemLandscapeViews.isEmpty() && this.systemContextViews.isEmpty() && this.containerViews.isEmpty() && this.componentViews.isEmpty() && this.dynamicViews.isEmpty() && this.deploymentViews.isEmpty() && this.filteredViews.isEmpty() && this.imageViews.isEmpty();
    }

    private String generateViewKey(String prefix) {
        DecimalFormat format = new DecimalFormat("000");
        int counter = 1;
        String key = prefix + "-" + format.format(counter);
        while (this.hasViewWithKey(key)) {
            key = prefix + "-" + format.format(++counter);
        }
        return key;
    }

    private boolean hasViewWithKey(String key) {
        return this.getViews().stream().anyMatch(view -> view.getKey().equals(key));
    }

    public void createDefaultViews() {
        SystemLandscapeView systemLandscapeView = this.createSystemLandscapeView("", "");
        systemLandscapeView.addDefaultElements();
        systemLandscapeView.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 300);
        if (!this.model.getSoftwareSystems().isEmpty()) {
            ArrayList<SoftwareSystem> softwareSystems = new ArrayList<SoftwareSystem>(this.model.getSoftwareSystems());
            softwareSystems.sort(Comparator.comparing(Element::getName));
            for (SoftwareSystem softwareSystem : softwareSystems) {
                SystemContextView systemContextView = this.createSystemContextView(softwareSystem, "", "");
                systemContextView.addDefaultElements();
                systemContextView.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 300);
                if (softwareSystem.getContainers().size() <= 0) continue;
                ArrayList<Container> containers = new ArrayList<Container>(softwareSystem.getContainers());
                containers.sort(Comparator.comparing(Element::getName));
                ContainerView containerView = this.createContainerView(softwareSystem, "", "");
                containerView.addDefaultElements();
                containerView.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 300);
                Iterator iterator = containers.iterator();
                while (iterator.hasNext()) {
                    Container container = (Container)iterator.next();
                    if (container.getComponents().size() <= 0) continue;
                    ComponentView componentView = this.createComponentView(container, "", "");
                    componentView.addDefaultElements();
                    componentView.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 300);
                }
            }
        }
        ArrayList<String> deploymentEnvironments = new ArrayList<String>();
        for (DeploymentNode deploymentNode : this.model.getDeploymentNodes()) {
            String environment = deploymentNode.getEnvironment();
            if (deploymentEnvironments.contains(environment)) continue;
            deploymentEnvironments.add(environment);
        }
        deploymentEnvironments.sort(String::compareTo);
        for (String deploymentEnvironment : deploymentEnvironments) {
            ArrayList<SoftwareSystem> softwareSystems = new ArrayList<SoftwareSystem>();
            for (DeploymentNode deploymentNode : this.model.getDeploymentNodes()) {
                if (!deploymentNode.getEnvironment().equals(deploymentEnvironment)) continue;
                Set<SoftwareSystemInstance> softwareSystemInstances = this.getSoftwareSystemInstances(deploymentNode);
                for (SoftwareSystemInstance softwareSystemInstance : softwareSystemInstances) {
                    SoftwareSystem softwareSystem = softwareSystemInstance.getSoftwareSystem();
                    if (softwareSystems.contains(softwareSystem)) continue;
                    softwareSystems.add(softwareSystem);
                }
                Set<ContainerInstance> containerInstances = this.getContainerInstances(deploymentNode);
                for (ContainerInstance containerInstance : containerInstances) {
                    SoftwareSystem softwareSystem = containerInstance.getContainer().getSoftwareSystem();
                    if (softwareSystems.contains(softwareSystem)) continue;
                    softwareSystems.add(softwareSystem);
                }
            }
            if (softwareSystems.isEmpty()) {
                if (!this.model.getElements().stream().anyMatch(e -> e instanceof InfrastructureNode && ((InfrastructureNode)e).getEnvironment().equals(deploymentEnvironment))) continue;
                DeploymentView deploymentView = this.createDeploymentView("", "");
                deploymentView.setEnvironment(deploymentEnvironment);
                deploymentView.addDefaultElements();
                deploymentView.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 300);
                continue;
            }
            softwareSystems.sort(Comparator.comparing(Element::getName));
            for (SoftwareSystem softwareSystem : softwareSystems) {
                DeploymentView deploymentView = this.createDeploymentView(softwareSystem, "", "");
                deploymentView.setEnvironment(deploymentEnvironment);
                deploymentView.addDefaultElements();
                deploymentView.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 300);
            }
        }
    }

    private Set<SoftwareSystemInstance> getSoftwareSystemInstances(DeploymentNode deploymentNode) {
        TreeSet<SoftwareSystemInstance> softwareSystemInstances = new TreeSet<SoftwareSystemInstance>(deploymentNode.getSoftwareSystemInstances());
        for (DeploymentNode child : deploymentNode.getChildren()) {
            softwareSystemInstances.addAll(this.getSoftwareSystemInstances(child));
        }
        return softwareSystemInstances;
    }

    private Set<ContainerInstance> getContainerInstances(DeploymentNode deploymentNode) {
        TreeSet<ContainerInstance> containerInstances = new TreeSet<ContainerInstance>(deploymentNode.getContainerInstances());
        for (DeploymentNode child : deploymentNode.getChildren()) {
            containerInstances.addAll(this.getContainerInstances(child));
        }
        return containerInstances;
    }

    public void clear() {
        this.customViews = new TreeSet<CustomView>();
        this.systemLandscapeViews = new TreeSet<SystemLandscapeView>();
        this.systemContextViews = new TreeSet<SystemContextView>();
        this.containerViews = new TreeSet<ContainerView>();
        this.componentViews = new TreeSet<ComponentView>();
        this.dynamicViews = new TreeSet<DynamicView>();
        this.deploymentViews = new TreeSet<DeploymentView>();
        this.filteredViews = new TreeSet<FilteredView>();
        this.configuration = new Configuration();
    }
}

