/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.ilograph;

import com.structurizr.Workspace;
import com.structurizr.export.AbstractWorkspaceExporter;
import com.structurizr.export.IndentingWriter;
import com.structurizr.export.WorkspaceExport;
import com.structurizr.export.ilograph.IlographWorkspaceExport;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.GroupableElement;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Model;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Configuration;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IlographExporter
extends AbstractWorkspaceExporter {
    public static final String ILOGRAPH_IMPORTS = "ilograph.imports";
    public static final String ILOGRAPH_ICON = "ilograph.icon";

    @Override
    public WorkspaceExport export(Workspace workspace) {
        ArrayList<Relationship> sortedRelationships;
        IndentingWriter writer = new IndentingWriter();
        String commaSeparatedListOfImports = (String)workspace.getProperties().get(ILOGRAPH_IMPORTS);
        if (!StringUtils.isNullOrEmpty((String)commaSeparatedListOfImports)) {
            String[] ilographImports;
            writer.writeLine("imports:");
            for (String string : ilographImports = commaSeparatedListOfImports.split(",")) {
                String[] stringArray = string.split(":");
                if (stringArray.length != 2) continue;
                String string2 = stringArray[0];
                String from = stringArray[1];
                writer.writeLine("- from: " + from);
                writer.indent();
                writer.writeLine("namespace: " + string2);
                writer.outdent();
            }
            writer.writeLine();
        }
        writer.writeLine("resources:");
        writer.indent();
        Model model = workspace.getModel();
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<CustomElement> customElements = new ArrayList<CustomElement>(model.getCustomElements());
        customElements.sort(Comparator.comparing(ModelItem::getId));
        for (CustomElement customElement : customElements) {
            this.writeElement(writer, workspace, (Element)customElement);
            elements.add(customElement);
        }
        ArrayList<Person> people = new ArrayList<Person>(model.getPeople());
        people.sort(Comparator.comparing(ModelItem::getId));
        for (Person person : people) {
            this.writeElement(writer, workspace, (Element)person);
            elements.add(person);
        }
        ArrayList<SoftwareSystem> arrayList = new ArrayList<SoftwareSystem>(model.getSoftwareSystems());
        arrayList.sort(Comparator.comparing(ModelItem::getId));
        for (SoftwareSystem softwareSystem : arrayList) {
            this.writeElement(writer, workspace, (Element)softwareSystem);
            elements.add(softwareSystem);
            if (softwareSystem.getContainers().isEmpty()) continue;
            writer.indent();
            writer.writeLine("children:");
            writer.indent();
            ArrayList<Container> containers = new ArrayList<Container>(softwareSystem.getContainers());
            containers.sort(Comparator.comparing(ModelItem::getId));
            for (Container container : containers) {
                this.writeElement(writer, workspace, (Element)container);
                elements.add(container);
                if (container.getComponents().isEmpty()) continue;
                writer.indent();
                writer.writeLine("children:");
                writer.indent();
                ArrayList<Component> components = new ArrayList<Component>(container.getComponents());
                components.sort(Comparator.comparing(ModelItem::getId));
                for (Component component : components) {
                    this.writeElement(writer, workspace, (Element)component);
                    elements.add(component);
                }
                writer.outdent();
                writer.outdent();
            }
            writer.outdent();
            writer.outdent();
        }
        ArrayList<DeploymentNode> arrayList2 = new ArrayList<DeploymentNode>(model.getDeploymentNodes());
        arrayList2.sort(Comparator.comparing(ModelItem::getId));
        for (DeploymentNode deploymentNode : arrayList2) {
            this.writeDeploymentNode(workspace, deploymentNode, writer);
        }
        LinkedHashSet<Relationship> linkedHashSet = new LinkedHashSet<Relationship>();
        HashSet<Class> elementTypes = new HashSet<Class>();
        elementTypes.add(CustomElement.class);
        elementTypes.add(Person.class);
        elementTypes.add(SoftwareSystem.class);
        for (GroupableElement groupableElement : elements) {
            sortedRelationships = new ArrayList<Relationship>(groupableElement.getRelationships());
            sortedRelationships.sort(Comparator.comparing(ModelItem::getId));
            for (Relationship relationship : sortedRelationships) {
                if (!this.include(relationship, elementTypes)) continue;
                linkedHashSet.add(relationship);
            }
        }
        elementTypes.add(Container.class);
        for (GroupableElement groupableElement : elements) {
            sortedRelationships = new ArrayList(groupableElement.getRelationships());
            sortedRelationships.sort(Comparator.comparing(ModelItem::getId));
            for (Relationship relationship : sortedRelationships) {
                if (!this.include(relationship, elementTypes)) continue;
                linkedHashSet.add(relationship);
            }
        }
        elementTypes.add(Component.class);
        for (GroupableElement groupableElement : elements) {
            sortedRelationships = new ArrayList(groupableElement.getRelationships());
            sortedRelationships.sort(Comparator.comparing(ModelItem::getId));
            for (Relationship relationship : sortedRelationships) {
                if (!this.include(relationship, elementTypes)) continue;
                linkedHashSet.add(relationship);
            }
        }
        writer.outdent();
        this.writeRelationshipsForStaticStructurePerspective(workspace.getViews().getConfiguration(), linkedHashSet, writer);
        for (DynamicView dynamicView : workspace.getViews().getDynamicViews()) {
            this.writeDynamicView(dynamicView, writer);
        }
        HashSet<String> deploymentEnvironments = new HashSet<String>();
        for (DeploymentNode deploymentNode : model.getDeploymentNodes()) {
            deploymentEnvironments.add(deploymentNode.getEnvironment());
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(deploymentEnvironments);
        arrayList3.sort(Comparator.comparing(String::toString));
        for (String deploymentEnvironment : arrayList3) {
            this.writeDeploymentEnvironment(workspace, deploymentEnvironment, writer);
        }
        return new IlographWorkspaceExport(writer.toString());
    }

    private void writeDeploymentNode(Workspace workspace, DeploymentNode deploymentNode, IndentingWriter writer) {
        boolean hasChildren;
        this.writeElement(writer, workspace, (Element)deploymentNode);
        boolean bl = hasChildren = !deploymentNode.getChildren().isEmpty() || !deploymentNode.getInfrastructureNodes().isEmpty() || !deploymentNode.getSoftwareSystemInstances().isEmpty() || !deploymentNode.getContainerInstances().isEmpty();
        if (hasChildren) {
            writer.indent();
            writer.writeLine("children:");
            writer.indent();
        }
        ArrayList<DeploymentNode> deploymentNodes = new ArrayList<DeploymentNode>(deploymentNode.getChildren());
        deploymentNodes.sort(Comparator.comparing(ModelItem::getId));
        for (DeploymentNode deploymentNode2 : deploymentNodes) {
            this.writeDeploymentNode(workspace, deploymentNode2, writer);
        }
        ArrayList<InfrastructureNode> infrastructureNodes = new ArrayList<InfrastructureNode>(deploymentNode.getInfrastructureNodes());
        infrastructureNodes.sort(Comparator.comparing(ModelItem::getId));
        for (InfrastructureNode infrastructureNode : infrastructureNodes) {
            this.writeElement(writer, workspace, (Element)infrastructureNode);
        }
        ArrayList<SoftwareSystemInstance> arrayList = new ArrayList<SoftwareSystemInstance>(deploymentNode.getSoftwareSystemInstances());
        arrayList.sort(Comparator.comparing(ModelItem::getId));
        for (SoftwareSystemInstance softwareSystemInstance : arrayList) {
            this.writeElement(writer, workspace, (Element)softwareSystemInstance);
        }
        ArrayList<ContainerInstance> arrayList2 = new ArrayList<ContainerInstance>(deploymentNode.getContainerInstances());
        arrayList2.sort(Comparator.comparing(ModelItem::getId));
        for (ContainerInstance containerInstance : arrayList2) {
            this.writeElement(writer, workspace, (Element)containerInstance);
        }
        writer.outdent();
        writer.outdent();
    }

    private void writeElement(IndentingWriter writer, Workspace workspace, Element element) {
        String description;
        String type;
        String name;
        writer.writeLine(String.format("- id: \"%s\"", element.getId()));
        ElementStyle elementStyle = workspace.getViews().getConfiguration().getStyles().findElementStyle(element);
        if (element instanceof StaticStructureElementInstance) {
            StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
            name = elementInstance.getElement().getName();
            type = this.typeOf(workspace, (Element)elementInstance.getElement(), true);
            description = elementInstance.getElement().getDescription();
        } else {
            name = element.getName();
            type = this.typeOf(workspace, element, true);
            description = element.getDescription();
        }
        writer.indent();
        writer.writeLine(String.format("name: \"%s\"", name));
        writer.writeLine(String.format("subtitle: \"%s\"", type));
        if (!StringUtils.isNullOrEmpty((String)description)) {
            writer.writeLine(String.format("description: \"%s\"", description));
        }
        if (element instanceof DeploymentNode) {
            writer.writeLine(String.format("backgroundColor: \"%s\"", "#ffffff"));
        } else {
            writer.writeLine(String.format("backgroundColor: \"%s\"", elementStyle.getBackground()));
        }
        writer.writeLine(String.format("color: \"%s\"", elementStyle.getColor()));
        String icon = (String)elementStyle.getProperties().get(ILOGRAPH_ICON);
        if (StringUtils.isNullOrEmpty((String)icon)) {
            icon = elementStyle.getIcon();
        }
        if (!StringUtils.isNullOrEmpty((String)icon)) {
            writer.writeLine(String.format("icon: \"%s\"", icon));
        }
        writer.writeLine();
        writer.outdent();
    }

    private void writeRelationshipsForStaticStructurePerspective(Configuration configuration, Collection<Relationship> relationships, IndentingWriter writer) {
        writer.writeLine("perspectives:");
        writer.indent();
        writer.writeLine("- name: Static Structure");
        writer.indent();
        writer.writeLine("relations:");
        writer.indent();
        for (Relationship relationship : relationships) {
            RelationshipStyle relationshipStyle = configuration.getStyles().findRelationshipStyle(relationship);
            writer.writeLine(String.format("- from: \"%s\"", relationship.getSourceId()));
            writer.indent();
            writer.writeLine(String.format("to: \"%s\"", relationship.getDestinationId()));
            if (!StringUtils.isNullOrEmpty((String)relationship.getDescription())) {
                writer.writeLine(String.format("label: \"%s\"", relationship.getDescription()));
            }
            if (!StringUtils.isNullOrEmpty((String)relationship.getTechnology())) {
                writer.writeLine(String.format("description: \"%s\"", relationship.getTechnology()));
            }
            if (!StringUtils.isNullOrEmpty((String)relationshipStyle.getColor())) {
                writer.writeLine(String.format("color: \"%s\"", relationshipStyle.getColor()));
            }
            writer.writeLine();
            writer.outdent();
        }
        writer.outdent();
        writer.outdent();
        writer.outdent();
    }

    private void writeDynamicView(DynamicView dynamicView, IndentingWriter writer) {
        String scope = dynamicView.getName();
        if ((scope = scope.substring("Dynamic View".length())).startsWith(": ")) {
            scope = scope.substring(2);
        }
        writer.indent();
        writer.writeLine("- name: Dynamic: " + scope);
        writer.indent();
        writer.writeLine("sequence:");
        int count = 0;
        for (RelationshipView relationshipView : dynamicView.getRelationships()) {
            Relationship relationship = relationshipView.getRelationship();
            RelationshipStyle relationshipStyle = dynamicView.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
            if (count == 0) {
                writer.indent();
                writer.writeLine(String.format("start: \"%s\"", relationship.getSourceId()));
                writer.writeLine("steps:");
                writer.writeLine(String.format("- to: \"%s\"", relationship.getDestinationId()));
            } else if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                writer.writeLine(String.format("- to: \"%s\"", relationship.getSourceId()));
            } else {
                writer.writeLine(String.format("- to: \"%s\"", relationship.getDestinationId()));
            }
            writer.indent();
            if (!StringUtils.isNullOrEmpty((String)relationshipView.getDescription())) {
                writer.writeLine(String.format("label: \"%s. %s\"", relationshipView.getOrder(), relationshipView.getDescription()));
            } else if (!StringUtils.isNullOrEmpty((String)relationship.getDescription())) {
                writer.writeLine(String.format("label: \"%s. %s\"", relationshipView.getOrder(), relationship.getDescription()));
            }
            if (!StringUtils.isNullOrEmpty((String)relationship.getTechnology())) {
                writer.writeLine(String.format("description: \"%s\"", relationship.getTechnology()));
            }
            if (!StringUtils.isNullOrEmpty((String)relationshipStyle.getColor())) {
                writer.writeLine(String.format("color: \"%s\"", relationshipStyle.getColor()));
            }
            writer.outdent();
            writer.writeLine();
            ++count;
        }
        writer.outdent();
        writer.outdent();
        writer.outdent();
    }

    private void writeDeploymentEnvironment(Workspace workspace, String deploymentEnvironment, IndentingWriter writer) {
        writer.indent();
        writer.writeLine("- name: Deployment - " + deploymentEnvironment);
        writer.indent();
        writer.writeLine("relations:");
        List topLevelDeploymentNodes = workspace.getModel().getDeploymentNodes().stream().filter(dn -> dn.getEnvironment().equals(deploymentEnvironment)).sorted(Comparator.comparing(ModelItem::getId)).collect(Collectors.toList());
        ArrayList<Element> deploymentElementsInEnvironment = new ArrayList<Element>(topLevelDeploymentNodes);
        for (DeploymentNode deploymentNode : topLevelDeploymentNodes) {
            deploymentElementsInEnvironment.addAll(this.findAllChildren(deploymentNode));
        }
        Collection<Relationship> relationships = this.findRelationships(deploymentElementsInEnvironment);
        writer.indent();
        for (Relationship relationship : relationships) {
            RelationshipStyle relationshipStyle = workspace.getViews().getConfiguration().getStyles().findRelationshipStyle(relationship);
            writer.writeLine(String.format("- from: \"%s\"", relationship.getSourceId()));
            writer.indent();
            writer.writeLine(String.format("to: \"%s\"", relationship.getDestinationId()));
            if (!StringUtils.isNullOrEmpty((String)relationship.getDescription())) {
                writer.writeLine(String.format("label: \"%s\"", relationship.getDescription()));
            }
            if (!StringUtils.isNullOrEmpty((String)relationship.getTechnology())) {
                writer.writeLine(String.format("description: \"%s\"", relationship.getTechnology()));
            }
            if (!StringUtils.isNullOrEmpty((String)relationshipStyle.getColor())) {
                writer.writeLine(String.format("color: \"%s\"", relationshipStyle.getColor()));
            }
            writer.outdent();
        }
        writer.outdent();
        writer.outdent();
        writer.outdent();
    }

    private Collection<Element> findAllChildren(DeploymentNode deploymentNode) {
        ArrayList<Element> deploymentElements = new ArrayList<Element>();
        ArrayList<DeploymentNode> deploymentNodes = new ArrayList<DeploymentNode>(deploymentNode.getChildren());
        deploymentNodes.sort(Comparator.comparing(ModelItem::getId));
        for (DeploymentNode child : deploymentNodes) {
            deploymentElements.addAll(this.findAllChildren(child));
        }
        deploymentElements.addAll(deploymentNode.getSoftwareSystemInstances().stream().sorted(Comparator.comparing(ModelItem::getId)).collect(Collectors.toList()));
        deploymentElements.addAll(deploymentNode.getContainerInstances().stream().sorted(Comparator.comparing(ModelItem::getId)).collect(Collectors.toList()));
        deploymentElements.addAll(deploymentNode.getInfrastructureNodes().stream().sorted(Comparator.comparing(ModelItem::getId)).collect(Collectors.toList()));
        return deploymentElements;
    }

    private Collection<Relationship> findRelationships(Collection<Element> elements) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (Element element : elements) {
            ArrayList<Relationship> sortedRelationships = new ArrayList<Relationship>(element.getRelationships());
            sortedRelationships.sort(Comparator.comparing(ModelItem::getId));
            for (Relationship relationship : sortedRelationships) {
                if (!elements.contains(relationship.getSource()) || !elements.contains(relationship.getDestination())) continue;
                relationships.add(relationship);
            }
        }
        return relationships;
    }

    private boolean include(Relationship relationship, Set<Class> elementTypes) {
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        return elementTypes.contains(source.getClass()) && elementTypes.contains(destination.getClass());
    }
}

