/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="nrepl", requiresDependencyResolution=ResolutionScope.TEST)
public class ClojureNReplMojo
extends AbstractClojureCompilerMojo {
    @Parameter
    private String replScript;
    @Parameter(defaultValue="4005", property="clojure.nrepl.port")
    protected int port;
    @Parameter(defaultValue="localhost", property="clojure.nrepl.host")
    protected String nreplHost;

    public void execute() throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        sb.append("(do ");
        sb.append("(clojure.tools.nrepl.server/start-server");
        sb.append(" :bind \"").append(this.nreplHost).append("\"");
        sb.append(" :port ");
        sb.append(Integer.toString(this.port));
        sb.append("))");
        String nreplLoader = sb.toString();
        if (SystemUtils.IS_OS_WINDOWS) {
            nreplLoader = this.windowsEscapeCommandLineArg(nreplLoader);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.replScript != null && new File(this.replScript).exists()) {
            args.add("-i");
            args.add(this.replScript);
        }
        args.add("-e");
        args.add("(require (quote clojure.tools.nrepl.server))");
        args.add("-e");
        args.add(nreplLoader);
        this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE), this.outputDirectory, this.getRunWithClasspathElements(), "clojure.main", args.toArray(new String[args.size()]));
    }

    private String windowsEscapeCommandLineArg(String arg) {
        return "\"" + arg.replace("\"", "\\\"") + "\"";
    }
}

