/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataProviderFrameworkMethod
extends FrameworkMethod {
    final int idx;
    final Object[] parameters;

    public DataProviderFrameworkMethod(Method method, int idx, Object[] parameters) {
        super(method);
        this.idx = idx;
        if (parameters == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        if (parameters.length == 0) {
            throw new IllegalArgumentException("parameter must not be empty");
        }
        this.parameters = Arrays.copyOf(parameters, parameters.length);
    }

    public String getName() {
        return String.format("%s[%d: %s]", super.getName(), this.idx, this.format(this.parameters));
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        return super.invokeExplosively(target, this.parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.idx;
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataProviderFrameworkMethod other = (DataProviderFrameworkMethod)((Object)obj);
        if (this.idx != other.idx) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }

    private <T> String format(T[] parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            T param = parameters[i];
            if (param == null) {
                stringBuilder.append("<null>");
            } else if (param.getClass().isArray()) {
                if (param.getClass().getComponentType().isPrimitive()) {
                    this.appendTo(stringBuilder, param);
                } else {
                    stringBuilder.append('[').append(this.format(this.getArray(param))).append(']');
                }
            } else if (param instanceof String && ((String)param).isEmpty()) {
                stringBuilder.append("<empty string>");
            } else {
                stringBuilder.append(param.toString());
            }
            if (i >= parameters.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private void appendTo(StringBuilder stringBuilder, Object primitiveArray) {
        Class<?> componentType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((boolean[])primitiveArray));
        } else if (Byte.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((byte[])primitiveArray));
        } else if (Character.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((char[])primitiveArray));
        } else if (Short.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((short[])primitiveArray));
        } else if (Integer.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((int[])primitiveArray));
        } else if (Long.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((long[])primitiveArray));
        } else if (Float.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((float[])primitiveArray));
        } else if (Double.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((double[])primitiveArray));
        }
    }

    private <T> T[] getArray(Object array) {
        Object[] result = (Object[])array;
        return result;
    }
}

