/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderFilter;
import com.tngtech.java.junit.dataprovider.DataProviderFrameworkMethod;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.experimental.categories.Categories;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataProviderRunner
extends BlockJUnit4ClassRunner {
    List<FrameworkMethod> computedTestMethods;

    public DataProviderRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Filter useFilter = !(filter instanceof Categories.CategoryFilter) && filter.getClass().getName().startsWith("org.junit") ? new DataProviderFilter(filter) : filter;
        super.filter(useFilter);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.computedTestMethods == null) {
            this.computedTestMethods = this.generateExplodedTestMethodsFor(super.computeTestMethods());
        }
        return this.computedTestMethods;
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validateDataProviderMethods(errors);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        if (errors == null) {
            throw new IllegalArgumentException("errors must not be null");
        }
        for (FrameworkMethod method : this.getTestClassInt().getAnnotatedMethods(Test.class)) {
            if (method.getAnnotation(UseDataProvider.class) == null) {
                method.validatePublicVoidNoArg(false, errors);
                continue;
            }
            method.validatePublicVoid(false, errors);
        }
    }

    void validateDataProviderMethods(List<Throwable> errors) {
        if (errors == null) {
            throw new IllegalArgumentException("errors must not be null");
        }
        for (FrameworkMethod testMethod : this.getTestClassInt().getAnnotatedMethods(UseDataProvider.class)) {
            String dataProviderName = ((UseDataProvider)testMethod.getAnnotation(UseDataProvider.class)).value();
            FrameworkMethod dataProviderMethod = this.getDataProviderMethod(testMethod);
            if (dataProviderMethod == null) {
                errors.add(new Error("No such data provider: " + dataProviderName));
                continue;
            }
            if (this.isValidDataProviderMethod(dataProviderMethod)) continue;
            errors.add(new Error("The data provider method '" + dataProviderName + "' is not valid. " + "A valid method must be public, static, has no arguments parameters and returns 'Object[][]'"));
        }
    }

    List<FrameworkMethod> generateExplodedTestMethodsFor(List<FrameworkMethod> testMethods) {
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        if (testMethods == null) {
            return result;
        }
        for (FrameworkMethod testMethod : testMethods) {
            FrameworkMethod dataProviderMethod = this.getDataProviderMethod(testMethod);
            if (this.isValidDataProviderMethod(dataProviderMethod)) {
                result.addAll(this.explodeTestMethod(testMethod, dataProviderMethod));
                continue;
            }
            result.add(testMethod);
        }
        return result;
    }

    FrameworkMethod getDataProviderMethod(FrameworkMethod testMethod) {
        if (testMethod == null) {
            throw new IllegalArgumentException("testMethod must not be null");
        }
        UseDataProvider useDataProvider = (UseDataProvider)testMethod.getAnnotation(UseDataProvider.class);
        if (useDataProvider == null) {
            return null;
        }
        TestClass dataProviderLocation = this.findDataProviderLocation(useDataProvider);
        for (FrameworkMethod method : dataProviderLocation.getAnnotatedMethods(DataProvider.class)) {
            if (!method.getName().equals(useDataProvider.value())) continue;
            return method;
        }
        return null;
    }

    TestClass findDataProviderLocation(UseDataProvider useDataProvider) {
        if (useDataProvider.location().length == 0) {
            return this.getTestClassInt();
        }
        return new TestClass(useDataProvider.location()[0]);
    }

    boolean isValidDataProviderMethod(FrameworkMethod dataProviderMethod) {
        return dataProviderMethod != null && Modifier.isPublic(dataProviderMethod.getMethod().getModifiers()) && Modifier.isStatic(dataProviderMethod.getMethod().getModifiers()) && dataProviderMethod.getMethod().getParameterTypes().length == 0 && dataProviderMethod.getMethod().getReturnType().equals(Object[][].class);
    }

    List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, FrameworkMethod dataProviderMethod) {
        Object[][] dataProviderMethodResult;
        int idx = 0;
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        try {
            dataProviderMethodResult = (Object[][])dataProviderMethod.invokeExplosively(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new Error(String.format("Exception while exploding test method using data provider '%s': %s", dataProviderMethod.getName(), t.getMessage()), t);
        }
        if (dataProviderMethodResult == null) {
            throw new Error(String.format("Data provider method '%s' must not return 'null'.", dataProviderMethod.getName()));
        }
        if (dataProviderMethodResult.length == 0) {
            throw new Error(String.format("Data provider '%s' must not return an empty object array.", dataProviderMethod.getName()));
        }
        for (Object[] parameters : dataProviderMethodResult) {
            result.add(new DataProviderFrameworkMethod(testMethod.getMethod(), idx++, parameters));
        }
        return result;
    }

    TestClass getTestClassInt() {
        return this.getTestClass();
    }
}

