/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.dictionary;

import java.io.IOException;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.values.ValuesWriter;
import parquet.column.values.dictionary.IntList;
import parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;
import parquet.it.unimi.dsi.fastutil.doubles.Double2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.doubles.Double2IntMap;
import parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import parquet.it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.floats.Float2IntMap;
import parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import parquet.it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.ints.Int2IntMap;
import parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import parquet.it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.longs.Long2IntMap;
import parquet.it.unimi.dsi.fastutil.longs.LongIterator;
import parquet.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.objects.Object2IntMap;
import parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;

public abstract class DictionaryValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(DictionaryValuesWriter.class);
    private static final int MAX_DICTIONARY_ENTRIES = 0x7FFFFFFE;
    protected final int maxDictionaryByteSize;
    protected final ValuesWriter plainValuesWriter;
    protected boolean dictionaryTooBig;
    protected int dictionaryByteSize;
    protected int lastUsedDictionaryByteSize;
    protected int lastUsedDictionarySize;
    protected IntList encodedValues = new IntList();
    protected long rawDataByteSize = 0L;
    protected boolean firstPage = true;

    protected DictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        this.maxDictionaryByteSize = maxDictionaryByteSize;
        this.plainValuesWriter = new PlainValuesWriter(initialSize);
    }

    protected DictionaryValuesWriter(int maxDictionaryByteSize, int initialSize, int fixedLength) {
        this.maxDictionaryByteSize = maxDictionaryByteSize;
        this.plainValuesWriter = new FixedLenByteArrayPlainValuesWriter(fixedLength, initialSize);
    }

    protected void checkAndFallbackIfNeeded() {
        if (this.dictionaryByteSize > this.maxDictionaryByteSize || this.getDictionarySize() > 0x7FFFFFFE) {
            this.fallBackToPlainEncoding();
        }
    }

    private void fallBackToPlainEncoding() {
        if (Log.DEBUG) {
            LOG.debug((Object)("dictionary is now too big, falling back to plain: " + this.dictionaryByteSize + "B and " + this.getDictionarySize() + " entries"));
        }
        this.dictionaryTooBig = true;
        this.fallBackDictionaryEncodedData();
        if (this.lastUsedDictionarySize == 0) {
            this.clearDictionaryContent();
            this.dictionaryByteSize = 0;
            this.encodedValues = new IntList();
        }
    }

    protected abstract void fallBackDictionaryEncodedData();

    @Override
    public long getBufferedSize() {
        return this.rawDataByteSize;
    }

    @Override
    public long getAllocatedSize() {
        return (long)(this.encodedValues.size() * 4 + this.dictionaryByteSize) + this.plainValuesWriter.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        if (!this.dictionaryTooBig && this.getDictionarySize() > 0) {
            int maxDicId = this.getDictionarySize() - 1;
            if (Log.DEBUG) {
                LOG.debug((Object)("max dic id " + maxDicId));
            }
            int bitWidth = BytesUtils.getWidthFromMaxInt((int)maxDicId);
            RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(bitWidth, 65536);
            IntList.IntIterator iterator = this.encodedValues.iterator();
            try {
                while (iterator.hasNext()) {
                    encoder.writeInt(iterator.next());
                }
                byte[] bytesHeader = new byte[]{(byte)bitWidth};
                BytesInput rleEncodedBytes = encoder.toBytes();
                if (Log.DEBUG) {
                    LOG.debug((Object)("rle encoded bytes " + rleEncodedBytes.size()));
                }
                BytesInput bytes = BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((byte[])bytesHeader), rleEncodedBytes});
                if (!this.firstPage || bytes.size() + (long)this.dictionaryByteSize <= this.rawDataByteSize) {
                    this.lastUsedDictionarySize = this.getDictionarySize();
                    this.lastUsedDictionaryByteSize = this.dictionaryByteSize;
                    return bytes;
                }
                this.fallBackToPlainEncoding();
            }
            catch (IOException e) {
                throw new ParquetEncodingException("could not encode the values", e);
            }
        }
        return this.plainValuesWriter.getBytes();
    }

    @Override
    public Encoding getEncoding() {
        this.firstPage = false;
        if (!this.dictionaryTooBig && this.getDictionarySize() > 0) {
            return Encoding.PLAIN_DICTIONARY;
        }
        return this.plainValuesWriter.getEncoding();
    }

    @Override
    public void reset() {
        this.encodedValues = new IntList();
        this.plainValuesWriter.reset();
        this.rawDataByteSize = 0L;
    }

    @Override
    public void resetDictionary() {
        this.lastUsedDictionaryByteSize = 0;
        this.lastUsedDictionarySize = 0;
        this.dictionaryTooBig = false;
        this.clearDictionaryContent();
    }

    protected abstract void clearDictionaryContent();

    protected abstract int getDictionarySize();

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s DictionaryValuesWriter{\n%s\n%s\n%s\n%s}\n", prefix, this.plainValuesWriter.memUsageString(prefix + " plain:"), prefix + " dict:" + this.dictionaryByteSize, prefix + " values:" + String.valueOf(this.encodedValues.size() * 4), prefix);
    }

    public static class PlainFloatDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Float2IntMap floatDictionaryContent = new Float2IntLinkedOpenHashMap();

        public PlainFloatDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.floatDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeFloat(float v) {
            if (!this.dictionaryTooBig) {
                int id = this.floatDictionaryContent.get(v);
                if (id == -1) {
                    id = this.floatDictionaryContent.size();
                    this.floatDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 4;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            } else {
                this.plainValuesWriter.writeFloat(v);
            }
            this.rawDataByteSize += 4L;
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                FloatIterator floatIterator = this.floatDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeFloat(floatIterator.nextFloat());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.floatDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.floatDictionaryContent.clear();
        }

        @Override
        protected void fallBackDictionaryEncodedData() {
            float[] reverseDictionary = new float[this.getDictionarySize()];
            for (Float2IntMap.Entry entry : this.floatDictionaryContent.float2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getFloatKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                this.plainValuesWriter.writeFloat(reverseDictionary[id]);
            }
        }
    }

    public static class PlainIntegerDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Int2IntMap intDictionaryContent = new Int2IntLinkedOpenHashMap();

        public PlainIntegerDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.intDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeInteger(int v) {
            if (!this.dictionaryTooBig) {
                int id = this.intDictionaryContent.get(v);
                if (id == -1) {
                    id = this.intDictionaryContent.size();
                    this.intDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 4;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            } else {
                this.plainValuesWriter.writeInteger(v);
            }
            this.rawDataByteSize += 4L;
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                IntIterator intIterator = this.intDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeInteger(intIterator.nextInt());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.intDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.intDictionaryContent.clear();
        }

        @Override
        protected void fallBackDictionaryEncodedData() {
            int[] reverseDictionary = new int[this.getDictionarySize()];
            for (Int2IntMap.Entry entry : this.intDictionaryContent.int2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getIntKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                this.plainValuesWriter.writeInteger(reverseDictionary[id]);
            }
        }
    }

    public static class PlainDoubleDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Double2IntMap doubleDictionaryContent = new Double2IntLinkedOpenHashMap();

        public PlainDoubleDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.doubleDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeDouble(double v) {
            if (!this.dictionaryTooBig) {
                int id = this.doubleDictionaryContent.get(v);
                if (id == -1) {
                    id = this.doubleDictionaryContent.size();
                    this.doubleDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 8;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            } else {
                this.plainValuesWriter.writeDouble(v);
            }
            this.rawDataByteSize += 8L;
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                DoubleIterator doubleIterator = this.doubleDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeDouble(doubleIterator.nextDouble());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.doubleDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.doubleDictionaryContent.clear();
        }

        @Override
        protected void fallBackDictionaryEncodedData() {
            double[] reverseDictionary = new double[this.getDictionarySize()];
            for (Double2IntMap.Entry entry : this.doubleDictionaryContent.double2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getDoubleKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                this.plainValuesWriter.writeDouble(reverseDictionary[id]);
            }
        }
    }

    public static class PlainLongDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Long2IntMap longDictionaryContent = new Long2IntLinkedOpenHashMap();

        public PlainLongDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.longDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeLong(long v) {
            if (!this.dictionaryTooBig) {
                int id = this.longDictionaryContent.get(v);
                if (id == -1) {
                    id = this.longDictionaryContent.size();
                    this.longDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 8;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            } else {
                this.plainValuesWriter.writeLong(v);
            }
            this.rawDataByteSize += 8L;
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                LongIterator longIterator = this.longDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeLong(longIterator.nextLong());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.longDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.longDictionaryContent.clear();
        }

        @Override
        protected void fallBackDictionaryEncodedData() {
            long[] reverseDictionary = new long[this.getDictionarySize()];
            for (Long2IntMap.Entry entry : this.longDictionaryContent.long2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = entry.getLongKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int id = iterator.next();
                this.plainValuesWriter.writeLong(reverseDictionary[id]);
            }
        }
    }

    public static class PlainFixedLenArrayDictionaryValuesWriter
    extends PlainBinaryDictionaryValuesWriter {
        private final int length;

        public PlainFixedLenArrayDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize, int length) {
            super(maxDictionaryByteSize, initialSize, length);
            this.length = length;
        }

        @Override
        public void writeBytes(Binary value) {
            if (!this.dictionaryTooBig) {
                int id = this.binaryDictionaryContent.getInt(value);
                if (id == -1) {
                    id = this.binaryDictionaryContent.size();
                    this.binaryDictionaryContent.put(value, id);
                    this.dictionaryByteSize += this.length;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            } else {
                this.plainValuesWriter.writeBytes(value);
            }
            this.rawDataByteSize += (long)this.length;
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                FixedLenByteArrayPlainValuesWriter dictionaryEncoder = new FixedLenByteArrayPlainValuesWriter(12, this.lastUsedDictionaryByteSize);
                ObjectIterator binaryIterator = this.binaryDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    Binary entry = (Binary)binaryIterator.next();
                    dictionaryEncoder.writeBytes(entry);
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }
    }

    public static class PlainBinaryDictionaryValuesWriter
    extends DictionaryValuesWriter {
        protected Object2IntMap<Binary> binaryDictionaryContent = new Object2IntLinkedOpenHashMap<Binary>();

        public PlainBinaryDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.binaryDictionaryContent.defaultReturnValue(-1);
        }

        protected PlainBinaryDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize, int length) {
            super(maxDictionaryByteSize, initialSize, length);
            this.binaryDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeBytes(Binary v) {
            if (!this.dictionaryTooBig) {
                int id = this.binaryDictionaryContent.getInt(v);
                if (id == -1) {
                    id = this.binaryDictionaryContent.size();
                    this.binaryDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 4 + v.length();
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            } else {
                this.plainValuesWriter.writeBytes(v);
            }
            this.rawDataByteSize += (long)(v.length() + 4);
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                ObjectIterator<Binary> binaryIterator = this.binaryDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    Binary entry = (Binary)binaryIterator.next();
                    dictionaryEncoder.writeBytes(entry);
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.binaryDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.binaryDictionaryContent.clear();
        }

        @Override
        protected void fallBackDictionaryEncodedData() {
            Binary[] reverseDictionary = new Binary[this.getDictionarySize()];
            for (Object2IntMap.Entry entry : this.binaryDictionaryContent.object2IntEntrySet()) {
                reverseDictionary[entry.getIntValue()] = (Binary)entry.getKey();
            }
            IntList.IntIterator iterator = this.encodedValues.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                this.plainValuesWriter.writeBytes(reverseDictionary[n]);
            }
        }
    }
}

