/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0013\t11*\u00197nC:T!a\u0001\u0003\u0002\u0007)4XN\u0003\u0002\u0006\r\u00059Ao^5ui\u0016\u0014(\"A\u0004\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\t\u0011M\u0001!\u0011!Q\u0001\nQ\t\u0011A\u0014\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0004\u0013:$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)1C\u0007a\u0001)!1\u0011\u0005\u0001Q\u0001\n\t\nA!\u001c2vMB\u0019QcI\u0013\n\u0005\u00112\"!B!se\u0006L\bCA\u000b'\u0013\t9cC\u0001\u0004E_V\u0014G.\u001a\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u0012\u0002\t\u0015\u0014WO\u001a\u0005\nW\u0001\u0001\r\u0011!Q!\n\u0015\n1!Z:u\u0011\u0019i\u0003\u0001)Q\u0005]\u0005\ta\u000e\u0005\u0002\u0016_%\u0011\u0001G\u0006\u0002\u0005\u0019>tw\r\u0003\u00043\u0001\u0001\u0006K!J\u0001\u0007o\u0016Lw\r\u001b;\t\u000bQ\u0002A\u0011A\u001b\u0002\u000f5,\u0017m];sKR\u0019a'O\u001e\u0011\u0005U9\u0014B\u0001\u001d\u0017\u0005\u0011)f.\u001b;\t\u000bi\u001a\u0004\u0019A\u0013\u0002\u00035DQ\u0001P\u001aA\u0002\u0015\n\u0011!\u001a\u0005\u0007}\u0001\u0001K\u0011B \u0002\t54\u0018M]\u000b\u0002K!1\u0011\t\u0001Q\u0005\n}\nA!\u001a<be\")1\t\u0001C\u0001\u007f\u0005AQm\u001d;j[\u0006$X\r\u0003\u0004F\u0001\u0001&IAR\u0001\tm\u0006\u0014\u0018.\u00198dKR\u0011Qe\u0012\u0005\u0006\u0011\u0012\u0003\rAI\u0001\bg\u0006l\u0007\u000f\\3t\u0011\u0015Q\u0005\u0001\"\u0011L\u0003!!xn\u0015;sS:<G#\u0001'\u0011\u00055\u0003fBA\u000bO\u0013\tye#\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(\u0017\u0001")
public class Kalman {
    private final int N;
    private final double[] mbuf;
    private final double[] ebuf;
    private double est;
    private long n;
    private double weight;

    public void measure(double m, double e) {
        double ev;
        int i = (int)(this.n % (long)this.N);
        this.mbuf[i] = m;
        this.ebuf[i] = e;
        if (this.n == 0L) {
            this.est = m;
        }
        this.est += this.weight * (m - this.est);
        double mv = this.mvar();
        this.weight = mv + (ev = this.evar()) == 0.0 ? 1.0 : mv / (mv + ev);
        ++this.n;
    }

    private double mvar() {
        return this.variance(this.n < (long)this.N ? (double[])Predef$.MODULE$.doubleArrayOps(this.mbuf).take((int)this.n) : this.mbuf);
    }

    private double evar() {
        return this.variance(this.n < (long)this.N ? (double[])Predef$.MODULE$.doubleArrayOps(this.ebuf).take((int)this.n) : this.ebuf);
    }

    public double estimate() {
        return this.est;
    }

    private double variance(double[] samples) {
        if (Predef$.MODULE$.doubleArrayOps(samples).size() == 1) {
            return 0.0;
        }
        double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(samples).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double mean = sum / (double)Predef$.MODULE$.doubleArrayOps(samples).size();
        double diff = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(samples).map((Function1)new Serializable(this, mean){
            public static final long serialVersionUID = 0L;
            private final double mean$1;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double v1) {
                return (v1 - this.mean$1) * (v1 - this.mean$1);
            }
            {
                this.mean$1 = mean$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return diff / (double)(Predef$.MODULE$.doubleArrayOps(samples).size() - 1);
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("Kalman<estimate=%f, weight=%f, mvar=%f, evar=%f>")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.estimate()), BoxesRunTime.boxToDouble((double)this.weight), BoxesRunTime.boxToDouble((double)this.mvar()), BoxesRunTime.boxToDouble((double)this.evar())}));
    }

    public Kalman(int N) {
        this.N = N;
        this.mbuf = new double[N];
        this.ebuf = new double[N];
        this.n = 0L;
        this.weight = 0.9;
    }
}

