/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SCRAMBindRequest;
import com.unboundid.ldap.sdk.SCRAMClientFinalMessage;
import com.unboundid.ldap.sdk.SCRAMClientFirstMessage;
import com.unboundid.util.Base64;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SCRAMServerFinalMessage
implements Serializable {
    private static final byte[] SERVER_KEY_INPUT_BYTES = StaticUtils.getBytes("Server Key");
    private static final long serialVersionUID = -8799438618265483051L;
    private final BindResult bindResult;
    private final SCRAMBindRequest bindRequest;
    private final SCRAMClientFirstMessage clientFirstMessage;
    private final SCRAMClientFinalMessage clientFinalMessage;
    private final String serverFinalMessage;
    private final String serverSignatureBase64;

    SCRAMServerFinalMessage(SCRAMBindRequest bindRequest, SCRAMClientFirstMessage clientFirstMessage, SCRAMClientFinalMessage clientFinalMessage, BindResult bindResult) throws LDAPBindException {
        this.bindRequest = bindRequest;
        this.clientFirstMessage = clientFirstMessage;
        this.clientFinalMessage = clientFinalMessage;
        this.bindResult = bindResult;
        ASN1OctetString serverSASLCredentials = bindResult.getServerSASLCredentials();
        if (serverSASLCredentials == null) {
            if (bindResult.getResultCode() == ResultCode.SUCCESS) {
                throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FINAL_MESSAGE_NO_CREDS.get(bindRequest.getSASLMechanismName()), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
            }
            throw new LDAPBindException(bindResult);
        }
        this.serverFinalMessage = serverSASLCredentials.stringValue();
        if (bindResult.getResultCode() != ResultCode.SUCCESS) {
            if (this.serverFinalMessage.startsWith("e=")) {
                int commaPos = this.serverFinalMessage.indexOf(44);
                String errorValue = commaPos > 0 ? this.serverFinalMessage.substring(2, commaPos) : this.serverFinalMessage.substring(2);
                String diagnosticMessage = bindResult.getDiagnosticMessage();
                if (diagnosticMessage == null) {
                    throw new LDAPBindException(new BindResult(bindResult.getMessageID(), bindResult.getResultCode(), LDAPMessages.ERR_SCRAM_SERVER_FINAL_MESSAGE_ERROR_VALUE_NO_DIAG.get(bindRequest.getSASLMechanismName(), errorValue), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
                }
                throw new LDAPBindException(new BindResult(bindResult.getMessageID(), bindResult.getResultCode(), LDAPMessages.ERR_SCRAM_SERVER_FINAL_MESSAGE_ERROR_VALUE_WITH_DIAG.get(bindRequest.getSASLMechanismName(), errorValue, diagnosticMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
            }
            throw new LDAPBindException(bindResult);
        }
        if (!this.serverFinalMessage.startsWith("v=")) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FINAL_MESSAGE_NO_VERIFIER.get(bindRequest.getSASLMechanismName(), this.serverFinalMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        int commaPos = this.serverFinalMessage.indexOf(44);
        this.serverSignatureBase64 = commaPos > 0 ? this.serverFinalMessage.substring(2, commaPos) : this.serverFinalMessage.substring(2);
        byte[] serverKey = bindRequest.mac(clientFinalMessage.getSaltedPassword(), SERVER_KEY_INPUT_BYTES);
        byte[] serverSignature = bindRequest.mac(serverKey, clientFinalMessage.getAuthMessageBytes());
        String expectedServerSignatureBase64 = Base64.encode(serverSignature);
        if (!expectedServerSignatureBase64.equals(this.serverSignatureBase64)) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FINAL_MESSAGE_INCORRECT_VERIFIER.get(bindRequest.getSASLMechanismName(), this.serverFinalMessage, this.serverSignatureBase64, expectedServerSignatureBase64), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
    }

    SCRAMBindRequest getBindRequest() {
        return this.bindRequest;
    }

    SCRAMClientFirstMessage getClientFirstMessage() {
        return this.clientFirstMessage;
    }

    SCRAMClientFinalMessage getClientFinalMessage() {
        return this.clientFinalMessage;
    }

    String getServerSignatureBase64() {
        return this.serverSignatureBase64;
    }

    String getServerFinalMessage() {
        return this.serverFinalMessage;
    }

    public String toString() {
        return this.serverFinalMessage;
    }
}

