/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd;

import java.util.Optional;
import java.util.stream.Stream;

public enum EffectAllowed {
    NONE("none"),
    COPY("copy"),
    MOVE("move"),
    LINK("link"),
    COPY_MOVE("copymove"),
    COPY_LINK("copylink"),
    LINK_MOVE("linkmove"),
    ALL("all"),
    UNINITIALIZED("uninitialized");

    private final String clientPropertyValue;

    private EffectAllowed(String value) {
        this.clientPropertyValue = value;
    }

    public String getClientPropertyValue() {
        return this.clientPropertyValue;
    }

    static EffectAllowed fromString(String string) {
        Optional<EffectAllowed> effectAllowed = Stream.of(EffectAllowed.values()).filter(ea -> ea.getClientPropertyValue().equalsIgnoreCase(string.replace("_", ""))).findFirst();
        return effectAllowed.orElseThrow(() -> new IllegalArgumentException("Could not parse effect allowed from string " + string));
    }
}

