/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;

@Deprecated
public class ContainerOrderedWrapper
implements Container.Ordered,
Container.ItemSetChangeNotifier,
Container.PropertySetChangeNotifier {
    private final Container container;
    private Hashtable<Object, Object> next;
    private Hashtable<Object, Object> prev;
    private Object first;
    private Object last;
    private boolean ordered = false;
    private int lastKnownSize = -1;

    public ContainerOrderedWrapper(Container toBeWrapped) {
        this.container = toBeWrapped;
        this.ordered = this.container instanceof Container.Ordered;
        if (this.container == null) {
            throw new NullPointerException("Null can not be wrapped");
        }
        this.updateOrderWrapper();
    }

    private void removeFromOrderWrapper(Object id) {
        if (id != null) {
            Object pid = this.prev.get(id);
            Object nid = this.next.get(id);
            if (this.first.equals(id)) {
                this.first = nid;
            }
            if (this.last.equals(id)) {
                this.last = pid;
            }
            if (nid != null) {
                if (pid == null) {
                    this.prev.remove(nid);
                } else {
                    this.prev.put(nid, pid);
                }
            }
            if (pid != null) {
                if (nid == null) {
                    this.next.remove(pid);
                } else {
                    this.next.put(pid, nid);
                }
            }
            this.next.remove(id);
            this.prev.remove(id);
        }
    }

    private void addToOrderWrapper(Object id) {
        if (this.last != null) {
            this.next.put(this.last, id);
            this.prev.put(id, this.last);
            this.last = id;
        } else {
            this.first = this.last = id;
        }
    }

    private void addToOrderWrapper(Object id, Object previousItemId) {
        if (this.last == previousItemId || this.last == null) {
            this.addToOrderWrapper(id);
        } else if (previousItemId == null) {
            this.next.put(id, this.first);
            this.prev.put(this.first, id);
            this.first = id;
        } else {
            this.prev.put(id, previousItemId);
            this.next.put(id, this.next.get(previousItemId));
            this.prev.put(this.next.get(previousItemId), id);
            this.next.put(previousItemId, id);
        }
    }

    public void updateOrderWrapper() {
        if (!this.ordered) {
            Collection<?> ids = this.container.getItemIds();
            if (this.next == null || this.first == null || this.last == null || this.prev == null) {
                this.first = null;
                this.last = null;
                this.next = new Hashtable();
                this.prev = new Hashtable();
            }
            LinkedList<Object> l = new LinkedList<Object>(this.next.keySet());
            for (Object e : l) {
                if (this.container.containsId(e)) continue;
                this.removeFromOrderWrapper(e);
            }
            for (Object object : ids) {
                if (this.next.containsKey(object) || this.last == object) continue;
                this.addToOrderWrapper(object);
            }
        }
    }

    @Override
    public Object firstItemId() {
        if (this.ordered) {
            return ((Container.Ordered)this.container).firstItemId();
        }
        return this.first;
    }

    @Override
    public boolean isFirstId(Object itemId) {
        if (this.ordered) {
            return ((Container.Ordered)this.container).isFirstId(itemId);
        }
        return this.first != null && this.first.equals(itemId);
    }

    @Override
    public boolean isLastId(Object itemId) {
        if (this.ordered) {
            return ((Container.Ordered)this.container).isLastId(itemId);
        }
        return this.last != null && this.last.equals(itemId);
    }

    @Override
    public Object lastItemId() {
        if (this.ordered) {
            return ((Container.Ordered)this.container).lastItemId();
        }
        return this.last;
    }

    @Override
    public Object nextItemId(Object itemId) {
        if (this.ordered) {
            return ((Container.Ordered)this.container).nextItemId(itemId);
        }
        if (itemId == null) {
            return null;
        }
        return this.next.get(itemId);
    }

    @Override
    public Object prevItemId(Object itemId) {
        if (this.ordered) {
            return ((Container.Ordered)this.container).prevItemId(itemId);
        }
        if (itemId == null) {
            return null;
        }
        return this.prev.get(itemId);
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        return this.container.addContainerProperty(propertyId, type, defaultValue);
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        Object id = this.container.addItem();
        if (!this.ordered && id != null) {
            this.addToOrderWrapper(id);
        }
        return id;
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        Item item = this.container.addItem(itemId);
        if (!this.ordered && item != null) {
            this.addToOrderWrapper(itemId);
        }
        return item;
    }

    @Override
    public boolean removeAllItems() throws UnsupportedOperationException {
        boolean success = this.container.removeAllItems();
        if (!this.ordered && success) {
            this.last = null;
            this.first = null;
            this.next.clear();
            this.prev.clear();
        }
        return success;
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        boolean success = this.container.removeItem(itemId);
        if (!this.ordered && success) {
            this.removeFromOrderWrapper(itemId);
        }
        return success;
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        return this.container.removeContainerProperty(propertyId);
    }

    @Override
    public boolean containsId(Object itemId) {
        return this.container.containsId(itemId);
    }

    @Override
    public Item getItem(Object itemId) {
        return this.container.getItem(itemId);
    }

    @Override
    public Collection<?> getItemIds() {
        if (this.ordered) {
            return ((Container.Ordered)this.container).getItemIds();
        }
        if (this.first == null) {
            return new ArrayList();
        }
        ArrayList<Object> itemIds = new ArrayList<Object>();
        itemIds.add(this.first);
        Object current = this.first;
        while (this.next.containsKey(current)) {
            current = this.next.get(current);
            itemIds.add(current);
        }
        return itemIds;
    }

    @Override
    public Property getContainerProperty(Object itemId, Object propertyId) {
        return this.container.getContainerProperty(itemId, propertyId);
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return this.container.getContainerPropertyIds();
    }

    @Override
    public Class<?> getType(Object propertyId) {
        return this.container.getType(propertyId);
    }

    @Override
    public int size() {
        int newSize = this.container.size();
        assert (newSize >= 0);
        if (this.lastKnownSize != -1 && newSize != this.lastKnownSize && !(this.container instanceof Container.ItemSetChangeNotifier)) {
            this.updateOrderWrapper();
        }
        this.lastKnownSize = newSize;
        return newSize;
    }

    @Override
    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.container)).addItemSetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void addListener(Container.ItemSetChangeListener listener) {
        this.addItemSetChangeListener(listener);
    }

    @Override
    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        if (this.container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.container)).removeItemSetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.ItemSetChangeListener listener) {
        this.removeItemSetChangeListener(listener);
    }

    @Override
    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.container instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.container)).addPropertySetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void addListener(Container.PropertySetChangeListener listener) {
        this.addPropertySetChangeListener(listener);
    }

    @Override
    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        if (this.container instanceof Container.PropertySetChangeNotifier) {
            ((Container.PropertySetChangeNotifier)((Object)this.container)).removePropertySetChangeListener(new PiggybackListener(listener));
        }
    }

    @Override
    @Deprecated
    public void removeListener(Container.PropertySetChangeListener listener) {
        this.removePropertySetChangeListener(listener);
    }

    @Override
    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        if (previousItemId != null && !this.containsId(previousItemId)) {
            return null;
        }
        Item item = this.container.addItem(newItemId);
        if (!this.ordered && item != null) {
            this.addToOrderWrapper(newItemId, previousItemId);
        }
        return item;
    }

    @Override
    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        if (previousItemId != null && !this.containsId(previousItemId)) {
            return null;
        }
        Object id = this.container.addItem();
        if (!this.ordered && id != null) {
            this.addToOrderWrapper(id, previousItemId);
        }
        return id;
    }

    private class PiggybackListener
    implements Container.PropertySetChangeListener,
    Container.ItemSetChangeListener {
        Object listener;

        public PiggybackListener(Object realListener) {
            this.listener = realListener;
        }

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
            ContainerOrderedWrapper.this.updateOrderWrapper();
            ((Container.ItemSetChangeListener)this.listener).containerItemSetChange(event);
        }

        @Override
        public void containerPropertySetChange(Container.PropertySetChangeEvent event) {
            ContainerOrderedWrapper.this.updateOrderWrapper();
            ((Container.PropertySetChangeListener)this.listener).containerPropertySetChange(event);
        }

        public boolean equals(Object obj) {
            return obj == this.listener || obj != null && obj.equals(this.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

