/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ContextBuffer;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.IByteBuffer;
import com.ximpleware.IndexHandler;
import com.ximpleware.IndexWriteException;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import java.io.IOException;
import java.io.OutputStream;

public class VTDNav_L5
extends VTDNav {
    protected int l4index;
    protected int l5index;
    protected int l4upper;
    protected int l4lower;
    protected int l5upper;
    protected int l5lower;
    protected FastLongBuffer l3Buffer;
    protected FastLongBuffer l4Buffer;
    protected FastIntBuffer l5Buffer;

    protected VTDNav_L5(int n, int n2, boolean bl, int n3, IByteBuffer iByteBuffer, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastLongBuffer fastLongBuffer4, FastLongBuffer fastLongBuffer5, FastIntBuffer fastIntBuffer, int n4, int n5) {
        if (fastLongBuffer2 == null || fastLongBuffer3 == null || fastLongBuffer4 == null || fastLongBuffer == null || iByteBuffer == null || n3 < 0 || n < 0 || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.count = 0;
        this.l1Buffer = fastLongBuffer2;
        this.l2Buffer = fastLongBuffer3;
        this.l3Buffer = fastLongBuffer4;
        this.l4Buffer = fastLongBuffer5;
        this.l5Buffer = fastIntBuffer;
        this.vtdBuffer = fastLongBuffer;
        this.XMLDoc = iByteBuffer;
        this.encoding = n2;
        this.rootIndex = n;
        this.nestingLevel = n3 + 1;
        this.ns = bl;
        this.MASK_TOKEN_OFFSET = !this.ns ? Integer.MAX_VALUE : 0x3FFFFFFFL;
        this.atTerminal = false;
        this.context = new int[this.nestingLevel];
        this.context[0] = 0;
        for (int i = 1; i < this.nestingLevel; ++i) {
            this.context[i] = -1;
        }
        this.contextStack = new ContextBuffer(10, this.nestingLevel + 15);
        this.contextStack2 = new ContextBuffer(10, this.nestingLevel + 15);
        this.stackTemp = new int[this.nestingLevel + 15];
        this.l5index = -1;
        this.l4index = -1;
        this.l3index = -1;
        this.l2index = -1;
        this.l1index = -1;
        this.l5lower = -1;
        this.l4lower = -1;
        this.l3lower = -1;
        this.l2lower = -1;
        this.l5upper = -1;
        this.l4upper = -1;
        this.l3upper = -1;
        this.l2upper = -1;
        this.docOffset = n4;
        this.docLen = n5;
        this.vtdSize = fastLongBuffer.size;
        this.name = null;
        this.nameIndex = -1;
        this.localName = null;
        this.localNameIndex = -1;
        this.fib = new FastIntBuffer(5);
        this.shallowDepth = false;
        this.maxLCDepthPlusOne = (short)6;
    }

    @Override
    public VTDNav cloneNav() {
        VTDNav_L5 vTDNav_L5 = new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, this.docOffset, this.docLen);
        vTDNav_L5.atTerminal = this.atTerminal;
        vTDNav_L5.LN = this.LN;
        if (this.context[0] != -1) {
            System.arraycopy(this.context, 0, vTDNav_L5.context, 0, this.context[0] + 1);
        } else {
            vTDNav_L5.context[0] = -1;
        }
        vTDNav_L5.l1index = this.l1index;
        if (this.getCurrentDepth() > 1) {
            vTDNav_L5.l2index = this.l2index;
            vTDNav_L5.l2upper = this.l2upper;
            vTDNav_L5.l2lower = this.l2lower;
        }
        if (this.getCurrentDepth() > 2) {
            vTDNav_L5.l3lower = this.l3lower;
            vTDNav_L5.l3index = this.l3index;
            vTDNav_L5.l3upper = this.l3upper;
        }
        if (this.getCurrentDepth() > 3) {
            vTDNav_L5.l4lower = this.l4lower;
            vTDNav_L5.l4index = this.l4index;
            vTDNav_L5.l4upper = this.l4upper;
        }
        if (this.getCurrentDepth() > 4) {
            vTDNav_L5.l5lower = this.l5lower;
            vTDNav_L5.l5index = this.l5index;
            vTDNav_L5.l5upper = this.l5upper;
        }
        return vTDNav_L5;
    }

    @Override
    public final VTDNav duplicateNav() {
        return new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.nestingLevel - 1, this.XMLDoc, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, this.docOffset, this.docLen);
    }

    @Override
    protected final boolean iterateNS(int n, String string, String string2) throws NavException {
        if (!this.ns) {
            return false;
        }
        int n2 = this.getCurrentIndex() + 1;
        while (n2 < this.vtdSize) {
            int n3 = this.getTokenType(n2);
            if (n3 == 2 || n3 == 3) {
                n2 += 2;
                continue;
            }
            if (this.isElementOrDocument(n2)) {
                int n4 = this.getTokenDepth(n2);
                if (n4 > n) {
                    this.context[0] = n4;
                    if (n4 > 0) {
                        this.context[n4] = n2;
                    }
                    if (this.matchElementNS(string, string2)) {
                        if (n < 6) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void resolveLC() {
        if (this.context[0] <= 0) {
            return;
        }
        this.resolveLC_l1();
        if (this.context[0] == 1) {
            return;
        }
        this.resolveLC_l2();
        if (this.context[0] == 2) {
            return;
        }
        this.resolveLC_l3();
        if (this.context[0] == 3) {
            return;
        }
        this.resolveLC_l4();
        if (this.context[0] == 4) {
            return;
        }
        this.resolveLC_l5();
    }

    @Override
    protected void resolveLC_l3() {
        block16: {
            int n;
            int n2 = this.l2Buffer.lower32At(this.l2index);
            if (this.l3lower != n2) {
                this.l3index = this.l3lower = n2;
                this.l3upper = this.l3Buffer.size - 1;
                for (n = this.l2index + 1; n < this.l2Buffer.size; ++n) {
                    n2 = this.l2Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l3upper = n2 - 1;
                    break;
                }
            }
            if (this.l3index >= 0 && this.l3index < this.l3Buffer.size && this.context[3] == this.l3Buffer.upper32At(this.l3index)) break block16;
            if (this.l3index >= this.l3Buffer.size || this.l3index < 0) {
                this.l3index = this.l3lower;
            }
            if (this.l3index + 1 < this.l3Buffer.size && this.context[3] == this.l3Buffer.upper32At(this.l3index + 1)) {
                ++this.l3index;
            } else if (this.l3upper - this.l3lower >= 16) {
                n = this.l3lower + (int)((float)(this.l3upper - this.l3lower) * ((float)this.context[3] - (float)this.l3Buffer.upper32At(this.l3lower)) / (float)(this.l3Buffer.upper32At(this.l3upper) - this.l3Buffer.upper32At(this.l3lower)));
                if (this.l3Buffer.upper32At(n) > this.context[3]) {
                    while (this.context[3] != this.l3Buffer.upper32At(n)) {
                        --n;
                    }
                } else if (this.l3Buffer.upper32At(n) < this.context[3]) {
                    while (this.context[3] != this.l3Buffer.upper32At(n)) {
                        ++n;
                    }
                }
                this.l3index = n;
            } else if (this.context[3] < this.l3Buffer.upper32At(this.l3index)) {
                while (this.context[3] != this.l3Buffer.upper32At(this.l3index)) {
                    --this.l3index;
                }
            } else {
                while (this.context[3] != this.l3Buffer.upper32At(this.l3index)) {
                    ++this.l3index;
                }
            }
        }
    }

    private void resolveLC_l4() {
        block16: {
            int n;
            int n2 = this.l3Buffer.lower32At(this.l3index);
            if (this.l4lower != n2) {
                this.l4index = this.l4lower = n2;
                this.l4upper = this.l4Buffer.size - 1;
                for (n = this.l3index + 1; n < this.l3Buffer.size; ++n) {
                    n2 = this.l3Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l4upper = n2 - 1;
                    break;
                }
            }
            if (this.l4index >= 0 && this.l4index < this.l4Buffer.size && this.context[4] == this.l4Buffer.upper32At(this.l4index)) break block16;
            if (this.l4index >= this.l4Buffer.size || this.l4index < 0) {
                this.l4index = this.l4lower;
            }
            if (this.l4index + 1 < this.l4Buffer.size && this.context[4] == this.l4Buffer.upper32At(this.l4index + 1)) {
                ++this.l4index;
            } else if (this.l4upper - this.l4lower >= 16) {
                n = this.l4lower + (int)((float)(this.l4upper - this.l4lower) * ((float)this.context[4] - (float)this.l4Buffer.upper32At(this.l4lower)) / (float)(this.l4Buffer.upper32At(this.l4upper) - this.l4Buffer.upper32At(this.l4lower)));
                if (this.l4Buffer.upper32At(n) > this.context[4]) {
                    while (this.context[4] != this.l4Buffer.upper32At(n)) {
                        --n;
                    }
                } else if (this.l4Buffer.upper32At(n) < this.context[4]) {
                    while (this.context[4] != this.l4Buffer.upper32At(n)) {
                        ++n;
                    }
                }
                this.l4index = n;
            } else if (this.context[4] < this.l4Buffer.upper32At(this.l4index)) {
                while (this.context[4] != this.l4Buffer.upper32At(this.l4index)) {
                    --this.l4index;
                }
            } else {
                while (this.context[4] != this.l4Buffer.upper32At(this.l4index)) {
                    ++this.l4index;
                }
            }
        }
    }

    private void resolveLC_l5() {
        block16: {
            int n;
            int n2 = this.l4Buffer.lower32At(this.l4index);
            if (this.l5lower != n2) {
                this.l5index = this.l5lower = n2;
                this.l5upper = this.l5Buffer.size - 1;
                for (n = this.l4index + 1; n < this.l4Buffer.size; ++n) {
                    n2 = this.l4Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l5upper = n2 - 1;
                    break;
                }
            }
            if (this.l5index >= 0 && this.l5index < this.l5Buffer.size && this.context[5] == this.l5Buffer.intAt(this.l5index)) break block16;
            if (this.l5index >= this.l5Buffer.size || this.l5index < 0) {
                this.l5index = this.l5lower;
            }
            if (this.l5index + 1 < this.l5Buffer.size && this.context[5] == this.l5Buffer.intAt(this.l5index + 1)) {
                ++this.l5index;
            } else if (this.l5upper - this.l5lower >= 16) {
                n = this.l5lower + (int)((float)(this.l5upper - this.l5lower) * ((float)(this.context[5] - this.l5Buffer.intAt(this.l5lower)) / (float)(this.l5Buffer.intAt(this.l5upper) - this.l5Buffer.intAt(this.l5lower))));
                if (this.l5Buffer.intAt(n) > this.context[5]) {
                    while (this.context[5] != this.l5Buffer.intAt(n)) {
                        --n;
                    }
                } else if (this.l5Buffer.intAt(n) < this.context[5]) {
                    while (this.context[5] != this.l5Buffer.intAt(n)) {
                        ++n;
                    }
                }
                this.l5index = n;
            } else if (this.context[5] < this.l5Buffer.intAt(this.l5index)) {
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    --this.l5index;
                }
            } else {
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    ++this.l5index;
                }
            }
        }
    }

    @Override
    public boolean pop() {
        boolean bl = this.contextStack.load(this.stackTemp);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l4index = this.stackTemp[this.nestingLevel + 3];
        this.l5index = this.stackTemp[this.nestingLevel + 4];
        this.l2lower = this.stackTemp[this.nestingLevel + 5];
        this.l2upper = this.stackTemp[this.nestingLevel + 6];
        this.l3lower = this.stackTemp[this.nestingLevel + 7];
        this.l3upper = this.stackTemp[this.nestingLevel + 8];
        this.l4lower = this.stackTemp[this.nestingLevel + 9];
        this.l4upper = this.stackTemp[this.nestingLevel + 10];
        this.l5lower = this.stackTemp[this.nestingLevel + 11];
        this.l5upper = this.stackTemp[this.nestingLevel + 12];
        this.atTerminal = this.stackTemp[this.nestingLevel + 13] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 14];
        return true;
    }

    @Override
    protected final boolean pop2() {
        boolean bl = this.contextStack2.load(this.stackTemp);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l4index = this.stackTemp[this.nestingLevel + 3];
        this.l5index = this.stackTemp[this.nestingLevel + 4];
        this.l2lower = this.stackTemp[this.nestingLevel + 5];
        this.l2upper = this.stackTemp[this.nestingLevel + 6];
        this.l3lower = this.stackTemp[this.nestingLevel + 7];
        this.l3upper = this.stackTemp[this.nestingLevel + 8];
        this.l4lower = this.stackTemp[this.nestingLevel + 9];
        this.l4upper = this.stackTemp[this.nestingLevel + 10];
        this.l5lower = this.stackTemp[this.nestingLevel + 11];
        this.l5upper = this.stackTemp[this.nestingLevel + 12];
        this.atTerminal = this.stackTemp[this.nestingLevel + 13] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 14];
        return true;
    }

    @Override
    public final void push() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l4index;
        this.stackTemp[this.nestingLevel + 4] = this.l5index;
        this.stackTemp[this.nestingLevel + 5] = this.l2lower;
        this.stackTemp[this.nestingLevel + 6] = this.l2upper;
        this.stackTemp[this.nestingLevel + 7] = this.l3lower;
        this.stackTemp[this.nestingLevel + 8] = this.l3upper;
        this.stackTemp[this.nestingLevel + 9] = this.l4lower;
        this.stackTemp[this.nestingLevel + 10] = this.l4upper;
        this.stackTemp[this.nestingLevel + 11] = this.l5lower;
        this.stackTemp[this.nestingLevel + 12] = this.l5upper;
        this.stackTemp[this.nestingLevel + 13] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 14] = this.LN;
        this.contextStack.store(this.stackTemp);
    }

    @Override
    protected final void push2() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l4index;
        this.stackTemp[this.nestingLevel + 4] = this.l5index;
        this.stackTemp[this.nestingLevel + 5] = this.l2lower;
        this.stackTemp[this.nestingLevel + 6] = this.l2upper;
        this.stackTemp[this.nestingLevel + 7] = this.l3lower;
        this.stackTemp[this.nestingLevel + 8] = this.l3upper;
        this.stackTemp[this.nestingLevel + 9] = this.l4lower;
        this.stackTemp[this.nestingLevel + 10] = this.l4upper;
        this.stackTemp[this.nestingLevel + 11] = this.l5lower;
        this.stackTemp[this.nestingLevel + 12] = this.l5upper;
        this.stackTemp[this.nestingLevel + 13] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 14] = this.LN;
        this.contextStack2.store(this.stackTemp);
    }

    private final void recoverNode_l3(int n) {
        int n2;
        int n3 = this.l2Buffer.lower32At(this.l2index);
        if (this.l3lower != n3) {
            this.l3lower = n3;
            this.l3upper = this.l3Buffer.size - 1;
            for (n2 = this.l2index + 1; n2 < this.l2Buffer.size; ++n2) {
                n3 = this.l2Buffer.lower32At(n2);
                if (n3 == -1) continue;
                this.l3upper = n3 - 1;
                break;
            }
        }
        n2 = this.l3Buffer.upper32At(this.l3lower);
        int n4 = this.l3Buffer.upper32At(this.l3upper);
        for (n3 = Math.min(this.l3lower + (int)((float)(n - n2) / (float)(n4 - n2 + 1) * (float)(this.l3upper - this.l3lower)), this.l3upper); n3 < this.l3Buffer.size - 1 && this.l3Buffer.upper32At(n3) < n; ++n3) {
        }
        while (this.l3Buffer.upper32At(n3) > n && n3 > 0) {
            --n3;
        }
        this.context[3] = this.l3Buffer.upper32At(n3);
        this.l3index = n3;
    }

    private final void recoverNode_l4(int n) {
        int n2;
        int n3 = this.l3Buffer.lower32At(this.l3index);
        if (this.l4lower != n3) {
            this.l4lower = n3;
            this.l4upper = this.l4Buffer.size - 1;
            for (n2 = this.l3index + 1; n2 < this.l3Buffer.size; ++n2) {
                n3 = this.l3Buffer.lower32At(n2);
                if (n3 == -1) continue;
                this.l4upper = n3 - 1;
                break;
            }
        }
        n2 = this.l4Buffer.upper32At(this.l4lower);
        int n4 = this.l4Buffer.upper32At(this.l4upper);
        for (n3 = Math.min(this.l4lower + (int)((float)(n - n2) / (float)(n4 - n2 + 1) * (float)(this.l4upper - this.l4lower)), this.l4upper); n3 < this.l4Buffer.size - 1 && this.l4Buffer.upper32At(n3) < n; ++n3) {
        }
        while (this.l4Buffer.upper32At(n3) > n && n3 > 0) {
            --n3;
        }
        this.context[4] = this.l4Buffer.upper32At(n3);
        this.l4index = n3;
    }

    private final void recoverNode_l5(int n) {
        int n2;
        int n3 = this.l4Buffer.lower32At(this.l4index);
        if (this.l5lower != n3) {
            this.l5lower = n3;
            this.l5upper = this.l5Buffer.size - 1;
            for (n2 = this.l4index + 1; n2 < this.l4Buffer.size; ++n2) {
                n3 = this.l4Buffer.lower32At(n2);
                if (n3 == -1) continue;
                this.l5upper = n3 - 1;
                break;
            }
        }
        n2 = this.l5Buffer.intAt(this.l5lower);
        int n4 = this.l5Buffer.intAt(this.l5upper);
        for (n3 = Math.min(this.l5lower + (int)((float)(n - n2) / (float)(n4 - n2 + 1) * (float)(this.l5upper - this.l5lower)), this.l5upper); n3 < this.l5Buffer.size - 1 && this.l5Buffer.intAt(n3) < n; ++n3) {
        }
        while (this.l5Buffer.intAt(n3) > n && n3 > 0) {
            --n3;
        }
        this.context[5] = this.l5Buffer.intAt(n3);
        this.l5index = n3;
    }

    @Override
    protected void sync(int n, int n2) {
        switch (n) {
            case -1: {
                return;
            }
            case 0: {
                if (this.l1Buffer.size == 0) break;
                if (this.l1index == -1) {
                    this.l1index = 0;
                }
                if (n2 > this.l1Buffer.upper32At(this.l1Buffer.size - 1)) {
                    this.l1index = this.l1Buffer.size - 1;
                    return;
                }
                if (n2 > this.l1Buffer.upper32At(this.l1index)) {
                    while (this.l1index < this.l1Buffer.size - 1 && this.l1Buffer.upper32At(this.l1index) < n2) {
                        ++this.l1index;
                    }
                } else {
                    while (this.l1index > 0 && this.l1Buffer.upper32At(this.l1index - 1) > n2) {
                        --this.l1index;
                    }
                }
                break;
            }
            case 1: {
                if (this.l1Buffer.lower32At(this.l1index) == -1) break;
                if (this.l2lower != this.l1Buffer.lower32At(this.l1index)) {
                    this.l2lower = this.l2index = this.l1Buffer.lower32At(this.l1index);
                    this.l2upper = this.l2Buffer.size - 1;
                    int n3 = this.l1Buffer.size;
                    for (int i = this.l1index + 1; i < n3; ++i) {
                        int n4 = this.l1Buffer.lower32At(i);
                        if (n4 == -1) continue;
                        this.l2upper = n4 - 1;
                        break;
                    }
                }
                if (n2 > this.l2Buffer.upper32At(this.l2index)) {
                    while (this.l2index < this.l2upper && this.l2Buffer.upper32At(this.l2index) < n2) {
                        ++this.l2index;
                    }
                } else {
                    while (this.l2index > this.l2lower && this.l2Buffer.upper32At(this.l2index - 1) > n2) {
                        --this.l2index;
                    }
                }
                break;
            }
            case 2: {
                if (this.l2Buffer.lower32At(this.l2index) == -1) break;
                if (this.l3lower != this.l2Buffer.lower32At(this.l2index)) {
                    this.l3index = this.l3lower = this.l2Buffer.lower32At(this.l2index);
                    this.l3upper = this.l3Buffer.size - 1;
                    int n5 = this.l2Buffer.size;
                    for (int i = this.l2index + 1; i < n5; ++i) {
                        int n6 = this.l2Buffer.lower32At(i);
                        if (n6 == -1) continue;
                        this.l3upper = n6 - 1;
                        break;
                    }
                }
                if (n2 > this.l3Buffer.upper32At(this.l3index)) {
                    while (this.l3index < this.l3upper && this.l3Buffer.upper32At(this.l3index) < n2) {
                        ++this.l3index;
                    }
                } else {
                    while (this.l3index > this.l3lower && this.l3Buffer.upper32At(this.l3index - 1) > n2) {
                        --this.l3index;
                    }
                }
                break;
            }
            case 3: {
                if (this.l3Buffer.lower32At(this.l3index) == -1) break;
                if (this.l4lower != this.l3Buffer.lower32At(this.l3index)) {
                    this.l4index = this.l4lower = this.l3Buffer.lower32At(this.l3index);
                    this.l4upper = this.l4Buffer.size - 1;
                    int n7 = this.l3Buffer.size;
                    for (int i = this.l3index + 1; i < n7; ++i) {
                        int n8 = this.l3Buffer.lower32At(i);
                        if (n8 == -1) continue;
                        this.l4upper = n8 - 1;
                        break;
                    }
                }
                if (n2 > this.l4Buffer.upper32At(this.l4index)) {
                    while (this.l4index < this.l4upper && this.l4Buffer.upper32At(this.l4index) < n2) {
                        ++this.l4index;
                    }
                } else {
                    while (this.l4index > this.l4lower && this.l4Buffer.upper32At(this.l4index - 1) > n2) {
                        --this.l4index;
                    }
                }
                break;
            }
            case 4: {
                if (this.l4Buffer.lower32At(this.l4index) == -1) break;
                if (this.l5lower != this.l4Buffer.lower32At(this.l4index)) {
                    this.l5index = this.l5lower = this.l4Buffer.lower32At(this.l4index);
                    this.l5upper = this.l5Buffer.size - 1;
                    int n9 = this.l4Buffer.size;
                    for (int i = this.l4index + 1; i < n9; ++i) {
                        int n10 = this.l4Buffer.lower32At(i);
                        if (n10 == -1) continue;
                        this.l5upper = n10 - 1;
                        break;
                    }
                }
                if (n2 > this.l5Buffer.intAt(this.l5index)) {
                    while (this.l5index < this.l5upper && this.l5Buffer.intAt(this.l5index) < n2) {
                        ++this.l5index;
                    }
                } else {
                    while (this.l5index > this.l5lower && this.l5Buffer.intAt(this.l5index - 1) > n2) {
                        --this.l5index;
                    }
                }
                break;
            }
            default: {
                if (this.l4Buffer.lower32At(this.l4index) == -1) break;
                if (this.l5lower != this.l4Buffer.lower32At(this.l4index)) {
                    this.l5index = this.l5lower = this.l4Buffer.lower32At(this.l4index);
                    this.l5upper = this.l5Buffer.size - 1;
                    int n11 = this.l4Buffer.size;
                    for (int i = this.l4index + 1; i < n11; ++i) {
                        int n12 = this.l4Buffer.lower32At(i);
                        if (n12 == -1) continue;
                        this.l5upper = n12 - 1;
                        break;
                    }
                }
                while (this.context[5] != this.l5Buffer.intAt(this.l5index)) {
                    ++this.l5index;
                }
                break block0;
            }
        }
    }

    @Override
    public void sampleState(FastIntBuffer fastIntBuffer) {
        if (this.context[0] >= 1) {
            fastIntBuffer.append(this.l1index);
        }
        if (this.context[0] >= 2) {
            fastIntBuffer.append(this.l2index);
            fastIntBuffer.append(this.l2lower);
            fastIntBuffer.append(this.l2upper);
        }
        if (this.context[0] >= 3) {
            fastIntBuffer.append(this.l3index);
            fastIntBuffer.append(this.l3lower);
            fastIntBuffer.append(this.l3upper);
        }
        if (this.context[0] >= 4) {
            fastIntBuffer.append(this.l4index);
            fastIntBuffer.append(this.l4lower);
            fastIntBuffer.append(this.l4upper);
        }
        if (this.context[0] >= 5) {
            fastIntBuffer.append(this.l5index);
            fastIntBuffer.append(this.l5lower);
            fastIntBuffer.append(this.l5upper);
        }
    }

    @Override
    public void dumpState() {
        System.out.println("l1 index ==>" + this.l1index);
        System.out.println("l2 index ==>" + this.l2index);
        System.out.println("l2 lower ==>" + this.l2lower);
        System.out.println("l2 upper ==>" + this.l2upper);
        System.out.println("l3 index ==>" + this.l3index);
        System.out.println("l3 lower ==>" + this.l3lower);
        System.out.println("l3 upper ==>" + this.l3upper);
        System.out.println("l4 index ==>" + this.l4index);
        System.out.println("l4 lower ==>" + this.l4lower);
        System.out.println("l4 upper ==>" + this.l4upper);
        System.out.println("l5 index ==>" + this.l5index);
        System.out.println("l5 lower ==>" + this.l5lower);
        System.out.println("l5 upper ==>" + this.l5upper);
    }

    @Override
    public boolean toElement(int n, String string) throws NavException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        boolean bl = false;
        if (string == null) {
            throw new IllegalArgumentException(" Element name can't be null ");
        }
        if (string.equals("*")) {
            return this.toElement(n);
        }
        switch (n) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElement(string)) {
                    if (this.toElement(4, string)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElement(string)) {
                    if (this.toElement(5, string)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    if (this.nodeToElement(4)) {
                        bl = true;
                        n3 = this.LN;
                        if (this.matchElement(string)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!bl) {
                    n4 = this.context[0];
                    switch (n4) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            n5 = this.l1index;
                            break;
                        }
                        case 2: {
                            n5 = this.l2index;
                            break;
                        }
                        case 3: {
                            n5 = this.l3index;
                            break;
                        }
                        case 4: {
                            n5 = this.l4index;
                            break;
                        }
                        case 5: {
                            n5 = this.l5index;
                            break;
                        }
                    }
                    n2 = this.context[n4];
                }
                while (this.toElement(4)) {
                    if (!this.matchElement(string)) continue;
                    return true;
                }
                if (bl) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    this.LN = n3;
                    return false;
                }
                switch (n4) {
                    case 1: {
                        this.l1index = n5;
                        break;
                    }
                    case 2: {
                        this.l2index = n5;
                        break;
                    }
                    case 3: {
                        this.l3index = n5;
                        break;
                    }
                    case 4: {
                        this.l4index = n5;
                        break;
                    }
                    case 5: {
                        this.l5index = n5;
                        break;
                    }
                }
                this.context[n4] = n2;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    if (this.nodeToElement(5)) {
                        bl = true;
                        n3 = this.LN;
                        if (this.matchElement(string)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!bl) {
                    n4 = this.context[0];
                    switch (n4) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            n5 = this.l1index;
                            break;
                        }
                        case 2: {
                            n5 = this.l2index;
                            break;
                        }
                        case 3: {
                            n5 = this.l3index;
                            break;
                        }
                        case 4: {
                            n5 = this.l4index;
                            break;
                        }
                        case 5: {
                            n5 = this.l5index;
                            break;
                        }
                    }
                    n2 = this.context[n4];
                }
                while (this.toElement(5)) {
                    if (!this.matchElement(string)) continue;
                    return true;
                }
                if (bl) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    this.LN = n3;
                    return false;
                }
                switch (n4) {
                    case 1: {
                        this.l1index = n5;
                        break;
                    }
                    case 2: {
                        this.l2index = n5;
                        break;
                    }
                    case 3: {
                        this.l3index = n5;
                        break;
                    }
                    case 4: {
                        this.l4index = n5;
                        break;
                    }
                    case 5: {
                        this.l5index = n5;
                        break;
                    }
                }
                this.context[n4] = n2;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    public boolean toElement(int n) throws NavException {
        switch (n) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                this.l3index = -1;
                this.l2index = -1;
                this.l1index = -1;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        this.context[0] = 0;
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size > 0) {
                            this.context[0] = 1;
                            this.l1index = n == 2 ? 0 : this.l1Buffer.size - 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        this.l2lower = this.l1Buffer.lower32At(this.l1index);
                        if (this.l2lower == -1) {
                            return false;
                        }
                        this.context[0] = 2;
                        this.l2upper = this.l2Buffer.size - 1;
                        int n2 = this.l1Buffer.size;
                        for (int i = this.l1index + 1; i < n2; ++i) {
                            int n3 = this.l1Buffer.lower32At(i);
                            if (n3 == -1) continue;
                            this.l2upper = n3 - 1;
                            break;
                        }
                        this.l2index = n == 2 ? this.l2lower : this.l2upper;
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 2: {
                        this.l3lower = this.l2Buffer.lower32At(this.l2index);
                        if (this.l3lower == -1) {
                            return false;
                        }
                        this.context[0] = 3;
                        this.l3upper = this.l3Buffer.size - 1;
                        int n4 = this.l2Buffer.size;
                        for (int i = this.l2index + 1; i < n4; ++i) {
                            int n5 = this.l2Buffer.lower32At(i);
                            if (n5 == -1) continue;
                            this.l3upper = n5 - 1;
                            break;
                        }
                        this.l3index = n == 2 ? this.l3lower : this.l3upper;
                        this.context[3] = this.l3Buffer.upper32At(this.l3index);
                        return true;
                    }
                    case 3: {
                        this.l4lower = this.l3Buffer.lower32At(this.l3index);
                        if (this.l4lower == -1) {
                            return false;
                        }
                        this.context[0] = 4;
                        this.l4upper = this.l4Buffer.size - 1;
                        int n6 = this.l3Buffer.size;
                        for (int i = this.l3index + 1; i < n6; ++i) {
                            int n7 = this.l3Buffer.lower32At(i);
                            if (n7 == -1) continue;
                            this.l4upper = n7 - 1;
                            break;
                        }
                        this.l4index = n == 2 ? this.l4lower : this.l4upper;
                        this.context[4] = this.l4Buffer.upper32At(this.l4index);
                        return true;
                    }
                    case 4: {
                        this.l5lower = this.l4Buffer.lower32At(this.l4index);
                        if (this.l5lower == -1) {
                            return false;
                        }
                        this.context[0] = 5;
                        this.l5upper = this.l5Buffer.size - 1;
                        int n8 = this.l4Buffer.size;
                        for (int i = this.l4index + 1; i < n8; ++i) {
                            int n9 = this.l4Buffer.lower32At(i);
                            if (n9 == -1) continue;
                            this.l5upper = n9 - 1;
                            break;
                        }
                        this.l5index = n == 2 ? this.l5lower : this.l5upper;
                        this.context[5] = this.l5Buffer.intAt(this.l5index);
                        return true;
                    }
                }
                if (n == 2) {
                    int n10 = this.vtdBuffer.size;
                    for (int i = this.context[this.context[0]] + 1; i < n10; ++i) {
                        long l = this.vtdBuffer.longAt(i);
                        int n11 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                        if (n11 != 0) continue;
                        int n12 = (int)((0xFF0000000000000L & l) >> 52);
                        if (n12 <= this.context[0]) {
                            return false;
                        }
                        if (n12 != this.context[0] + 1) continue;
                        this.context[0] = this.context[0] + 1;
                        this.context[this.context[0]] = i;
                        return true;
                    }
                    return false;
                }
                int n13 = -1;
                int n14 = this.vtdBuffer.size;
                for (int i = this.context[this.context[0]] + 1; i < n14; ++i) {
                    long l = this.vtdBuffer.longAt(i);
                    int n15 = (int)((0xFF0000000000000L & l) >> 52);
                    int n16 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                    if (n16 != 0) continue;
                    if (n15 <= this.context[0]) break;
                    if (n15 != this.context[0] + 1) continue;
                    n13 = i;
                }
                if (n13 == -1) {
                    return false;
                }
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = n13;
                return true;
            }
            case 4: 
            case 5: {
                if (this.atTerminal) {
                    return this.nodeToElement(n);
                }
                switch (this.context[0]) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (n == 4) {
                            if (this.l1index + 1 >= this.l1Buffer.size) {
                                return false;
                            }
                            ++this.l1index;
                        } else {
                            if (this.l1index - 1 < 0) {
                                return false;
                            }
                            --this.l1index;
                        }
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    case 2: {
                        if (n == 4) {
                            if (this.l2index + 1 > this.l2upper) {
                                return false;
                            }
                            ++this.l2index;
                        } else {
                            if (this.l2index - 1 < this.l2lower) {
                                return false;
                            }
                            --this.l2index;
                        }
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 3: {
                        if (n == 4) {
                            if (this.l3index + 1 > this.l3upper) {
                                return false;
                            }
                            ++this.l3index;
                        } else {
                            if (this.l3index - 1 < this.l3lower) {
                                return false;
                            }
                            --this.l3index;
                        }
                        this.context[3] = this.l3Buffer.upper32At(this.l3index);
                        return true;
                    }
                    case 4: {
                        if (n == 4) {
                            if (this.l4index + 1 > this.l4upper) {
                                return false;
                            }
                            ++this.l4index;
                        } else {
                            if (this.l4index - 1 < this.l4lower) {
                                return false;
                            }
                            --this.l4index;
                        }
                        this.context[4] = this.l4Buffer.upper32At(this.l4index);
                        return true;
                    }
                    case 5: {
                        if (n == 4) {
                            if (this.l5index + 1 > this.l5upper) {
                                return false;
                            }
                            ++this.l5index;
                        } else {
                            if (this.l5index - 1 < this.l5lower) {
                                return false;
                            }
                            --this.l5index;
                        }
                        this.context[5] = this.l5Buffer.intAt(this.l5index);
                        return true;
                    }
                }
                if (n == 4) {
                    int n17 = this.vtdBuffer.size;
                    for (int i = this.context[this.context[0]] + 1; i < n17; ++i) {
                        long l = this.vtdBuffer.longAt(i);
                        int n18 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                        if (n18 != 0) continue;
                        int n19 = (int)((0xFF0000000000000L & l) >> 52);
                        if (n19 < this.context[0]) {
                            return false;
                        }
                        if (n19 != this.context[0]) continue;
                        this.context[this.context[0]] = i;
                        return true;
                    }
                    return false;
                }
                for (int i = this.context[this.context[0]] - 1; i > this.context[this.context[0] - 1]; --i) {
                    int n20;
                    long l = this.vtdBuffer.longAt(i);
                    int n21 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                    if (n21 != 0 || (n20 = (int)((0xFF0000000000000L & l) >> 52)) != this.context[0]) continue;
                    this.context[this.context[0]] = i;
                    return true;
                }
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    public boolean toElementNS(int n, String string, String string2) throws NavException {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        boolean bl = false;
        if (!this.ns) {
            return false;
        }
        switch (n) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElementNS(string, string2)) {
                    if (this.toElementNS(4, string, string2)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElementNS(string, string2)) {
                    if (this.toElementNS(5, string, string2)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    if (this.nodeToElement(4)) {
                        bl = true;
                        n3 = this.LN;
                        if (this.matchElementNS(string, string2)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!bl) {
                    n5 = this.context[0];
                    n2 = this.context[n5];
                    switch (n5) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            n4 = this.l1index;
                            break;
                        }
                        case 2: {
                            n4 = this.l2index;
                            break;
                        }
                        case 3: {
                            n4 = this.l3index;
                            break;
                        }
                        case 4: {
                            n4 = this.l4index;
                            break;
                        }
                        case 5: {
                            n4 = this.l5index;
                            break;
                        }
                    }
                }
                while (this.toElement(4)) {
                    if (!this.matchElementNS(string, string2)) continue;
                    return true;
                }
                if (bl) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    this.LN = n3;
                    return false;
                }
                switch (n5) {
                    case 1: {
                        this.l1index = n4;
                        break;
                    }
                    case 2: {
                        this.l2index = n4;
                        break;
                    }
                    case 3: {
                        this.l3index = n4;
                        break;
                    }
                    case 4: {
                        this.l4index = n4;
                        break;
                    }
                    case 5: {
                        this.l5index = n4;
                        break;
                    }
                }
                this.context[n5] = n2;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    if (this.nodeToElement(5)) {
                        bl = true;
                        n3 = this.LN;
                        if (this.matchElementNS(string, string2)) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (!bl) {
                    n5 = this.context[0];
                    n2 = this.context[n5];
                    switch (n5) {
                        case -1: 
                        case 0: {
                            return false;
                        }
                        case 1: {
                            n4 = this.l1index;
                            break;
                        }
                        case 2: {
                            n4 = this.l2index;
                            break;
                        }
                        case 3: {
                            n4 = this.l3index;
                            break;
                        }
                        case 4: {
                            n4 = this.l4index;
                            break;
                        }
                        case 5: {
                            n4 = this.l5index;
                            break;
                        }
                    }
                }
                while (this.toElement(5)) {
                    if (!this.matchElementNS(string, string2)) continue;
                    return true;
                }
                if (bl) {
                    this.context[0] = this.context[0] - 1;
                    this.atTerminal = true;
                    this.LN = n3;
                    return false;
                }
                switch (n5) {
                    case 1: {
                        this.l1index = n4;
                        break;
                    }
                    case 2: {
                        this.l2index = n4;
                        break;
                    }
                    case 3: {
                        this.l3index = n4;
                        break;
                    }
                    case 4: {
                        this.l4index = n4;
                        break;
                    }
                    case 5: {
                        this.l5index = n4;
                        break;
                    }
                }
                this.context[n5] = n2;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    public void recoverNode(int n) throws NavException {
        int n2;
        if (n < 0 || n >= this.vtdSize) {
            throw new NavException("Invalid VTD index");
        }
        int n3 = this.getTokenType(n);
        if (n3 == 8 || n3 == 9 || n3 == 10 || n3 == 4) {
            throw new NavException("Token type not yet supported");
        }
        int n4 = this.getTokenDepth(n);
        switch (n4) {
            case -1: {
                this.context[0] = -1;
                if (n != 0) {
                    this.LN = n;
                    this.atTerminal = true;
                }
                return;
            }
            case 0: {
                this.context[0] = 0;
                if (n != this.rootIndex) {
                    this.LN = n;
                    this.atTerminal = true;
                    if (n3 > 3) {
                        this.sync(0, n);
                    }
                } else {
                    this.atTerminal = false;
                }
                return;
            }
        }
        this.context[0] = n4;
        if (n3 != 0) {
            this.LN = n;
            this.atTerminal = true;
        }
        this.recoverNode_l1(n);
        if (n4 == 1) {
            if (this.atTerminal && n3 > 3) {
                this.sync(1, n);
            }
            return;
        }
        this.recoverNode_l2(n);
        if (n4 == 2) {
            if (this.atTerminal && n3 > 3) {
                this.sync(2, n);
            }
            return;
        }
        this.recoverNode_l3(n);
        if (n4 == 3) {
            if (this.atTerminal && n3 > 3) {
                this.sync(3, n);
            }
            return;
        }
        this.recoverNode_l4(n);
        if (n4 == 4) {
            if (this.atTerminal && n3 > 3) {
                this.sync(4, n);
            }
            return;
        }
        this.recoverNode_l5(n);
        if (n4 == 5) {
            if (this.atTerminal && n3 > 3) {
                this.sync(5, n);
            }
            return;
        }
        if (n3 == 0) {
            this.context[n4] = n;
        } else {
            n2 = n - 1;
            while (this.getTokenType(n2) != 0 || this.getTokenDepth(n2) != n4) {
                --n2;
            }
            this.context[n4] = n2;
        }
        n2 = this.context[n4] - 1;
        --n4;
        while (n4 > 5) {
            while (this.getTokenType(n2) != 0 || this.getTokenDepth(n2) != n4) {
                --n2;
            }
            this.context[n4] = n2;
            --n4;
        }
    }

    @Override
    public void writeIndex(OutputStream outputStream) throws IndexWriteException, IOException {
        IndexHandler.writeIndex_L5((byte)1, this.encoding, this.ns, true, this.nestingLevel - 1, 5, this.rootIndex, this.XMLDoc.getBytes(), this.docOffset, this.docLen, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, outputStream);
    }

    @Override
    public void writeSeparateIndex(OutputStream outputStream) throws IndexWriteException, IOException {
        IndexHandler.writeSeparateIndex_L5((byte)2, this.encoding, this.ns, true, this.nestingLevel - 1, 5, this.rootIndex, this.docOffset, this.docLen, this.vtdBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.l4Buffer, this.l5Buffer, outputStream);
    }

    @Override
    protected boolean toNode(int n) throws NavException {
        switch (n) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        int n2 = this.rootIndex - 1;
                        block92: while (n2 > 0) {
                            int n3 = this.getTokenType(n2);
                            switch (n3) {
                                case 6: {
                                    --n2;
                                    continue block92;
                                }
                                case 8: {
                                    n2 -= 2;
                                    continue block92;
                                }
                            }
                        }
                        if (++n2 != this.rootIndex) {
                            this.atTerminal = true;
                            this.LN = n2;
                        } else {
                            this.context[0] = 0;
                        }
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size != 0) {
                            int n4 = this.l1Buffer.upper32At(0) - 1;
                            block93: while (n4 > this.rootIndex) {
                                int n5 = this.getTokenType(n4);
                                switch (n5) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --n4;
                                        continue block93;
                                    }
                                    case 8: {
                                        n4 -= 2;
                                        continue block93;
                                    }
                                }
                            }
                            this.l1index = 0;
                            if (++n4 == this.l1Buffer.upper32At(0)) {
                                this.context[0] = 1;
                                this.context[1] = this.l1Buffer.upper32At(0);
                                this.atTerminal = false;
                            } else {
                                this.atTerminal = true;
                                this.LN = n4;
                            }
                            return true;
                        }
                        block94: for (int i = this.rootIndex + 1; i < this.vtdSize; i += 2) {
                            int n6 = this.getTokenType(i);
                            switch (n6) {
                                case 2: 
                                case 3: {
                                    continue block94;
                                }
                            }
                            if (this.getTokenDepth(i) == 0) {
                                this.atTerminal = true;
                                this.LN = i;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 1: {
                        if (this.l1Buffer.lower32At(this.l1index) != -1) {
                            int n7;
                            int n8;
                            this.l2lower = this.l1Buffer.lower32At(this.l1index);
                            for (n8 = this.l1index + 1; n8 < this.l1Buffer.size; ++n8) {
                                if (this.l1Buffer.lower32At(n8) == -1) continue;
                                this.l2upper = this.l1Buffer.lower32At(n8) - 1;
                                break;
                            }
                            if (n8 == this.l1Buffer.size) {
                                this.l2upper = this.l2Buffer.size - 1;
                            }
                            n8 = this.l2Buffer.upper32At(this.l2lower);
                            block96: for (n7 = this.context[1] + 1; n7 < n8; n7 += 2) {
                                int n9 = this.getTokenType(n7);
                                switch (n9) {
                                    case 2: 
                                    case 3: {
                                        continue block96;
                                    }
                                }
                                this.l2index = this.l2lower;
                                this.atTerminal = true;
                                this.LN = n7;
                                return true;
                            }
                            this.l2index = this.l2lower;
                            this.context[0] = 2;
                            this.context[2] = n7;
                            return true;
                        }
                        block97: for (int i = this.context[1] + 1; i < this.vtdSize; i += 2) {
                            int n10 = this.getTokenType(i);
                            switch (n10) {
                                case 2: 
                                case 3: {
                                    continue block97;
                                }
                            }
                            if (this.getTokenDepth(i) == 1 && this.getTokenType(i) != 0) {
                                this.atTerminal = true;
                                this.LN = i;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 2: {
                        if (this.l2Buffer.lower32At(this.l2index) != -1) {
                            int n11;
                            int n12;
                            this.l3lower = this.l2Buffer.lower32At(this.l2index);
                            for (n12 = this.l2index + 1; n12 < this.l2Buffer.size; ++n12) {
                                if (this.l2Buffer.lower32At(n12) == -1) continue;
                                this.l3upper = this.l2Buffer.lower32At(n12) - 1;
                                break;
                            }
                            if (n12 == this.l2Buffer.size) {
                                this.l3upper = this.l3Buffer.size - 1;
                            }
                            n12 = this.l3Buffer.upper32At(this.l3lower);
                            block99: for (n11 = this.context[2] + 1; n11 < n12; n11 += 2) {
                                int n13 = this.getTokenType(n11);
                                switch (n13) {
                                    case 2: 
                                    case 3: {
                                        continue block99;
                                    }
                                }
                                this.l3index = this.l3lower;
                                this.atTerminal = true;
                                this.LN = n11;
                                return true;
                            }
                            this.l3index = this.l3lower;
                            this.context[0] = 3;
                            this.context[3] = n11;
                            return true;
                        }
                        block100: for (int i = this.context[2] + 1; i < this.vtdSize; i += 2) {
                            int n14 = this.getTokenType(i);
                            switch (n14) {
                                case 2: 
                                case 3: {
                                    continue block100;
                                }
                            }
                            if (this.getTokenDepth(i) == 2 && this.getTokenType(i) != 0) {
                                this.atTerminal = true;
                                this.LN = i;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 3: {
                        if (this.l3Buffer.lower32At(this.l3index) != -1) {
                            int n15;
                            int n16;
                            this.l4lower = this.l3Buffer.lower32At(this.l3index);
                            for (n16 = this.l3index + 1; n16 < this.l3Buffer.size; ++n16) {
                                if (this.l3Buffer.lower32At(n16) == -1) continue;
                                this.l4upper = this.l3Buffer.lower32At(n16) - 1;
                                break;
                            }
                            if (n16 == this.l3Buffer.size) {
                                this.l4upper = this.l4Buffer.size - 1;
                            }
                            n16 = this.l4Buffer.upper32At(this.l4lower);
                            block102: for (n15 = this.context[3] + 1; n15 < n16; n15 += 2) {
                                int n17 = this.getTokenType(n15);
                                switch (n17) {
                                    case 2: 
                                    case 3: {
                                        continue block102;
                                    }
                                }
                                this.l4index = this.l4lower;
                                this.atTerminal = true;
                                this.LN = n15;
                                return true;
                            }
                            this.l4index = this.l4lower;
                            this.context[0] = 4;
                            this.context[4] = n15;
                            return true;
                        }
                        block103: for (int i = this.context[3] + 1; i < this.vtdSize; i += 2) {
                            int n18 = this.getTokenType(i);
                            switch (n18) {
                                case 2: 
                                case 3: {
                                    continue block103;
                                }
                            }
                            if (this.getTokenDepth(i) == 3 && this.getTokenType(i) != 0) {
                                this.atTerminal = true;
                                this.LN = i;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 4: {
                        if (this.l4Buffer.lower32At(this.l4index) != -1) {
                            int n19;
                            int n20;
                            this.l5lower = this.l4Buffer.lower32At(this.l4index);
                            for (n20 = this.l4index + 1; n20 < this.l4Buffer.size; ++n20) {
                                if (this.l4Buffer.lower32At(n20) == -1) continue;
                                this.l5upper = this.l4Buffer.lower32At(n20) - 1;
                                break;
                            }
                            if (n20 == this.l4Buffer.size) {
                                this.l5upper = this.l5Buffer.size - 1;
                            }
                            n20 = this.l5Buffer.intAt(this.l5lower);
                            block105: for (n19 = this.context[4] + 1; n19 < n20; n19 += 2) {
                                int n21 = this.getTokenType(n19);
                                switch (n21) {
                                    case 2: 
                                    case 3: {
                                        continue block105;
                                    }
                                }
                                this.l5index = this.l5lower;
                                this.atTerminal = true;
                                this.LN = n19;
                                return true;
                            }
                            this.l5index = this.l5lower;
                            this.context[0] = 5;
                            this.context[5] = n19;
                            return true;
                        }
                        block106: for (int i = this.context[4] + 1; i < this.vtdSize; i += 2) {
                            int n22 = this.getTokenType(i);
                            switch (n22) {
                                case 2: 
                                case 3: {
                                    continue block106;
                                }
                            }
                            if (this.getTokenDepth(i) == 4 && this.getTokenType(i) != 0) {
                                this.atTerminal = true;
                                this.LN = i;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                }
                int n23 = this.context[this.context[0]] + 1;
                while (n23 < this.vtdBuffer.size) {
                    long l = this.vtdBuffer.longAt(n23);
                    int n24 = (int)((0xF000000000000000L & l) >>> 60);
                    switch (n24) {
                        case 0: {
                            int n25 = (int)((0xFF0000000000000L & l) >> 52);
                            if (n25 <= this.context[0]) {
                                return false;
                            }
                            if (n25 == this.context[0] + 1) {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = n23;
                                return true;
                            }
                            throw new NavException("impossible condition");
                        }
                        case 2: 
                        case 3: {
                            n23 += 2;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 11: {
                            int n25 = (int)((0xFF0000000000000L & l) >> 52);
                            if (n25 < this.context[0]) {
                                return false;
                            }
                            if (n25 == this.context[0]) {
                                this.LN = n23;
                                this.atTerminal = true;
                                return true;
                            }
                            ++n23;
                        }
                        case 7: {
                            int n25 = (int)((0xFF0000000000000L & l) >> 52);
                            if (n25 < this.context[0]) {
                                return false;
                            }
                            if (n25 == this.context[0]) {
                                this.LN = n23;
                                this.atTerminal = true;
                                return true;
                            }
                            n23 += 2;
                        }
                    }
                }
                return false;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                return this.toNode_LastChild();
            }
            case 4: {
                int n26;
                int n27;
                int n28;
                switch (this.context[0]) {
                    case -1: {
                        if (this.atTerminal) {
                            int n29 = this.LN;
                            int n30 = this.getTokenType(n29);
                            switch (n30) {
                                case 7: {
                                    n29 += 2;
                                    break;
                                }
                                case 6: {
                                    ++n29;
                                }
                            }
                            if (n29 < this.vtdSize) {
                                n30 = this.getTokenType(n29);
                                int n31 = this.getTokenDepth(n29);
                                if (n31 == -1) {
                                    this.LN = n29;
                                    return true;
                                }
                                this.atTerminal = false;
                                this.context[0] = 0;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    case 0: {
                        int n32;
                        if (this.atTerminal) {
                            int n33 = this.LN;
                            int n34 = this.getTokenType(this.LN);
                            if (n34 == 2) {
                                return false;
                            }
                            if (this.l1Buffer.size != 0) {
                                if (n33 < this.l1Buffer.upper32At(this.l1index)) {
                                    ++n33;
                                    if (n34 == 7) {
                                        ++n33;
                                    }
                                    if (n33 <= this.l1Buffer.upper32At(this.l1index)) {
                                        if (n33 == this.l1Buffer.upper32At(this.l1index)) {
                                            this.atTerminal = false;
                                            this.context[0] = 1;
                                            this.context[1] = n33;
                                            return true;
                                        }
                                        int n35 = this.getTokenDepth(n33);
                                        if (n35 != 0) {
                                            return false;
                                        }
                                        this.LN = n33;
                                        this.atTerminal = true;
                                        return true;
                                    }
                                    return false;
                                }
                                if (this.l1index < this.l1Buffer.size - 1) {
                                    ++this.l1index;
                                    if (n34 == 7) {
                                        ++n33;
                                    }
                                    if (n33 <= this.l1Buffer.upper32At(this.l1index)) {
                                        if (n33 == this.l1Buffer.upper32At(this.l1index)) {
                                            this.atTerminal = false;
                                            this.context[0] = 1;
                                            this.context[1] = n33;
                                            return true;
                                        }
                                        int n36 = this.getTokenDepth(n33);
                                        if (n36 != 0) {
                                            return false;
                                        }
                                        this.LN = n33;
                                        this.atTerminal = true;
                                        return true;
                                    }
                                    return false;
                                }
                                ++n33;
                                if (n34 == 7) {
                                    ++n33;
                                }
                                if (n33 < this.vtdSize) {
                                    int n37 = this.getTokenDepth(n33);
                                    if (n37 != 0) {
                                        return false;
                                    }
                                    this.LN = n33;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            ++n33;
                            if (n34 == 7) {
                                ++n33;
                            }
                            if (n33 < this.vtdSize) {
                                int n38 = this.getTokenDepth(n33);
                                if (n38 != 0) {
                                    return false;
                                }
                                this.LN = n33;
                                this.atTerminal = true;
                                return true;
                            }
                            return false;
                        }
                        int n39 = -2;
                        for (n32 = this.vtdSize - 1; n32 > this.rootIndex && (n39 = this.getTokenDepth(n32)) == -1; --n32) {
                        }
                        if (++n32 >= this.vtdSize) {
                            return false;
                        }
                        this.context[0] = -1;
                        this.LN = n32;
                        this.atTerminal = true;
                        return true;
                    }
                    case 1: {
                        int n40;
                        if (this.atTerminal) {
                            int n41 = this.getTokenType(this.LN);
                            if (n41 == 2) {
                                return false;
                            }
                            if (this.l1Buffer.lower32At(this.l1index) != -1) {
                                if (this.LN < this.l2Buffer.upper32At(this.l2upper)) {
                                    int n42 = this.l2Buffer.upper32At(this.l2index);
                                    int n43 = this.LN + 1;
                                    if (n41 == 7) {
                                        ++n43;
                                    }
                                    if (n43 < n42) {
                                        this.LN = n43;
                                        return true;
                                    }
                                    this.context[0] = 2;
                                    this.context[2] = n42;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int n44 = this.LN + 1;
                                if (n41 == 7) {
                                    ++n44;
                                }
                                if (n44 < this.vtdSize) {
                                    int n45 = this.getTokenDepth(n44);
                                    if (n45 == 1 && this.getTokenType(n44) != 0) {
                                        this.LN = n44;
                                        this.atTerminal = true;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int n46 = this.LN + 1;
                            if (this.getTokenType(this.LN) == 7) {
                                ++n46;
                            }
                            if (n46 < this.vtdSize) {
                                int n47 = this.getTokenDepth(n46);
                                if (n47 == 1 && this.getTokenType(n46) != 0) {
                                    this.LN = n46;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l1index != this.l1Buffer.size - 1) {
                            int n48;
                            ++this.l1index;
                            int n49 = n48 = this.l1Buffer.upper32At(this.l1index) - 1;
                            while (this.getTokenDepth(n49) == 0) {
                                --n49;
                            }
                            if (n48 == n49) {
                                this.atTerminal = false;
                                this.context[0] = 1;
                                this.context[1] = n49 + 1;
                                return true;
                            }
                            this.atTerminal = true;
                            this.context[0] = 0;
                            this.LN = n49 + 1;
                            return true;
                        }
                        for (n40 = this.vtdSize - 1; n40 > this.l1Buffer.upper32At(this.l1index) && this.getTokenDepth(n40) <= 0; --n40) {
                        }
                        if (n40 == this.vtdSize - 1) {
                            if (this.getTokenDepth(n40) == 0) {
                                this.context[0] = 0;
                                this.LN = n40;
                                this.atTerminal = true;
                                return true;
                            }
                            return false;
                        }
                        if (this.getTokenDepth(++n40) == 0) {
                            this.context[0] = 0;
                            this.LN = n40;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    case 2: {
                        int n50;
                        if (this.atTerminal) {
                            int n51 = this.getTokenType(this.LN);
                            if (n51 == 2) {
                                return false;
                            }
                            if (this.l2Buffer.lower32At(this.l2index) != -1) {
                                if (this.LN < this.l3Buffer.upper32At(this.l3upper)) {
                                    int n52 = this.l3Buffer.upper32At(this.l3index);
                                    int n53 = this.LN + 1;
                                    if (n51 == 7) {
                                        ++n53;
                                    }
                                    if (n53 < n52) {
                                        this.LN = n53;
                                        return true;
                                    }
                                    this.context[0] = 3;
                                    this.context[3] = n52;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int n54 = this.LN + 1;
                                if (n51 == 7) {
                                    ++n54;
                                }
                                if (n54 < this.vtdSize) {
                                    int n55 = this.getTokenDepth(n54);
                                    if (n55 == 2 && this.getTokenType(n54) != 0) {
                                        this.LN = n54;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int n56 = this.LN + 1;
                            if (n51 == 7) {
                                ++n56;
                            }
                            if (n56 < this.vtdSize) {
                                int n57 = this.getTokenDepth(n56);
                                if (n57 == 2 && this.getTokenType(n56) != 0) {
                                    this.LN = n56;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l2index < this.l2upper) {
                            int n58;
                            int n59 = this.l2Buffer.upper32At(this.l2index);
                            ++this.l2index;
                            int n60 = n58 = this.l2Buffer.upper32At(this.l2index) - 1;
                            block111: while (n58 > n59 && this.getTokenDepth(n58) == 1) {
                                int n61 = this.getTokenType(n58);
                                switch (n61) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --n58;
                                        continue block111;
                                    }
                                    case 8: {
                                        n58 -= 2;
                                        continue block111;
                                    }
                                }
                            }
                            if (n58 == n60) {
                                this.context[0] = 2;
                                this.context[2] = n58 + 1;
                                return true;
                            }
                            this.context[0] = 1;
                            this.LN = n58 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int n62 = n50 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            n62 = n50 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        int n63 = this.l2Buffer.upper32At(this.l2index);
                        while (n50 > n63 && this.getTokenDepth(n50) < 2) {
                            --n50;
                        }
                        if (this.getTokenDepth(n50) == 1) {
                            this.LN = n50;
                            this.atTerminal = true;
                            this.context[0] = 1;
                            return true;
                        }
                        if (n62 != n50 && this.getTokenDepth(n50 + 1) == 1) {
                            this.LN = n50 + 1;
                            this.atTerminal = true;
                            this.context[0] = 1;
                            return true;
                        }
                        return false;
                    }
                    case 3: {
                        int n64;
                        if (this.atTerminal) {
                            int n65 = this.getTokenType(this.LN);
                            if (n65 == 2) {
                                return false;
                            }
                            if (this.l3Buffer.lower32At(this.l3index) != -1) {
                                if (this.LN < this.l4Buffer.upper32At(this.l4upper)) {
                                    int n66 = this.l4Buffer.upper32At(this.l4index);
                                    int n67 = this.LN + 1;
                                    if (n65 == 7) {
                                        ++n67;
                                    }
                                    if (n67 < n66) {
                                        this.LN = n67;
                                        return true;
                                    }
                                    this.context[0] = 4;
                                    this.context[4] = n66;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int n68 = this.LN + 1;
                                if (n65 == 7) {
                                    ++n68;
                                }
                                if (n68 < this.vtdSize) {
                                    int n69 = this.getTokenDepth(n68);
                                    if (n69 == 3 && this.getTokenType(n68) != 0) {
                                        this.LN = n68;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int n70 = this.LN + 1;
                            if (n65 == 7) {
                                ++n70;
                            }
                            if (n70 < this.vtdSize) {
                                int n71 = this.getTokenDepth(n70);
                                if (n71 == 3 && this.getTokenType(n70) != 0) {
                                    this.LN = n70;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l3index < this.l3upper) {
                            int n72;
                            int n73 = this.l3Buffer.upper32At(this.l3index);
                            ++this.l3index;
                            int n74 = n72 = this.l3Buffer.upper32At(this.l3index) - 1;
                            block113: while (n72 > n73 && this.getTokenDepth(n72) == 2) {
                                int n75 = this.getTokenType(n72);
                                switch (n75) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --n72;
                                        continue block113;
                                    }
                                    case 8: {
                                        n72 -= 2;
                                        continue block113;
                                    }
                                }
                            }
                            if (n72 == n74) {
                                this.context[0] = 3;
                                this.context[3] = n72 + 1;
                                return true;
                            }
                            this.context[0] = 2;
                            this.LN = n72 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int n76 = n64 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            n76 = n64 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                            n76 = n64 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                        }
                        int n77 = this.l3Buffer.upper32At(this.l3index);
                        while (n64 > n77 && this.getTokenDepth(n64) < 3) {
                            --n64;
                        }
                        if (this.getTokenDepth(n64) == 2) {
                            this.LN = n64;
                            this.atTerminal = true;
                            this.context[0] = 2;
                            return true;
                        }
                        if (n76 != n64 && this.getTokenDepth(n64 + 1) == 2) {
                            this.LN = n64 + 1;
                            this.atTerminal = true;
                            this.context[0] = 2;
                            return true;
                        }
                        return false;
                    }
                    case 4: {
                        int n78;
                        if (this.atTerminal) {
                            int n79 = this.getTokenType(this.LN);
                            if (n79 == 2) {
                                return false;
                            }
                            if (this.l4Buffer.lower32At(this.l4index) != -1) {
                                if (this.LN < this.l5Buffer.intAt(this.l5upper)) {
                                    int n80 = this.l5Buffer.intAt(this.l5index);
                                    int n81 = this.LN + 1;
                                    if (n79 == 7) {
                                        ++n81;
                                    }
                                    if (n81 < n80) {
                                        this.LN = n81;
                                        return true;
                                    }
                                    this.context[0] = 5;
                                    this.context[5] = n80;
                                    this.atTerminal = false;
                                    return true;
                                }
                                int n82 = this.LN + 1;
                                if (n79 == 7) {
                                    ++n82;
                                }
                                if (n82 < this.vtdSize) {
                                    int n83 = this.getTokenDepth(n82);
                                    if (n83 == 4 && this.getTokenType(n82) != 0) {
                                        this.LN = n82;
                                        return true;
                                    }
                                    return false;
                                }
                                return false;
                            }
                            int n84 = this.LN + 1;
                            if (n79 == 7) {
                                ++n84;
                            }
                            if (n84 < this.vtdSize) {
                                int n85 = this.getTokenDepth(n84);
                                if (n85 == 4 && this.getTokenType(n84) != 0) {
                                    this.LN = n84;
                                    this.atTerminal = true;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        if (this.l4index < this.l4upper) {
                            int n86;
                            int n87 = this.l4Buffer.upper32At(this.l4index);
                            ++this.l4index;
                            int n88 = n86 = this.l4Buffer.upper32At(this.l4index) - 1;
                            block115: while (n86 > n87 && this.getTokenDepth(n86) == 3) {
                                int n89 = this.getTokenType(n86);
                                switch (n89) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --n86;
                                        continue block115;
                                    }
                                    case 8: {
                                        n86 -= 2;
                                        continue block115;
                                    }
                                }
                            }
                            if (n86 == n88) {
                                this.context[0] = 4;
                                this.context[4] = n86 + 1;
                                return true;
                            }
                            this.context[0] = 3;
                            this.LN = n86 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int n90 = n78 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            n90 = n78 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                            n90 = n78 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                        }
                        if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                            n90 = n78 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                        }
                        int n91 = this.l4Buffer.upper32At(this.l4index);
                        while (n78 > n91 && this.getTokenDepth(n78) < 4) {
                            --n78;
                        }
                        if (this.getTokenDepth(n78) == 3) {
                            this.LN = n78;
                            this.atTerminal = true;
                            this.context[0] = 3;
                            return true;
                        }
                        if (n90 != n78 && this.getTokenDepth(n78 + 1) == 3) {
                            this.LN = n78 + 1;
                            this.atTerminal = true;
                            this.context[0] = 3;
                            return true;
                        }
                        return false;
                    }
                    case 5: {
                        int n92;
                        if (this.atTerminal) break;
                        if (this.l5index < this.l5upper) {
                            int n93;
                            int n94 = this.l5Buffer.intAt(this.l5index);
                            ++this.l5index;
                            int n95 = n93 = this.l5Buffer.intAt(this.l5index) - 1;
                            block117: while (n93 > n94 && this.getTokenDepth(n93) == 4) {
                                int n96 = this.getTokenType(n93);
                                switch (n96) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        --n93;
                                        continue block117;
                                    }
                                    case 8: {
                                        n93 -= 2;
                                        continue block117;
                                    }
                                }
                            }
                            if (n93 == n95) {
                                this.context[0] = 5;
                                this.context[5] = n93 + 1;
                                return true;
                            }
                            this.context[0] = 4;
                            this.LN = n93 + 1;
                            this.atTerminal = true;
                            return true;
                        }
                        int n97 = n92 = this.vtdSize - 1;
                        if (this.l1index != this.l1Buffer.size - 1) {
                            n97 = n92 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                        }
                        if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                            n97 = n92 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                        }
                        if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                            n97 = n92 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                        }
                        if (this.l4index != this.l4Buffer.size - 1 && this.l4index != this.l4upper) {
                            n97 = n92 = this.l4Buffer.upper32At(this.l4index + 1) - 1;
                        }
                        int n98 = this.l5Buffer.intAt(this.l5index);
                        while (n92 > n98 && this.getTokenDepth(n92) < 5) {
                            --n92;
                        }
                        if (this.getTokenDepth(n92) == 4) {
                            this.LN = n92;
                            this.atTerminal = true;
                            this.context[0] = 4;
                            return true;
                        }
                        if (n97 != n92 && this.getTokenDepth(n92 + 1) == 4) {
                            this.LN = n92 + 1;
                            this.atTerminal = true;
                            this.context[0] = 4;
                            return true;
                        }
                        return false;
                    }
                }
                if (this.atTerminal) {
                    n28 = this.getTokenType(this.LN);
                    if (n28 == 2) {
                        return false;
                    }
                    n27 = this.LN + 1;
                    n26 = this.context[0] + 1;
                } else {
                    n27 = this.context[this.context[0]] + 1;
                    n26 = this.context[0];
                }
                block119: while (n27 < this.vtdSize) {
                    long l = this.vtdBuffer.longAt(n27);
                    n28 = (int)((0xF000000000000000L & l) >>> 60);
                    int n99 = (int)((0xFF0000000000000L & l) >> 52);
                    switch (n28) {
                        case 0: {
                            if (n99 < n26) {
                                return false;
                            }
                            if (n99 == n26) {
                                this.context[0] = n26;
                                this.context[this.context[0]] = n27;
                                this.atTerminal = false;
                                return true;
                            }
                            ++n27;
                            continue block119;
                        }
                        case 2: 
                        case 3: {
                            n27 += 2;
                            continue block119;
                        }
                        case 5: 
                        case 6: 
                        case 11: {
                            if (n99 < n26 - 1) {
                                return false;
                            }
                            if (n99 == n26 - 1) {
                                this.context[0] = n26 - 1;
                                this.LN = n27;
                                this.atTerminal = true;
                                return true;
                            }
                            ++n27;
                            continue block119;
                        }
                        case 7: {
                            if (n99 < n26 - 1) {
                                return false;
                            }
                            if (n99 == n26 - 1) {
                                this.context[0] = n26 - 1;
                                this.LN = n27;
                                this.atTerminal = true;
                                return true;
                            }
                            n27 += 2;
                            continue block119;
                        }
                    }
                    ++n27;
                }
                return false;
            }
            case 5: {
                return this.toNode_PrevSibling();
            }
        }
        throw new NavException("illegal navigation options");
    }

    @Override
    protected boolean toNode_PrevSibling() {
        int n;
        int n2;
        switch (this.context[0]) {
            case -1: {
                if (this.atTerminal) {
                    int n3 = this.LN - 1;
                    if (n3 > 0) {
                        int n4 = this.getTokenDepth(n3);
                        if (n4 == -1) {
                            int n5 = this.getTokenType(n3);
                            switch (n5) {
                                case 8: {
                                    --n3;
                                }
                                case 6: {
                                    this.LN = n3;
                                    return true;
                                }
                            }
                            return false;
                        }
                        this.context[0] = 0;
                        this.atTerminal = false;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            case 0: {
                if (this.atTerminal) {
                    if (this.l1Buffer.size != 0) {
                        if (this.LN < this.l1Buffer.upper32At(this.l1index)) {
                            int n6 = this.LN - 1;
                            if (n6 > this.rootIndex) {
                                int n7 = this.getTokenType(n6);
                                int n8 = this.getTokenDepth(n6);
                                if (n8 == 0) {
                                    switch (n7) {
                                        case 5: 
                                        case 6: 
                                        case 11: {
                                            this.LN = n6;
                                            return true;
                                        }
                                        case 8: {
                                            this.LN = n6 - 1;
                                            return true;
                                        }
                                    }
                                }
                                if (this.l1index == 0) {
                                    return false;
                                }
                                --this.l1index;
                                this.atTerminal = false;
                                this.context[0] = 1;
                                this.context[1] = this.l1Buffer.upper32At(this.l1index);
                                return true;
                            }
                            return false;
                        }
                        int n9 = this.LN - 1;
                        if (n9 > this.l1Buffer.upper32At(this.l1index)) {
                            int n10 = this.getTokenType(n9);
                            int n11 = this.getTokenDepth(n9);
                            if (n11 == 0) {
                                switch (n10) {
                                    case 5: 
                                    case 6: 
                                    case 11: {
                                        this.LN = n9;
                                        return true;
                                    }
                                    case 8: {
                                        this.LN = n9 - 1;
                                        return true;
                                    }
                                }
                            }
                        }
                        this.atTerminal = false;
                        this.context[0] = 1;
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    int n12 = this.LN - 1;
                    if (n12 > this.rootIndex) {
                        int n13 = this.getTokenType(n12);
                        switch (n13) {
                            case 8: {
                                --n12;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = n12;
                                this.atTerminal = true;
                                this.context[0] = 0;
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                }
                int n14 = this.rootIndex - 1;
                if (n14 > 0) {
                    int n15 = this.getTokenType(n14);
                    switch (n15) {
                        case 8: {
                            --n14;
                        }
                        case 6: {
                            this.LN = n14;
                            this.atTerminal = true;
                            this.context[0] = -1;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 1: {
                if (this.atTerminal) {
                    if (this.l1Buffer.lower32At(this.l1index) != -1) {
                        int n16 = this.l2Buffer.upper32At(this.l2index);
                        if (this.LN > n16) {
                            int n17 = this.LN - 1;
                            if (this.getTokenType(n17) == 8) {
                                --n17;
                            }
                            if (this.getTokenDepth(n17) == 1) {
                                this.LN = n17;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 2;
                            this.context[2] = n16;
                            return true;
                        }
                        if (this.l2index != this.l2lower) {
                            --this.l2index;
                            this.atTerminal = false;
                            this.context[0] = 2;
                            this.context[2] = this.l2Buffer.upper32At(this.l2index);
                            return true;
                        }
                        int n18 = this.LN - 1;
                        int n19 = this.getTokenType(n18);
                        switch (n19) {
                            case 8: {
                                --n18;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = n18;
                                this.atTerminal = true;
                                this.context[0] = 1;
                                return true;
                            }
                        }
                        return false;
                    }
                    int n20 = this.LN - 1;
                    if (this.getTokenType(n20) == 8) {
                        --n20;
                    }
                    if (n20 > this.context[1]) {
                        int n21 = this.getTokenType(n20);
                        if (n21 != 4) {
                            this.LN = n20;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int n22 = this.context[1] - 1;
                int n23 = this.getTokenType(n22);
                if (this.getTokenDepth(n22) == 0 && n23 != 4 && n23 != 0) {
                    if (n23 == 8) {
                        --n22;
                    }
                    this.context[0] = 0;
                    this.atTerminal = true;
                    this.LN = n22;
                    return true;
                }
                if (this.l1index != 0) {
                    --this.l1index;
                    this.context[1] = this.l1Buffer.upper32At(this.l1index);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.atTerminal) {
                    if (this.l2Buffer.lower32At(this.l2index) != -1) {
                        int n24 = this.l3Buffer.upper32At(this.l3index);
                        if (this.LN > n24) {
                            int n25 = this.LN - 1;
                            if (this.getTokenType(n25) == 8) {
                                --n25;
                            }
                            if (this.getTokenDepth(n25) == 2) {
                                this.LN = n25;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 3;
                            this.context[3] = n24;
                            return true;
                        }
                        if (this.l3index != this.l3lower) {
                            --this.l3index;
                            this.atTerminal = false;
                            this.context[0] = 3;
                            this.context[3] = this.l3Buffer.upper32At(this.l3index);
                            return true;
                        }
                        int n26 = this.LN - 1;
                        int n27 = this.getTokenType(n26);
                        switch (n27) {
                            case 8: {
                                --n26;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = n26;
                                this.atTerminal = true;
                                this.context[0] = 2;
                                return true;
                            }
                        }
                        return false;
                    }
                    int n28 = this.LN - 1;
                    if (this.getTokenType(n28) == 8) {
                        --n28;
                    }
                    if (n28 > this.context[2]) {
                        int n29 = this.getTokenType(n28);
                        if (n29 != 4) {
                            this.LN = n28;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int n30 = this.context[2] - 1;
                int n31 = this.getTokenType(n30);
                if (this.getTokenDepth(n30) == 1 && n31 != 4 && n31 != 0) {
                    if (n31 == 8) {
                        --n30;
                    }
                    this.context[0] = 1;
                    this.atTerminal = true;
                    this.LN = n30;
                    return true;
                }
                if (this.l2index != this.l2lower) {
                    --this.l2index;
                    this.context[2] = this.l2Buffer.upper32At(this.l2index);
                    return true;
                }
                return false;
            }
            case 3: {
                if (this.atTerminal) {
                    if (this.l3Buffer.lower32At(this.l3index) != -1) {
                        int n32 = this.l4Buffer.upper32At(this.l4index);
                        if (this.LN > n32) {
                            int n33 = this.LN - 1;
                            if (this.getTokenType(n33) == 8) {
                                --n33;
                            }
                            if (this.getTokenDepth(n33) == 3) {
                                this.LN = n33;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 4;
                            this.context[4] = n32;
                            return true;
                        }
                        if (this.l4index != this.l4lower) {
                            --this.l4index;
                            this.atTerminal = false;
                            this.context[0] = 4;
                            this.context[4] = this.l4Buffer.upper32At(this.l4index);
                            return true;
                        }
                        int n34 = this.LN - 1;
                        int n35 = this.getTokenType(n34);
                        switch (n35) {
                            case 8: {
                                --n34;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = n34;
                                this.atTerminal = true;
                                this.context[0] = 3;
                                return true;
                            }
                        }
                        return false;
                    }
                    int n36 = this.LN - 1;
                    if (this.getTokenType(n36) == 8) {
                        --n36;
                    }
                    if (n36 > this.context[3]) {
                        int n37 = this.getTokenType(n36);
                        if (n37 != 4) {
                            this.LN = n36;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int n38 = this.context[3] - 1;
                int n39 = this.getTokenType(n38);
                if (this.getTokenDepth(n38) == 2 && n39 != 4 && n39 != 0) {
                    if (n39 == 8) {
                        --n38;
                    }
                    this.context[0] = 2;
                    this.atTerminal = true;
                    this.LN = n38;
                    return true;
                }
                if (this.l3index != this.l3lower) {
                    --this.l3index;
                    this.context[3] = this.l3Buffer.upper32At(this.l3index);
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.atTerminal) {
                    if (this.l4Buffer.lower32At(this.l4index) != -1) {
                        int n40 = this.l5Buffer.intAt(this.l5index);
                        if (this.LN > n40) {
                            int n41 = this.LN - 1;
                            if (this.getTokenType(n41) == 8) {
                                --n41;
                            }
                            if (this.getTokenDepth(n41) == 4) {
                                this.LN = n41;
                                return true;
                            }
                            this.atTerminal = false;
                            this.context[0] = 5;
                            this.context[5] = n40;
                            return true;
                        }
                        if (this.l5index != this.l5lower) {
                            --this.l5index;
                            this.atTerminal = false;
                            this.context[0] = 5;
                            this.context[5] = this.l5Buffer.intAt(this.l5index);
                            return true;
                        }
                        int n42 = this.LN - 1;
                        int n43 = this.getTokenType(n42);
                        switch (n43) {
                            case 8: {
                                --n42;
                            }
                            case 5: 
                            case 6: 
                            case 11: {
                                this.LN = n42;
                                this.atTerminal = true;
                                this.context[0] = 4;
                                return true;
                            }
                        }
                        return false;
                    }
                    int n44 = this.LN - 1;
                    if (this.getTokenType(n44) == 8) {
                        --n44;
                    }
                    if (n44 > this.context[4]) {
                        int n45 = this.getTokenType(n44);
                        if (n45 != 4) {
                            this.LN = n44;
                            this.atTerminal = true;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                int n46 = this.context[4] - 1;
                int n47 = this.getTokenType(n46);
                if (this.getTokenDepth(n46) == 3 && n47 != 4 && n47 != 0) {
                    if (n47 == 8) {
                        --n46;
                    }
                    this.context[0] = 3;
                    this.atTerminal = true;
                    this.LN = n46;
                    return true;
                }
                if (this.l4index != this.l4lower) {
                    --this.l4index;
                    this.context[4] = this.l4Buffer.upper32At(this.l4index);
                    return true;
                }
                return false;
            }
            case 5: {
                if (this.atTerminal) break;
                int n48 = this.context[5] - 1;
                int n49 = this.getTokenType(n48);
                if (this.getTokenDepth(n48) == 4 && n49 != 4 && n49 != 0) {
                    if (n49 == 8) {
                        --n48;
                    }
                    this.context[0] = 4;
                    this.atTerminal = true;
                    this.LN = n48;
                    return true;
                }
                if (this.l5index != this.l5lower) {
                    --this.l5index;
                    this.context[5] = this.l5Buffer.intAt(this.l5index);
                    return true;
                }
                return false;
            }
        }
        if (this.atTerminal) {
            n2 = this.LN - 1;
            n = this.context[0] + 1;
        } else {
            n2 = this.context[this.context[0]] - 1;
            n = this.context[0];
        }
        block51: while (n2 > this.context[n - 1]) {
            long l = this.vtdBuffer.longAt(n2);
            int n50 = (int)((0xF000000000000000L & l) >>> 60);
            int n51 = (int)((0xFF0000000000000L & l) >> 52);
            switch (n50) {
                case 0: {
                    if (n51 == n) {
                        this.context[0] = n;
                        this.context[this.context[0]] = n2;
                        this.atTerminal = false;
                        return true;
                    }
                    --n2;
                    continue block51;
                }
                case 4: {
                    n2 -= 2;
                    continue block51;
                }
                case 5: 
                case 6: 
                case 11: {
                    if (n51 == n - 1) {
                        this.context[0] = n - 1;
                        this.LN = n2;
                        this.atTerminal = true;
                        return true;
                    }
                    --n2;
                    continue block51;
                }
                case 8: {
                    if (n51 == n - 1) {
                        this.context[0] = n - 1;
                        this.LN = n2 - 1;
                        this.atTerminal = true;
                        return true;
                    }
                    n2 -= 2;
                    continue block51;
                }
            }
            --n2;
        }
        return false;
    }

    @Override
    protected boolean toNode_LastChild() {
        switch (this.context[0]) {
            case -1: {
                int n = this.vtdSize - 1;
                int n2 = this.getTokenType(n);
                int n3 = this.getTokenDepth(n);
                if (n3 == -1) {
                    switch (n2) {
                        case 6: {
                            this.LN = n;
                            this.atTerminal = true;
                            return true;
                        }
                        case 8: {
                            this.LN = n - 1;
                            this.atTerminal = true;
                            return true;
                        }
                    }
                }
                this.context[0] = 0;
                return true;
            }
            case 0: {
                if (this.l1Buffer.size != 0) {
                    int n = this.l1Buffer.upper32At(this.l1Buffer.size - 1);
                    for (int i = this.vtdSize - 1; i > n; --i) {
                        int n4 = this.getTokenDepth(i);
                        if (n4 == -1) {
                            continue;
                        }
                        if (n4 == 0) {
                            int n5 = this.getTokenType(i);
                            switch (n5) {
                                case 5: 
                                case 6: 
                                case 11: {
                                    this.LN = i;
                                    this.atTerminal = true;
                                    this.l1index = this.l1Buffer.size - 1;
                                    return true;
                                }
                                case 8: {
                                    this.LN = i - 1;
                                    this.atTerminal = true;
                                    this.l1index = this.l1Buffer.size - 1;
                                    return true;
                                }
                            }
                            return false;
                        }
                        this.l1index = this.l1Buffer.size - 1;
                        this.context[0] = 1;
                        this.context[1] = n;
                        return true;
                    }
                    this.l1index = this.l1Buffer.size - 1;
                    this.context[0] = 1;
                    this.context[1] = n;
                    return true;
                }
                for (int i = this.vtdSize - 1; i > this.rootIndex; --i) {
                    int n = this.getTokenDepth(i);
                    if (n == -1) {
                        continue;
                    }
                    int n6 = this.getTokenType(i);
                    switch (n6) {
                        case 5: 
                        case 6: 
                        case 11: {
                            this.LN = i;
                            this.atTerminal = true;
                            return true;
                        }
                        case 8: {
                            this.LN = i - 1;
                            this.atTerminal = true;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 1: {
                int n;
                int n7;
                if (this.l1Buffer.lower32At(this.l1index) != -1) {
                    int n8;
                    this.l2lower = this.l1Buffer.lower32At(this.l1index);
                    for (n8 = this.l1index + 1; n8 < this.l1Buffer.size; ++n8) {
                        if (this.l1Buffer.lower32At(n8) == -1) continue;
                        this.l2upper = this.l1Buffer.lower32At(n8) - 1;
                        break;
                    }
                    if (n8 == this.l1Buffer.size) {
                        this.l2upper = this.l2Buffer.size - 1;
                    }
                    this.l2index = this.l2upper;
                    int n9 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        n9 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    n8 = this.l2Buffer.upper32At(this.l2index);
                    while (n9 > n8) {
                        int n10 = this.getTokenDepth(n9);
                        if (n10 < 1) {
                            --n9;
                            continue;
                        }
                        if (n10 != 1) break;
                        int n11 = this.getTokenType(n9);
                        this.LN = n11 == 8 ? n9 - 1 : n9;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 2;
                    this.context[2] = n8;
                    return true;
                }
                block58: for (n7 = this.context[1] + 1; n7 < this.vtdSize; n7 += 2) {
                    n = this.getTokenType(n7);
                    switch (n) {
                        case 2: 
                        case 3: {
                            continue block58;
                        }
                    }
                }
                if (n7 < this.vtdSize && this.getTokenDepth(n7) == 1 && this.getTokenType(n7) != 0) {
                    int n12 = n7++;
                    block59: while (n7 < this.vtdSize) {
                        n = this.getTokenType(n7);
                        int n13 = this.getTokenDepth(n7);
                        if (n13 != 1) break;
                        switch (n) {
                            case 5: 
                            case 6: 
                            case 11: {
                                n12 = n7++;
                                continue block59;
                            }
                            case 7: {
                                n12 = n7;
                                n7 += 2;
                                continue block59;
                            }
                        }
                    }
                    this.LN = n12;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
            case 2: {
                int n;
                int n14;
                if (this.l2Buffer.lower32At(this.l2index) != -1) {
                    int n15;
                    this.l3lower = this.l2Buffer.lower32At(this.l2index);
                    for (n15 = this.l2index + 1; n15 < this.l2Buffer.size; ++n15) {
                        if (this.l2Buffer.lower32At(n15) == -1) continue;
                        this.l3upper = this.l2Buffer.lower32At(n15) - 1;
                        break;
                    }
                    if (n15 == this.l2Buffer.size) {
                        this.l3upper = this.l3Buffer.size - 1;
                    }
                    this.l3index = this.l3upper;
                    int n16 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        n16 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                        n16 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                    }
                    n15 = this.l3Buffer.upper32At(this.l3index);
                    while (n16 > n15) {
                        int n17 = this.getTokenDepth(n16);
                        if (n17 < 2) {
                            --n16;
                            continue;
                        }
                        if (n17 != 2) break;
                        int n18 = this.getTokenType(n16);
                        this.LN = n18 == 8 ? n16 - 1 : n16;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 3;
                    this.context[3] = n15;
                    return true;
                }
                block62: for (n14 = this.context[2] + 1; n14 < this.vtdSize; n14 += 2) {
                    n = this.getTokenType(n14);
                    switch (n) {
                        case 2: 
                        case 3: {
                            continue block62;
                        }
                    }
                }
                if (n14 < this.vtdSize && this.getTokenDepth(n14) == 2 && this.getTokenType(n14) != 0) {
                    int n19 = n14++;
                    block63: while (n14 < this.vtdSize) {
                        n = this.getTokenType(n14);
                        int n20 = this.getTokenDepth(n14);
                        if (n20 != 2) break;
                        switch (n) {
                            case 5: 
                            case 6: 
                            case 11: {
                                n19 = n14++;
                                continue block63;
                            }
                            case 7: {
                                n19 = n14;
                                n14 += 2;
                                continue block63;
                            }
                        }
                    }
                    this.LN = n19;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
            case 3: {
                int n;
                int n21;
                if (this.l3Buffer.lower32At(this.l3index) != -1) {
                    int n22;
                    this.l4lower = this.l3Buffer.lower32At(this.l3index);
                    for (n22 = this.l3index + 1; n22 < this.l3Buffer.size; ++n22) {
                        if (this.l3Buffer.lower32At(n22) == -1) continue;
                        this.l4upper = this.l3Buffer.lower32At(n22) - 1;
                        break;
                    }
                    if (n22 == this.l3Buffer.size) {
                        this.l4upper = this.l4Buffer.size - 1;
                    }
                    this.l4index = this.l4upper;
                    int n23 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        n23 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                        n23 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                    }
                    if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                        n23 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                    }
                    n22 = this.l4Buffer.upper32At(this.l4index);
                    while (n23 > n22) {
                        int n24 = this.getTokenDepth(n23);
                        if (n24 < 3) {
                            --n23;
                            continue;
                        }
                        if (n24 != 3) break;
                        int n25 = this.getTokenType(n23);
                        this.LN = n25 == 8 ? n23 - 1 : n23;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 4;
                    this.context[4] = n22;
                    return true;
                }
                block66: for (n21 = this.context[3] + 1; n21 < this.vtdSize; n21 += 2) {
                    n = this.getTokenType(n21);
                    switch (n) {
                        case 2: 
                        case 3: {
                            continue block66;
                        }
                    }
                }
                if (n21 < this.vtdSize && this.getTokenDepth(n21) == 3 && this.getTokenType(n21) != 0) {
                    int n26 = n21++;
                    block67: while (n21 < this.vtdSize) {
                        n = this.getTokenType(n21);
                        int n27 = this.getTokenDepth(n21);
                        if (n27 != 3) break;
                        switch (n) {
                            case 5: 
                            case 6: 
                            case 11: {
                                n26 = n21++;
                                continue block67;
                            }
                            case 7: {
                                n26 = n21;
                                n21 += 2;
                                continue block67;
                            }
                        }
                    }
                    this.LN = n26;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
            case 4: {
                int n;
                int n28;
                if (this.l4Buffer.lower32At(this.l4index) != -1) {
                    int n29;
                    this.l5lower = this.l4Buffer.lower32At(this.l4index);
                    for (n29 = this.l4index + 1; n29 < this.l4Buffer.size; ++n29) {
                        if (this.l4Buffer.lower32At(n29) == -1) continue;
                        this.l5upper = this.l4Buffer.lower32At(n29) - 1;
                        break;
                    }
                    if (n29 == this.l4Buffer.size) {
                        this.l5upper = this.l5Buffer.size - 1;
                    }
                    this.l5index = this.l5upper;
                    int n30 = this.vtdSize - 1;
                    if (this.l1index != this.l1Buffer.size - 1) {
                        n30 = this.l1Buffer.upper32At(this.l1index + 1) - 1;
                    }
                    if (this.l2index != this.l2Buffer.size - 1 && this.l2index != this.l2upper) {
                        n30 = this.l2Buffer.upper32At(this.l2index + 1) - 1;
                    }
                    if (this.l3index != this.l3Buffer.size - 1 && this.l3index != this.l3upper) {
                        n30 = this.l3Buffer.upper32At(this.l3index + 1) - 1;
                    }
                    if (this.l4index != this.l4Buffer.size - 1 && this.l4index != this.l4upper) {
                        n30 = this.l4Buffer.upper32At(this.l4index + 1) - 1;
                    }
                    n29 = this.l5Buffer.intAt(this.l5index);
                    while (n30 > n29) {
                        int n31 = this.getTokenDepth(n30);
                        if (n31 < 4) {
                            --n30;
                            continue;
                        }
                        if (n31 != 4) break;
                        int n32 = this.getTokenType(n30);
                        this.LN = n32 == 8 ? n30 - 1 : n30;
                        this.atTerminal = true;
                        return true;
                    }
                    this.context[0] = 5;
                    this.context[5] = n29;
                    return true;
                }
                block70: for (n28 = this.context[4] + 1; n28 < this.vtdSize; n28 += 2) {
                    n = this.getTokenType(n28);
                    switch (n) {
                        case 2: 
                        case 3: {
                            continue block70;
                        }
                    }
                }
                if (n28 < this.vtdSize && this.getTokenDepth(n28) == 4 && this.getTokenType(n28) != 0) {
                    int n33 = n28++;
                    block71: while (n28 < this.vtdSize) {
                        n = this.getTokenType(n28);
                        int n34 = this.getTokenDepth(n28);
                        if (n34 != 4) break;
                        switch (n) {
                            case 5: 
                            case 6: 
                            case 11: {
                                n33 = n28++;
                                continue block71;
                            }
                            case 7: {
                                n33 = n28;
                                n28 += 2;
                                continue block71;
                            }
                        }
                    }
                    this.LN = n33;
                    this.atTerminal = true;
                    return true;
                }
                return false;
            }
        }
        int n = this.context[this.context[0]] + 1;
        int n35 = -1;
        this.atTerminal = false;
        while (n < this.vtdBuffer.size) {
            long l = this.vtdBuffer.longAt(n);
            int n36 = (int)((0xF000000000000000L & l) >>> 60);
            int n37 = this.getTokenDepth(n);
            switch (n36) {
                case 0: {
                    if (n37 <= this.context[0]) {
                        if (n35 != -1) {
                            if (this.atTerminal) {
                                this.LN = n35;
                            } else {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = n35;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (n37 == this.context[0] + 1) {
                        n35 = n;
                        this.atTerminal = false;
                    }
                    ++n;
                    break;
                }
                case 2: 
                case 3: {
                    n += 2;
                    break;
                }
                case 5: 
                case 6: 
                case 11: {
                    if (n37 < this.context[0]) {
                        if (n35 != -1) {
                            if (this.atTerminal) {
                                this.LN = n35;
                            } else {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = n35;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (n37 == this.context[0]) {
                        n35 = n;
                        this.atTerminal = true;
                    }
                    ++n;
                    break;
                }
                case 7: {
                    if (n37 < this.context[0]) {
                        if (n35 != -1) {
                            if (this.atTerminal) {
                                this.LN = n35;
                            } else {
                                this.context[0] = this.context[0] + 1;
                                this.context[this.context[0]] = n35;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (n37 == this.context[0]) {
                        n35 = n;
                        this.atTerminal = true;
                    }
                    n += 2;
                }
            }
        }
        if (n35 != -1) {
            if (this.atTerminal) {
                this.LN = n35;
            } else {
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = n35;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyNodeCorrectness() {
        if (this.atTerminal) {
            int n;
            if (this.getTokenDepth(this.LN) != this.context[0]) {
                return false;
            }
            switch (this.context[0]) {
                case -1: {
                    return true;
                }
                case 0: {
                    if (this.l1Buffer.size != 0) {
                        if (this.l1index >= this.l1Buffer.size || this.l1index < 0) {
                            return false;
                        }
                        return this.l1index == this.l1Buffer.size - 1 || this.l1Buffer.upper32At(this.l1index) >= this.LN;
                    }
                    return true;
                }
                case 1: {
                    if (this.LN > this.context[1]) {
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int n2 = this.l1Buffer.lower32At(this.l1index);
                        if (n2 != -1) {
                            int n3 = this.l2Buffer.size - 1;
                            for (int i = this.l1index + 1; i < this.l1Buffer.size; ++i) {
                                if (this.l1Buffer.lower32At(i) == -1) continue;
                                n3 = this.l1Buffer.lower32At(i) - 1;
                                break;
                            }
                            if (n2 != this.l2lower) {
                                return false;
                            }
                            if (this.l2upper != n3) {
                                return false;
                            }
                            if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                                return false;
                            }
                            if (this.l2index != this.l2upper && this.l2Buffer.upper32At(this.l2index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                case 2: {
                    if (this.LN > this.context[2] && this.context[2] > this.context[1]) {
                        int n4;
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int n5 = this.l1Buffer.lower32At(this.l1index);
                        if (n5 == -1) {
                            return false;
                        }
                        if (n5 != this.l2lower) {
                            return false;
                        }
                        int n6 = this.l2Buffer.size - 1;
                        for (n4 = this.l1index + 1; n4 < this.l1Buffer.size; ++n4) {
                            if (this.l1Buffer.lower32At(n4) == -1) continue;
                            n6 = this.l1Buffer.lower32At(n4) - 1;
                            break;
                        }
                        if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                            return false;
                        }
                        if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                            return false;
                        }
                        n5 = this.l2Buffer.lower32At(this.l2index);
                        if (n5 != -1) {
                            if (this.l3lower != n5) {
                                return false;
                            }
                            n6 = this.l3Buffer.size - 1;
                            for (n4 = this.l2index + 1; n4 < this.l2Buffer.size; ++n4) {
                                if (this.l2Buffer.lower32At(n4) == -1) continue;
                                n6 = this.l2Buffer.lower32At(n4) - 1;
                                break;
                            }
                            if (this.l3lower != n5) {
                                return false;
                            }
                            if (this.l3upper != n6) {
                                return false;
                            }
                            if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                                return false;
                            }
                            if (this.l3index != this.l3upper && this.l3Buffer.upper32At(this.l3index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                case 3: {
                    if (this.LN > this.context[3] && this.context[3] > this.context[2] && this.context[2] > this.context[1]) {
                        int n7;
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int n8 = this.l1Buffer.lower32At(this.l1index);
                        if (n8 == -1) {
                            return false;
                        }
                        if (n8 != this.l2lower) {
                            return false;
                        }
                        int n9 = this.l2Buffer.size - 1;
                        for (n7 = this.l1index + 1; n7 < this.l1Buffer.size; ++n7) {
                            if (this.l1Buffer.lower32At(n7) == -1) continue;
                            n9 = this.l1Buffer.lower32At(n7) - 1;
                            break;
                        }
                        if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                            return false;
                        }
                        if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                            return false;
                        }
                        n8 = this.l2Buffer.lower32At(this.l2index);
                        if (n8 == -1) {
                            return false;
                        }
                        if (this.l3lower != n8) {
                            return false;
                        }
                        n9 = this.l3Buffer.size - 1;
                        for (n7 = this.l2index + 1; n7 < this.l2Buffer.size; ++n7) {
                            if (this.l2Buffer.lower32At(n7) == -1) continue;
                            n9 = this.l2Buffer.lower32At(n7) - 1;
                            break;
                        }
                        if (this.l3lower != n8) {
                            return false;
                        }
                        if (this.l3upper != n9) {
                            return false;
                        }
                        if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                            return false;
                        }
                        n8 = this.l3Buffer.lower32At(this.l3index);
                        if (n8 != -1) {
                            if (this.l4lower != n8) {
                                return false;
                            }
                            n9 = this.l4Buffer.size - 1;
                            for (n7 = this.l3index + 1; n7 < this.l3Buffer.size; ++n7) {
                                if (this.l3Buffer.lower32At(n7) == -1) continue;
                                n9 = this.l3Buffer.lower32At(n7) - 1;
                                break;
                            }
                            if (this.l4lower != n8) {
                                return false;
                            }
                            if (this.l4upper != n9) {
                                return false;
                            }
                            if (this.l4index > this.l4upper || this.l4index < this.l4lower) {
                                return false;
                            }
                            if (this.l4index != this.l4upper && this.l4Buffer.upper32At(this.l4index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (this.LN > this.context[3] && this.context[3] > this.context[2] && this.context[2] > this.context[1]) {
                        int n10;
                        if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                            return false;
                        }
                        int n11 = this.l1Buffer.lower32At(this.l1index);
                        if (n11 == -1) {
                            return false;
                        }
                        if (n11 != this.l2lower) {
                            return false;
                        }
                        int n12 = this.l2Buffer.size - 1;
                        for (n10 = this.l1index + 1; n10 < this.l1Buffer.size; ++n10) {
                            if (this.l1Buffer.lower32At(n10) == -1) continue;
                            n12 = this.l1Buffer.lower32At(n10) - 1;
                            break;
                        }
                        if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                            return false;
                        }
                        if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                            return false;
                        }
                        n11 = this.l2Buffer.lower32At(this.l2index);
                        if (n11 == -1) {
                            return false;
                        }
                        if (this.l3lower != n11) {
                            return false;
                        }
                        n12 = this.l3Buffer.size - 1;
                        for (n10 = this.l2index + 1; n10 < this.l2Buffer.size; ++n10) {
                            if (this.l2Buffer.lower32At(n10) == -1) continue;
                            n12 = this.l2Buffer.lower32At(n10) - 1;
                            break;
                        }
                        if (this.l3lower != n11) {
                            return false;
                        }
                        if (this.l3upper != n12) {
                            return false;
                        }
                        if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                            return false;
                        }
                        n11 = this.l3Buffer.lower32At(this.l3index);
                        if (n11 == -1) {
                            return false;
                        }
                        if (this.l4lower != n11) {
                            return false;
                        }
                        n12 = this.l4Buffer.size - 1;
                        for (n10 = this.l3index + 1; n10 < this.l3Buffer.size; ++n10) {
                            if (this.l3Buffer.lower32At(n10) == -1) continue;
                            n12 = this.l3Buffer.lower32At(n10) - 1;
                            break;
                        }
                        if (this.l4lower != n11) {
                            return false;
                        }
                        if (this.l4upper != n12) {
                            return false;
                        }
                        if (this.l4index > this.l4upper || this.l4index < this.l4lower) {
                            return false;
                        }
                        n11 = this.l4Buffer.lower32At(this.l4index);
                        if (n11 != -1) {
                            if (n11 != this.l5lower) {
                                return false;
                            }
                            n12 = this.l5Buffer.size - 1;
                            for (n10 = this.l4index + 1; n10 < this.l4Buffer.size; ++n10) {
                                if (this.l4Buffer.lower32At(n10) == -1) continue;
                                n12 = this.l4Buffer.lower32At(n10) - 1;
                                break;
                            }
                            if (this.l5lower != n11) {
                                return false;
                            }
                            if (this.l5upper != n12) {
                                return false;
                            }
                            if (this.l5index < n11 || this.l5index > n12) {
                                return false;
                            }
                            if (this.l5index != this.l5upper && this.l5Buffer.intAt(this.l5index) < this.LN) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
            }
            if (this.l1index < 0 || this.l1index > this.l1Buffer.size) {
                return false;
            }
            int n13 = this.l1Buffer.lower32At(this.l1index);
            if (n13 == -1) {
                return false;
            }
            if (n13 != this.l2lower) {
                return false;
            }
            int n14 = this.l2Buffer.size - 1;
            for (n = this.l1index + 1; n < this.l1Buffer.size; ++n) {
                if (this.l1Buffer.lower32At(n) == -1) continue;
                n14 = this.l1Buffer.lower32At(n) - 1;
                break;
            }
            if (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                return false;
            }
            if (this.l2index > this.l2upper || this.l2index < this.l2lower) {
                return false;
            }
            n13 = this.l2Buffer.lower32At(this.l2index);
            if (n13 == -1) {
                return false;
            }
            if (this.l3lower != n13) {
                return false;
            }
            n14 = this.l3Buffer.size - 1;
            for (n = this.l2index + 1; n < this.l2Buffer.size; ++n) {
                if (this.l2Buffer.lower32At(n) == -1) continue;
                n14 = this.l2Buffer.lower32At(n) - 1;
                break;
            }
            if (this.l3lower != n13) {
                return false;
            }
            if (this.l3upper != n14) {
                return false;
            }
            if (this.l3index > this.l3upper || this.l3index < this.l3lower) {
                return false;
            }
            n13 = this.l3Buffer.lower32At(this.l3index);
            if (n13 == -1) {
                return false;
            }
            if (this.l4lower != n13) {
                return false;
            }
            n14 = this.l4Buffer.size - 1;
            for (n = this.l3index + 1; n < this.l3Buffer.size; ++n) {
                if (this.l3Buffer.lower32At(n) == -1) continue;
                n14 = this.l3Buffer.lower32At(n) - 1;
                break;
            }
            if (this.l4lower != n13) {
                return false;
            }
            if (this.l4upper != n14) {
                return false;
            }
            if (this.l4index > this.l4upper || this.l4index < this.l4lower) {
                return false;
            }
            n13 = this.l4Buffer.lower32At(this.l4index);
            if (n13 != this.l5lower) {
                return false;
            }
            n14 = this.l5Buffer.size - 1;
            for (n = this.l4index + 1; n < this.l4Buffer.size; ++n) {
                if (this.l4Buffer.lower32At(n) == -1) continue;
                n14 = this.l4Buffer.lower32At(n) - 1;
                break;
            }
            if (this.l5lower != n13) {
                return false;
            }
            if (this.l5upper != n14) {
                return false;
            }
            if (this.l5index < n13 || this.l5index > n14) {
                return false;
            }
            if (this.context[this.context[0]] > this.LN) {
                return false;
            }
            if (this.context[0] == 5) {
                if (this.l5index != this.l5upper && this.l5Buffer.intAt(this.l5index) > this.LN) {
                    return false;
                }
                if (this.l5index + 1 <= this.l5Buffer.size - 1 && this.l5Buffer.intAt(this.l5index + 1) < this.LN) {
                    return false;
                }
            }
            return true;
        }
        switch (this.context[0]) {
            case -1: {
                return true;
            }
            case 0: {
                return true;
            }
            case 1: {
                return this.l1Buffer.upper32At(this.l1index) == this.context[1];
            }
            case 2: {
                return this.l1Buffer.upper32At(this.l1index) == this.context[1] && this.l2Buffer.upper32At(this.l2index) == this.context[2];
            }
            case 3: {
                return this.l1Buffer.upper32At(this.l1index) == this.context[1] && this.l2Buffer.upper32At(this.l2index) == this.context[2] && this.l3Buffer.upper32At(this.l3index) == this.context[3];
            }
            case 4: {
                return this.l1Buffer.upper32At(this.l1index) == this.context[1] && this.l2Buffer.upper32At(this.l2index) == this.context[2] && this.l3Buffer.upper32At(this.l3index) == this.context[3] && this.l4Buffer.upper32At(this.l4index) == this.context[4];
            }
        }
        return this.l1Buffer.upper32At(this.l1index) == this.context[1] && this.l2Buffer.upper32At(this.l2index) == this.context[2] && this.l3Buffer.upper32At(this.l3index) == this.context[3] && this.l4Buffer.upper32At(this.l4index) == this.context[4] && this.l5Buffer.intAt(this.l5index) == this.context[5];
    }
}

