/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.IByteBuffer;
import com.ximpleware.extended.ParseExceptionHuge;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class XMLMemMappedBuffer
implements IByteBuffer {
    MappedByteBuffer[] input;
    FileChannel fc;
    RandomAccessFile raf;
    String fn;
    long length;

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte byteAt(long l) {
        return this.input[(int)(l >> 30)].get((int)(l & 0x3FFFFFFFL));
    }

    public void readFile(String string) throws IOException, ParseExceptionHuge {
        long l;
        File file = new File(string);
        this.fn = string;
        this.length = l = file.length();
        if (l >= 0x4000000000L) {
            throw new ParseExceptionHuge("document too big > 256 Gbyte");
        }
        this.raf = new RandomAccessFile(string, "r");
        this.fc = this.raf.getChannel();
        int n = (int)(l >> 30) + ((l & 0x3FFFFFFFL) == 0L ? 0 : 1);
        this.input = new MappedByteBuffer[n];
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            if (i < n - 1) {
                this.input[i] = this.fc.map(FileChannel.MapMode.READ_ONLY, l2, 0x40000000L);
                l2 += 0x40000000L;
                continue;
            }
            this.input[i] = this.fc.map(FileChannel.MapMode.READ_ONLY, l2, l - ((long)i << 30));
        }
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(int n, int n2) {
        return null;
    }

    @Override
    public void writeToFileOutputStream(FileOutputStream fileOutputStream, long l, long l2) throws IOException {
        FileChannel fileChannel = fileOutputStream.getChannel();
        this.fc.transferTo(l, l2, fileChannel);
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

