/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int n, Expr expr) {
        this.op = n;
        this.operand = expr;
    }

    @Override
    public String toString() {
        return "-" + this.operand;
    }

    @Override
    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        return this.operand.evalBoolean(vTDNavHuge);
    }

    @Override
    public double evalNumber(VTDNavHuge vTDNavHuge) {
        return -1.0 * this.operand.evalNumber(vTDNavHuge);
    }

    @Override
    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("UnaryExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNavHuge vTDNavHuge) {
        double d = this.operand.evalNumber(vTDNavHuge);
        if (d == (double)((int)d)) {
            return "" + (int)d;
        }
        return "" + d;
    }

    @Override
    public void reset(VTDNavHuge vTDNavHuge) {
        this.operand.reset(vTDNavHuge);
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    @Override
    public void setContextSize(int n) {
        this.operand.setContextSize(n);
    }

    @Override
    public void setPosition(int n) {
        this.operand.setPosition(n);
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

